/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.quadtree;

import com.mapinfo.mapmarker.autosuggest.utils.quadtree.AbstractQuad;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.DiskQuadLeaf;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.DiskQuadTreeItem;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.QuadLeaf;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.QuadTree;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.Rectangle;
import com.mapinfo.mapmarker.cgge.utils.io.DataStreamFactory;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInputStream;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataOutput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataStream;
import com.mapinfo.mapmarker.cgge.utils.io.IOUtil;
import java.io.File;
import java.io.IOException;

public class DiskQuadTree<T extends DiskQuadTreeItem>
extends QuadTree<T> {
    private final T valueType;

    public DiskQuadTree(int maxQuadItems, T valueType) {
        super(maxQuadItems);
        this.valueType = valueType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends DiskQuadTreeItem> void write(String fullPath, QuadTree<T> quadTree) throws IOException {
        try (ICGGEDataStream dataStream = null;){
            dataStream = DataStreamFactory.getDataStream((File)new File(fullPath), (IOUtil.IO_MODE)IOUtil.IO_MODE.READ_WRITE, (boolean)false);
            DiskQuadTree<Object> diskTree = new DiskQuadTree<Object>(quadTree.getMaxQuadItems(), null);
            diskTree.setRoot(quadTree.getRoot());
            diskTree.write(dataStream);
        }
    }

    void write(ICGGEDataStream dataStream) throws IOException {
        dataStream.writeInt(this.getMaxQuadItems());
        AbstractQuad root = this.getRoot();
        dataStream.writeBoolean(root.isLeaf());
        root.write((ICGGEDataOutput)dataStream);
    }

    public static <T extends DiskQuadTreeItem> QuadTree<T> read(ICGGEDataInputStream dataStream, T valueType) throws IOException {
        int maxQuadItems = dataStream.readInt();
        DiskQuadTree<T> quadTree = new DiskQuadTree<T>(maxQuadItems, valueType);
        super.readRoot(dataStream);
        return quadTree;
    }

    public DiskQuadTreeItem getValueType() {
        return this.valueType;
    }

    @Override
    protected QuadLeaf getNewQuadLeaf(Rectangle bounds, int quadID) {
        return new DiskQuadLeaf(bounds, this, quadID);
    }

    private void readRoot(ICGGEDataInputStream dataStream) throws IOException {
        boolean isleaf = dataStream.readBoolean();
        AbstractQuad root = null;
        root = isleaf ? this.getNewQuadLeaf(null) : this.getNewQuadNode(null);
        root.read((ICGGEDataInput)dataStream);
        this.setRoot(root);
    }
}

