/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.quadtree;

import com.mapinfo.mapmarker.autosuggest.utils.GeomUtil;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.AbstractQuad;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.DiskQuadTree;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.DiskQuadTreeItem;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.GeoHashLeaf;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.IQuadTreeItem;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.QuadLeaf;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.QuadTree;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.Rectangle;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.DataReadException;
import com.mapinfo.mapmarker.cgge.utils.io.DataStreamFactory;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInputStream;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataStream;
import com.mapinfo.mapmarker.cgge.utils.io.IOUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GeoHashTree<T extends DiskQuadTreeItem>
extends DiskQuadTree<T> {
    private static final long UID = 2315357671757835169L;
    public static int MAX_DEPTH = 16;

    private GeoHashTree(QuadTree<T> quadTree) {
        super(quadTree.getMaxQuadItems(), null);
        this.setRoot(quadTree.getRoot());
    }

    public GeoHashTree(int maxQuadItems, T valueType, Rectangle treeMBR) {
        super(maxQuadItems, valueType);
        this.setRoot(this.getNewQuadLeaf(treeMBR));
    }

    @Override
    public void addItem(T item) {
        AbstractQuad newQuad = this.add(this.getRoot(), item);
        if (newQuad != null) {
            this.setRoot(newQuad);
        }
    }

    private AbstractQuad add(AbstractQuad quad, T item) {
        AbstractQuad newParentQuad = null;
        newParentQuad = quad.isLeaf() ? quad.add((IQuadTreeItem)item) : quad.add((IQuadTreeItem)item);
        return newParentQuad;
    }

    @Override
    protected QuadLeaf getNewQuadLeaf(Rectangle bounds) {
        return new GeoHashLeaf(bounds, this, 0);
    }

    public int getGeoHash(Rectangle rect) {
        AbstractQuad quad = this.findLowestQuad(rect);
        if (quad != null) {
            return quad.getQuadID();
        }
        return 0;
    }

    public List<QuadLeaf> getLeafQuads() {
        ArrayList<QuadLeaf> list = new ArrayList<QuadLeaf>(100);
        this.addLeafQuads(this.getRoot(), list);
        return list;
    }

    private void addLeafQuads(AbstractQuad quad, List<QuadLeaf> list) {
        if (quad.isLeaf()) {
            list.add((QuadLeaf)quad);
        } else {
            for (IQuadTreeItem childQuad : quad.getChildren()) {
                this.addLeafQuads((AbstractQuad)childQuad, list);
            }
        }
    }

    protected static int getGeoHash(int level, int parentHash, GeomUtil.Direction quadPos) {
        int quadHash = 0;
        switch (quadPos) {
            case NW: {
                quadHash = 0;
                break;
            }
            case NE: {
                quadHash = 1;
                break;
            }
            case SW: {
                quadHash = 2;
                break;
            }
            case SE: {
                quadHash = 3;
            }
        }
        int geoHash = parentHash | quadHash << (level - 1) * 2;
        return geoHash;
    }

    public void write(String fullPath) throws IOException {
        try (ICGGEDataStream dataStream = null;){
            dataStream = DataStreamFactory.getDataStream((String)fullPath, (IOUtil.IO_MODE)IOUtil.IO_MODE.READ_WRITE, (boolean)false);
            dataStream.writeLong(2315357671757835169L);
            super.write(dataStream);
        }
    }

    public static <T extends DiskQuadTreeItem> GeoHashTree<T> load(String fullPath, T valueType) throws IOException {
        ICGGEDataStream dataStream = DataStreamFactory.getDataStream((String)fullPath, (IOUtil.IO_MODE)IOUtil.IO_MODE.READ_ONLY, (boolean)false);
        long treeUID = dataStream.readLong();
        if (treeUID != 2315357671757835169L) {
            throw new DataReadException("not a GeoHash Tree");
        }
        QuadTree<T> quadTree = GeoHashTree.read((ICGGEDataInputStream)dataStream, valueType);
        return new GeoHashTree<T>(quadTree);
    }
}

