/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.quadtree;

import com.mapinfo.mapmarker.autosuggest.utils.quadtree.AbstractQuad;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.IQuadTreeItem;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.InternalQuadTreeException;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.QuadTree;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.Rectangle;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class QuadNode
extends AbstractQuad {
    private static final int MAX_CHILD = 4;

    public QuadNode(Rectangle bounds, QuadTree<? extends IQuadTreeItem> tree, int quadID) {
        super(bounds, tree, quadID);
    }

    @Override
    protected void addChild(IQuadTreeItem item) {
        if (super.getChildCount() >= 4) {
            throw new InternalQuadTreeException("Only 4 child quads allowed");
        }
        super.addChild(item);
    }

    @Override
    public AbstractQuad add(IQuadTreeItem item) {
        List<IQuadTreeItem> quads = this.getChildren();
        int c = quads.size();
        for (int i = 0; i < c; ++i) {
            AbstractQuad newQuad;
            AbstractQuad quad = (AbstractQuad)quads.get(i);
            if (!quad.intersects(item) || (newQuad = quad.add(item)) == null) continue;
            quads.set(i, newQuad);
        }
        return null;
    }

    @Override
    public void readChildren(ICGGEDataInput in) throws IOException {
        IQuadTreeItem[] children = new IQuadTreeItem[4];
        QuadTree<? extends IQuadTreeItem> tree = this.getTree();
        for (int i = 0; i < 4; ++i) {
            boolean isLeaf = in.readBoolean();
            AbstractQuad quad = null;
            quad = isLeaf ? tree.getNewQuadLeaf(null) : tree.getNewQuadNode(null);
            quad.read(in);
            children[i] = quad;
        }
        if (children != null) {
            this.setChildren(Arrays.asList(children));
        }
    }

    @Override
    public void writeChildren(ICGGEDataOutput out) throws IOException {
        List<IQuadTreeItem> children = this.getChildren();
        int count = children.size();
        for (int i = 0; i < count; ++i) {
            AbstractQuad quad = (AbstractQuad)children.get(i);
            out.writeBoolean(quad.isLeaf());
            quad.write(out);
        }
    }

    @Override
    public boolean isLeaf() {
        return false;
    }
}

