/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.quadtree;

import com.mapinfo.mapmarker.autosuggest.utils.GeomUtil;
import com.mapinfo.mapmarker.autosuggest.utils.LongLatBox;
import com.mapinfo.mapmarker.autosuggest.utils.NumberRange;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.AbstractQuad;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.IQuadTreeItem;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.IQuadTreeResults;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.QuadLeaf;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.QuadNode;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.QuadTreeUtils;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class QuadTree<T extends IQuadTreeItem> {
    private static final double BUFFER_VALUE = 0.001;
    private AbstractQuad root;
    private final int maxQuadItems;
    private int nextQuadID = 1;

    public QuadTree(int maxQuadItems) {
        this.maxQuadItems = maxQuadItems;
    }

    public int getMaxQuadItems() {
        return this.maxQuadItems;
    }

    public void addItem(T item) {
        AbstractQuad newNode;
        if (this.root == null) {
            Rectangle bounds = new Rectangle(item.getBounds());
            bounds.buffer(0.001);
            this.root = this.getNewQuadLeaf(bounds, this.nextQuadID++);
        }
        if ((newNode = this.add(this.root, (IQuadTreeItem)item)) != null) {
            this.root = newNode;
        }
    }

    protected void setRoot(AbstractQuad root) {
        this.root = root;
    }

    protected AbstractQuad getRoot() {
        return this.root;
    }

    private AbstractQuad add(AbstractQuad node, IQuadTreeItem item) {
        AbstractQuad newNode1 = this.accomodateItem(node, item);
        AbstractQuad newNode2 = newNode1.add(item);
        return newNode2 == null ? newNode1 : newNode2;
    }

    private AbstractQuad accomodateItem(AbstractQuad node, IQuadTreeItem item) {
        AbstractQuad retNode = node;
        Rectangle itemBounds = item.getBounds();
        if (!node.getBounds().fullyContains(itemBounds)) {
            if (node.isLeaf()) {
                this.expandNode(node, itemBounds);
            } else {
                retNode = this.createParentQuad(node, item);
                retNode = this.accomodateItem(retNode, item);
            }
        }
        return retNode;
    }

    protected AbstractQuad findLowestQuad(Rectangle bounds) {
        AbstractQuad quad = this.root;
        if (this.intersects(quad, bounds) && quad.getBounds().fullyContains(bounds)) {
            return this.findLowestQuad(quad, bounds);
        }
        return null;
    }

    private AbstractQuad findLowestQuad(AbstractQuad quad, Rectangle bounds) {
        if (this.intersects(quad, bounds)) {
            if (quad.isLeaf()) {
                return quad;
            }
            AbstractQuad intersectingQuad = null;
            List<IQuadTreeItem> children = quad.getChildren();
            for (IQuadTreeItem child : children) {
                AbstractQuad childQuad = (AbstractQuad)child;
                if (!this.intersects(childQuad, bounds)) continue;
                if (intersectingQuad != null) {
                    intersectingQuad = null;
                    break;
                }
                intersectingQuad = childQuad;
            }
            return intersectingQuad != null ? this.findLowestQuad(intersectingQuad, bounds) : quad;
        }
        return null;
    }

    public List<T> findValues(Rectangle bounds) {
        QuadTreeResults results = new QuadTreeResults();
        this.internalFindValues(bounds, null, results);
        Collection resultList = results.getItems();
        return resultList.isEmpty() ? null : new ArrayList(resultList);
    }

    public void findValues(Rectangle bounds, double[] centerPoint, IQuadTreeResults<T> results) {
        this.internalFindValues(bounds, centerPoint, results);
    }

    private void internalFindValues(Rectangle bounds, double[] centerPoint, IQuadTreeResults<T> results) {
        AbstractQuad quad = this.root;
        if (this.intersects(quad, bounds)) {
            this.addValues(quad, results, bounds, centerPoint, bounds.fullyContains(quad.getBounds()));
        }
    }

    private void addValues(AbstractQuad quad, IQuadTreeResults<T> results, Rectangle bounds, double[] centerPoint, boolean quadFullyWithSearchArea) {
        int childCount = quad.getChildCount();
        if (childCount > 0) {
            List<IQuadTreeItem> children = quad.getChildren();
            if (quad.isLeaf()) {
                this.addQuadValues(quad, centerPoint, quadFullyWithSearchArea ? null : bounds, results);
            } else {
                for (IQuadTreeItem child : children) {
                    if (!quadFullyWithSearchArea && !this.intersects(child, bounds)) continue;
                    boolean childQuadFullyWithinSearchAreas = quadFullyWithSearchArea ? true : bounds.fullyContains(child.getBounds());
                    this.addValues((AbstractQuad)child, results, bounds, centerPoint, childQuadFullyWithinSearchAreas);
                }
            }
        }
    }

    private void addQuadValues(AbstractQuad quad, double[] centerPoint, Rectangle checkBounds, IQuadTreeResults<T> results) {
        List<IQuadTreeItem> items = quad.getChildren();
        Rectangle newBounds = null;
        if (checkBounds != null) {
            ArrayList<IQuadTreeItem> retainedItems = new ArrayList<IQuadTreeItem>(items.size());
            newBounds = this.retainItemsWithinBounds(items, checkBounds, retainedItems);
            items = retainedItems;
        }
        if (!items.isEmpty()) {
            NumberRange distRange = null;
            if (centerPoint != null) {
                distRange = newBounds != null ? newBounds.distancesFromPoint(centerPoint) : QuadTreeUtils.calculateNumberRange(quad, centerPoint);
            }
            results.add(items, distRange);
        }
    }

    private Rectangle retainItemsWithinBounds(Collection<T> items, Rectangle checkBounds, Collection<T> retainedItems) {
        LongLatBox newBounds = null;
        for (IQuadTreeItem item : items) {
            Rectangle itemBounds = item.getBounds();
            if (!checkBounds.intersects(itemBounds)) continue;
            retainedItems.add(item);
            if (newBounds == null) {
                newBounds = new Rectangle(itemBounds);
                continue;
            }
            newBounds.expandToInclude(itemBounds);
        }
        return newBounds;
    }

    private boolean intersects(IQuadTreeItem quad, Rectangle rect) {
        return quad.getBounds().intersects(rect);
    }

    private void expandNode(AbstractQuad node, Rectangle itemBounds) {
        Rectangle rect = node.getBounds();
        rect.expandToInclude(itemBounds);
        rect.buffer(0.001);
        node.setBounds(rect);
    }

    private AbstractQuad createParentQuad(AbstractQuad node, IQuadTreeItem item) {
        GeomUtil.Direction d = this.getExpandDirection(node, item);
        Rectangle newBounds = this.quadExpand(node.getBounds(), d);
        QuadNode newNode = this.getNewQuadNode(newBounds, this.nextQuadID++);
        for (GeomUtil.Direction dir : GeomUtil.Direction.values()) {
            if (dir == d) {
                newNode.addChild(node);
                continue;
            }
            newNode.addChild(this.getNewQuadLeaf(GeomUtil.quadSplit(newBounds, dir), this.nextQuadID++));
        }
        return newNode;
    }

    private Rectangle quadExpand(Rectangle rect, GeomUtil.Direction d) {
        double bottomLeftX = rect.getWest();
        double bottomLeftY = rect.getSouth();
        double topRightX = rect.getEast();
        double topRightY = rect.getNorth();
        double height = rect.getHeight();
        double width = rect.getWidth();
        switch (d) {
            case NW: {
                bottomLeftY -= height;
                topRightX += width;
                break;
            }
            case NE: {
                bottomLeftX -= width;
                bottomLeftY -= height;
                break;
            }
            case SW: {
                topRightX += width;
                topRightY += height;
                break;
            }
            case SE: {
                bottomLeftX -= width;
                topRightY += height;
            }
        }
        return new Rectangle(bottomLeftX, bottomLeftY, topRightX, topRightY);
    }

    private GeomUtil.Direction getExpandDirection(AbstractQuad node, IQuadTreeItem item) {
        double[] mid2;
        double[] mid1 = node.getBounds().getMidPoint();
        if (mid1[0] <= (mid2 = item.getBounds().getMidPoint())[0]) {
            return mid1[1] <= mid2[1] ? GeomUtil.Direction.SW : GeomUtil.Direction.NW;
        }
        return mid1[1] <= mid2[1] ? GeomUtil.Direction.SE : GeomUtil.Direction.NE;
    }

    protected QuadNode getNewQuadNode(Rectangle bounds) {
        return new QuadNode(bounds, this, this.nextQuadID++);
    }

    private QuadNode getNewQuadNode(Rectangle bounds, int quadID) {
        return new QuadNode(bounds, this, quadID);
    }

    protected QuadLeaf getNewQuadLeaf(Rectangle bounds) {
        return this.getNewQuadLeaf(bounds, this.nextQuadID++);
    }

    protected QuadLeaf getNewQuadLeaf(Rectangle bounds, int quadID) {
        return new QuadLeaf(bounds, this, quadID);
    }

    public Rectangle getExtends() {
        return this.root == null ? null : this.root.getBounds();
    }

    public int hashCode() {
        return 31 * (this.root == null ? 1 : this.root.getChildCount());
    }

    private static final class QuadTreeResults<T>
    implements IQuadTreeResults<T> {
        Set<T> m_results = new HashSet<T>();

        private QuadTreeResults() {
        }

        @Override
        public Iterator<T> iterator() {
            throw new UnsupportedOperationException();
        }

        Collection<T> getItems() {
            return this.m_results;
        }

        @Override
        public void add(Collection<T> items, NumberRange distances) {
            this.m_results.addAll(items);
        }
    }
}

