/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.radixtree;

import com.mapinfo.mapmarker.autosuggest.utils.radixtree.ITreeNode;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.RadixTreeUtils;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractTreeNode<C extends Comparable<C>, V>
implements ITreeNode<V> {
    private char[] m_key;
    private List<C> m_children;
    private V m_value;

    @Override
    public void setKey(char[] key) {
        this.m_key = key;
    }

    @Override
    public int compareTo(ITreeNode<V> o) {
        return RadixTreeUtils.compareChars(this.m_key, o.getKey());
    }

    @Override
    public char[] getKey() {
        return this.m_key;
    }

    @Override
    public V getValue() {
        return this.m_value;
    }

    @Override
    public void setValue(V value) {
        this.m_value = value;
    }

    @Override
    public boolean hasValue() {
        return this.m_value != null;
    }

    @Override
    public boolean hasChildren() {
        return this.getChildCount() > 0;
    }

    @Override
    public int getChildCount() {
        return this.m_children == null ? 0 : this.m_children.size();
    }

    @Override
    public int getKeyLength() {
        return this.m_key == null ? 0 : this.m_key.length;
    }

    public List<C> getChildren() {
        return this.m_children;
    }

    @Override
    public void removeChildren() {
        this.m_children = null;
    }

    public C getChild(int ndx) {
        return (C)((Comparable)this.m_children.get(ndx));
    }

    public void addChild(C child) {
        if (this.m_children == null) {
            this.m_children = new ArrayList<C>(3);
        }
        ListUtils.insertToSortedList(this.m_children, child);
    }

    protected void setChildren(List<C> children) {
        this.m_children = children;
    }

    protected void copyChildren(AbstractTreeNode<C, V> copyFrom) {
        this.removeChildren();
        if (copyFrom.hasChildren()) {
            this.setChildren(copyFrom.getChildren());
        }
    }

    @Override
    public char[] getChildKey(int ndx) {
        return this.getChildNode(ndx).getKey();
    }

    @Override
    public List<char[]> getChildKeys() {
        int childCount = this.getChildCount();
        if (childCount > 0) {
            char[][] childKeys = new char[childCount][];
            for (int childNdx = 0; childNdx < childCount; ++childNdx) {
                childKeys[childNdx] = this.getChildKey(childNdx);
            }
            return Arrays.asList(childKeys);
        }
        return null;
    }
}

