/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.radixtree;

import com.mapinfo.mapmarker.autosuggest.exception.CGGELevelException;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.DiskTreeNode;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.INodeValueFilter;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.IRadixTreeMetaData;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.ITreeNode;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.RadixTree;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.TreeNode;
import com.mapinfo.mapmarker.cgge.utils.io.DataStreamFactory;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEConcurrentDataInputStream;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInputStream;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataOutput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataStream;
import com.mapinfo.mapmarker.cgge.utils.io.IDataItem;
import com.mapinfo.mapmarker.cgge.utils.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class DiskRadixTree<V extends IDataItem>
extends RadixTree<V> {
    private ICGGEDataInputStream m_dataStream = null;
    private IRadixTreeMetaData m_metaData = null;
    private final V m_valueType;
    private boolean m_supportConcurrantReads = false;

    public DiskRadixTree(V valueType) {
        this.setCanModify(false);
        this.m_valueType = valueType;
    }

    public void load(String filePath, IRadixTreeMetaData metaData) throws IOException, CGGELevelException {
        this.load(filePath, metaData, false);
    }

    public void load(String filePath, IRadixTreeMetaData metaData, boolean memoryMapped) throws CGGELevelException, IOException {
        ICGGEDataInputStream dataStream = this.internalGetDataStream(filePath, IOUtil.IO_MODE.READ_ONLY, memoryMapped);
        this.load(dataStream, metaData, memoryMapped);
    }

    public void load(ICGGEDataInputStream dataStream, IRadixTreeMetaData metaData, boolean memoryMapped) throws IOException, CGGELevelException {
        this.m_dataStream = dataStream;
        this.m_supportConcurrantReads = this.m_dataStream instanceof ICGGEConcurrentDataInputStream;
        this.m_metaData = metaData;
        this.init();
    }

    public RadixTree<V> readFully() {
        RadixTree radixTree = new RadixTree();
        radixTree.setSize(this.size());
        radixTree.setRoot(this.convertNode(this.getRootNode()));
        return radixTree;
    }

    private ITreeNode<V> convertNode(ITreeNode<V> node) {
        TreeNode<V> treeNode = new TreeNode<V>();
        treeNode.setKey(node.getKey());
        treeNode.setValue(node.getValue());
        int childCount = node.getChildCount();
        if (childCount > 0) {
            ArrayList<ITreeNode<V>> children = new ArrayList<ITreeNode<V>>(childCount);
            for (int i = 0; i < childCount; ++i) {
                ITreeNode<V> childNode = this.convertNode(node.getChildNode(i));
                children.add(childNode);
            }
            treeNode.setChildren(children);
        }
        return treeNode;
    }

    protected ICGGEDataInputStream internalGetDataStream(String filePath, IOUtil.IO_MODE mode, boolean memoryMapped) throws CGGELevelException {
        ICGGEConcurrentDataInputStream icggeConcurrentDIS = null;
        try {
            icggeConcurrentDIS = DataStreamFactory.getConcurrentDataInputStream((String)filePath, (int)4096, (int)5120);
        }
        catch (IOException ioe) {
            throw new CGGELevelException(ioe);
        }
        return icggeConcurrentDIS;
    }

    protected void init() throws IOException, CGGELevelException {
        this.setSize(this.m_dataStream.readInt());
        this.m_metaData.read((DataInput)this.m_dataStream);
        long rootNodeOffset = this.m_dataStream.readLong();
        if (rootNodeOffset >= 0L) {
            DiskTreeNode<V> rootNode = this.readNodeAt(rootNodeOffset);
            this.setRoot(rootNode);
        }
    }

    public IRadixTreeMetaData getMetaData() {
        return this.m_metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V extends IDataItem> void write(RadixTree<V> tree, IRadixTreeMetaData metaData, String outFile) throws IOException, InstantiationException, IllegalAccessException {
        try (ICGGEDataStream dataAccess = null;){
            dataAccess = DataStreamFactory.getDataStream((String)outFile, (IOUtil.IO_MODE)IOUtil.IO_MODE.READ_WRITE, (boolean)false);
            DiskRadixTree.write(tree, metaData, dataAccess);
        }
    }

    public static <V extends IDataItem> void write(RadixTree<V> tree, IRadixTreeMetaData metaData, ICGGEDataStream dataAccess) throws IOException {
        int size = tree.size();
        DiskRadixTree.writeHeaders(dataAccess, size, metaData);
        long rootPointerOffset = dataAccess.offset();
        long rootOffset = -1L;
        dataAccess.writeLong(rootOffset);
        if (size > 0) {
            rootOffset = DiskRadixTree.writeTree(tree, dataAccess);
        }
        dataAccess.seek(rootPointerOffset);
        dataAccess.writeLong(rootOffset);
    }

    private static <V extends IDataItem> long writeTree(RadixTree<V> tree, ICGGEDataStream stream) throws IOException {
        long rootOffset = stream.offset();
        DiskRadixTree.writeNode(tree.getRootNode(), stream);
        return rootOffset;
    }

    private static <V extends IDataItem> List<Integer> writeNode(ITreeNode<V> node, ICGGEDataStream stream) throws IOException {
        DiskTreeNode<V> diskTreeNode = new DiskTreeNode<V>(null);
        diskTreeNode.write(node, stream);
        return diskTreeNode.getChildren();
    }

    private static void writeHeaders(ICGGEDataStream dataAccess, int size, IRadixTreeMetaData metaData) throws IOException {
        dataAccess.seek(0L);
        dataAccess.writeInt(size);
        metaData.write((DataOutput)dataAccess);
    }

    public static <K extends CharSequence, V extends IDataItem> void createRTree(Map<K, V> keyValueMap, IRadixTreeMetaData metaData, String outFile) throws IOException {
        ICGGEDataStream dataStream = DataStreamFactory.getDataStream((String)outFile, (IOUtil.IO_MODE)IOUtil.IO_MODE.READ_WRITE, (boolean)false);
        DiskRadixTree.createRTree(keyValueMap, metaData, dataStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K extends CharSequence, V extends IDataItem> void createRTree(Map<K, V> keyValueMap, IRadixTreeMetaData metaData, ICGGEDataStream dataStream) throws IOException {
        try {
            DiskRadixTree.writeHeaders(dataStream, 0, metaData);
            dataStream.writeLong(-1L);
            List<Integer> childOffsets = DiskRadixTree.writeTreeAndReturnChildOffsets(keyValueMap, dataStream);
            long rootNodeOffset = dataStream.seekEnd();
            DiskTreeNode diskTreeNode = new DiskTreeNode(null);
            diskTreeNode.setChildren(childOffsets);
            diskTreeNode.write((ICGGEDataOutput)dataStream);
            DiskRadixTree.writeHeaders(dataStream, keyValueMap.size(), metaData);
            dataStream.writeLong(rootNodeOffset);
        }
        finally {
            if (dataStream != null) {
                dataStream.close();
            }
        }
    }

    private static <K extends CharSequence, V extends IDataItem> List<Integer> writeTreeAndReturnChildOffsets(Map<K, V> keyValueMap, ICGGEDataStream dataStream) throws IOException {
        RadixTree<IDataItem> rtree = new RadixTree<IDataItem>();
        ArrayList<Integer> rootChildOffsets = new ArrayList<Integer>(20);
        boolean first = true;
        char lastFirstCh = '\u0000';
        for (Map.Entry<K, V> en : keyValueMap.entrySet()) {
            String word = ((CharSequence)en.getKey()).toString();
            IDataItem v = (IDataItem)en.getValue();
            char firstCh = word.charAt(0);
            if (firstCh != lastFirstCh) {
                if (first) {
                    first = false;
                } else {
                    List<Integer> childOffsets = DiskRadixTree.writeNode(rtree.getRootNode(), dataStream);
                    rootChildOffsets.addAll(childOffsets);
                }
                rtree = new RadixTree();
                lastFirstCh = firstCh;
            }
            rtree.add(word, v);
        }
        if (rtree.size() > 0) {
            List<Integer> childOffsets = DiskRadixTree.writeNode(rtree.getRootNode(), dataStream);
            rootChildOffsets.addAll(childOffsets);
        }
        return rootChildOffsets;
    }

    public V getNewValueInstance() throws CGGELevelException {
        IDataItem v = null;
        try {
            v = this.m_valueType.getNewInstance();
        }
        catch (RuntimeException runE) {
            throw runE;
        }
        catch (Exception e) {
            throw new CGGELevelException(e);
        }
        return (V)v;
    }

    public DiskTreeNode<V> getNewNodeInstance() {
        return new DiskTreeNode(this);
    }

    void setDataStream(ICGGEDataInputStream stream) {
        this.m_dataStream = stream;
    }

    public DiskTreeNode<V> readNodeAt(long childPos) throws IOException, CGGELevelException {
        return this.readNodeAt(childPos, null);
    }

    public char[] readKeyAt(long childPos) throws IOException {
        DiskTreeNode<V> node = this.getNewNodeInstance();
        ICGGEDataInputStream dataStream = this.getInputStream(childPos);
        node.readKey((DataInput)dataStream);
        return node.getKey();
    }

    public List<char[]> readKeysAt(List<Integer> childOffsets) throws IOException, CGGELevelException {
        DiskTreeNode<V> node = this.getNewNodeInstance();
        int childCount = childOffsets.size();
        char[][] childKeys = new char[childCount][];
        ICGGEDataInputStream dataStream = this.getInputStream(childOffsets.get(0).intValue());
        for (int i = 0; i < childCount; ++i) {
            dataStream.seek((long)childOffsets.get(i).intValue());
            node.readKey((DataInput)dataStream);
            childKeys[i] = node.getKey();
        }
        return Arrays.asList(childKeys);
    }

    public DiskTreeNode<V> readNodeAt(long childPos, INodeValueFilter<V> nodeValueFilter) throws IOException, CGGELevelException {
        DiskTreeNode<V> node = this.getNewNodeInstance();
        ICGGEDataInputStream dataStream = this.getInputStream(childPos);
        node.read((ICGGEDataInput)dataStream, nodeValueFilter);
        return node;
    }

    private ICGGEDataInputStream getInputStream(long offset) throws IOException {
        if (this.m_supportConcurrantReads) {
            return ((ICGGEConcurrentDataInputStream)this.m_dataStream).duplicate(offset);
        }
        this.m_dataStream.seek(offset);
        return this.m_dataStream;
    }
}

