/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.radixtree;

import com.mapinfo.mapmarker.autosuggest.exception.CGGELevelException;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.AbstractTreeNode;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.DataReadException;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.DiskRadixTree;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.IFilterableNodeValue;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.INodeValueFilter;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.ITreeNode;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataOutput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataStream;
import com.mapinfo.mapmarker.cgge.utils.io.IDataItem;
import java.io.DataInput;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;

public class DiskTreeNode<V extends IDataItem>
extends AbstractTreeNode<Integer, V> {
    private final DiskRadixTree<V> m_tree;

    DiskTreeNode(DiskRadixTree<V> tree) {
        this.m_tree = tree;
        this.setKey(new char[0]);
    }

    void write(ICGGEDataOutput out) throws IOException {
        DiskTreeNode.writeKey(out, this.getKey());
        DiskTreeNode.writeValue(out, (IDataItem)this.getValue());
        this.writeChildOffsets(out, IntArray.asArray(this.getChildren()));
    }

    public void write(ITreeNode<V> node, ICGGEDataStream out) throws IOException {
        DiskTreeNode.writeKey((ICGGEDataOutput)out, node.getKey());
        DiskTreeNode.writeValue((ICGGEDataOutput)out, (IDataItem)node.getValue());
        List<Integer> offsets = this.writeChildren(node, out);
        this.setChildren(offsets);
    }

    private List<Integer> writeChildren(ITreeNode<V> node, ICGGEDataStream out) throws IOException {
        int size = node.getChildCount();
        int[] childOffsets = new int[size];
        long childStart = out.offset();
        this.writeChildOffsets((ICGGEDataOutput)out, childOffsets);
        if (size > 0) {
            Iterator<ITreeNode<V>> children = node.getChildNodes().iterator();
            for (int i = 0; i < size; ++i) {
                int offset = (int)out.offset();
                this.write(children.next(), out);
                childOffsets[i] = offset;
            }
        }
        out.seek(childStart);
        this.writeChildOffsets((ICGGEDataOutput)out, childOffsets);
        out.seekEnd();
        return IntArray.asList((int[])childOffsets);
    }

    private void writeChildOffsets(ICGGEDataOutput out, int[] offsets) throws IOException {
        int size = offsets.length;
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            out.writeInt(offsets[i]);
        }
    }

    private static void writeValue(ICGGEDataOutput out, IDataItem value) throws IOException {
        if (value != null) {
            out.writeBoolean(true);
            value.write(out);
        } else {
            out.writeBoolean(false);
        }
    }

    private static void writeKey(ICGGEDataOutput out, char[] key) throws IOException {
        String strKey = new String(key);
        out.writeUTF(strKey);
    }

    void read(ICGGEDataInput in) throws IOException, CGGELevelException {
        this.read(in, null);
    }

    void read(ICGGEDataInput in, INodeValueFilter<V> nodeFilter) throws IOException, CGGELevelException {
        this.readKey((DataInput)in);
        this.readValue(in, nodeFilter);
        this.readChildOffsets(in);
    }

    private void readValue(ICGGEDataInput in, INodeValueFilter<V> nodeFilter) throws IOException, CGGELevelException {
        boolean hasValue = in.readBoolean();
        Object v = null;
        if (hasValue) {
            v = this.m_tree.getNewValueInstance();
            if (nodeFilter != null && v instanceof IFilterableNodeValue) {
                IFilterableNodeValue filterableValue = (IFilterableNodeValue)v;
                filterableValue.read(in, nodeFilter);
                if (!filterableValue.isUsable()) {
                    v = this.m_tree.getNewValueInstance();
                }
            } else {
                v.read(in);
            }
        }
        this.setValue(v);
    }

    void readKey(DataInput in) throws IOException {
        String str = in.readUTF();
        this.setKey(str.toCharArray());
    }

    private void readChildOffsets(ICGGEDataInput in) throws IOException {
        this.removeChildren();
        int size = in.readInt();
        if (size > 0) {
            int[] array = new int[size];
            in.readInts(array);
            this.setChildren(IntArray.wrap((int[])array).asList());
        }
    }

    @Override
    public List<ITreeNode<V>> getChildNodes() {
        return new AbstractList<ITreeNode<V>>(){

            @Override
            public int size() {
                return DiskTreeNode.this.getChildCount();
            }

            @Override
            public ITreeNode<V> get(int index) {
                return DiskTreeNode.this.getChildNode(index);
            }
        };
    }

    @Override
    public ITreeNode<V> getChildNode(int ndx) {
        DiskTreeNode<V> node = null;
        try {
            node = this.m_tree.readNodeAt(((Integer)this.getChild(ndx)).intValue());
            return node;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DataReadException(e);
        }
    }

    @Override
    public void addChild(Integer child) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addChildNode(ITreeNode<V> node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ITreeNode<V> getChildNode(int ndx, INodeValueFilter<V> nodeValueFilter) {
        try {
            DiskTreeNode<V> node = this.m_tree.readNodeAt(((Integer)this.getChild(ndx)).intValue(), nodeValueFilter);
            return node;
        }
        catch (Exception e) {
            throw new DataReadException(e);
        }
    }

    @Override
    public char[] getChildKey(int ndx) {
        try {
            return this.m_tree.readKeyAt(((Integer)this.getChild(ndx)).intValue());
        }
        catch (Exception e) {
            throw new DataReadException(e);
        }
    }

    @Override
    public List<char[]> getChildKeys() {
        try {
            return this.m_tree.readKeysAt(this.getChildren());
        }
        catch (Exception e) {
            throw new DataReadException(e);
        }
    }
}

