/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.radixtree;

public class MatchStats
implements Comparable<MatchStats> {
    private final boolean m_fullMatch;
    private final int m_weight;
    private final int m_targetMatchLen;

    public MatchStats(boolean fullMatch, int weight, int targetMatchLen) {
        this.m_fullMatch = fullMatch;
        this.m_weight = weight;
        this.m_targetMatchLen = targetMatchLen;
    }

    public boolean isFullMatch() {
        return this.m_fullMatch;
    }

    public int getMatchWeight() {
        return this.m_weight;
    }

    public int targetMatchLength() {
        return this.m_targetMatchLen;
    }

    @Override
    public int compareTo(MatchStats other) {
        if (this.m_fullMatch == other.isFullMatch()) {
            int c = this.m_weight - other.getMatchWeight();
            if (c == 0) {
                c = this.m_targetMatchLen - other.targetMatchLength();
            }
            return c;
        }
        if (this.m_fullMatch) {
            return 1;
        }
        return -1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_fullMatch ? 1231 : 1237);
        result = 31 * result + this.m_targetMatchLen;
        result = 31 * result + this.m_weight;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof MatchStats)) {
            return false;
        }
        MatchStats other = (MatchStats)obj;
        return this.m_fullMatch == other.isFullMatch() && this.m_weight == other.getMatchWeight() && this.m_targetMatchLen == other.targetMatchLength();
    }
}

