/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.radixtree;

import com.mapinfo.mapmarker.autosuggest.utils.ReadOnlyIterator;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.IFilterableNodeValue;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.IMatchResult;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.INodeKeyFilter;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.INodeValueFilter;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.ITreeNode;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.NodeFilter;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.TreeTransition;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.TreeWalker;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class NodeMatchResult<V>
implements IMatchResult<V> {
    private final TreeTransition<V> m_transition;
    private int m_matchedNodeKeyLen;
    private int m_weight = 0;
    private int m_targetMatchLen;
    private V m_value;
    private boolean m_inputFullyMatched = false;

    static <V> NodeMatchResult<V> getInstance(TreeTransition<V> trans) {
        return new NodeMatchResult<V>(trans, trans.getKeyLen());
    }

    static <V> NodeMatchResult<V> getInstance(TreeTransition<V> trans, int matchedKeyLen) {
        return new NodeMatchResult<V>(trans, matchedKeyLen);
    }

    static <V> NodeMatchResult<V> getInstance(TreeTransition<V> trans, int matchedKeyLen, boolean noChildMatches) {
        if (noChildMatches) {
            return new SingleNodeMatchResult<V>(trans, matchedKeyLen);
        }
        return new NodeMatchResult<V>(trans, matchedKeyLen);
    }

    static <V> NodeMatchResult<V> getInstance(TreeTransition<V> trans, boolean noChildMatches) {
        return NodeMatchResult.getInstance(trans, trans.getKeyLen(), noChildMatches);
    }

    static <V> NodeMatchResult<V> getInstance(NodeMatchResult<V> copyFrom, boolean noChildMatches) {
        if (noChildMatches) {
            return new SingleNodeMatchResult<V>(copyFrom);
        }
        return new NodeMatchResult<V>(copyFrom);
    }

    static <V> NodeMatchResult<V> getInstance(NodeMatchResult<V> copyFrom) {
        return NodeMatchResult.getInstance(copyFrom, copyFrom instanceof SingleNodeMatchResult);
    }

    private NodeMatchResult(TreeTransition<V> trans, int matchedKeyLen) {
        this.m_transition = trans;
        this.m_matchedNodeKeyLen = matchedKeyLen;
    }

    private NodeMatchResult(NodeMatchResult<V> copy) {
        this.m_transition = copy.m_transition;
        this.setValue(copy.getValue());
        this.setWeight(copy.getWeight());
        this.setTargetMatchLen(copy.getTargetMatchLen());
        this.setInputFullyMatched(copy.isFullInputMatch());
    }

    TreeTransition<V> getTranstition() {
        return this.m_transition;
    }

    void setTargetMatchLen(int targetMatchLen) {
        this.m_targetMatchLen = targetMatchLen;
    }

    @Override
    public int getTargetMatchLen() {
        return this.m_targetMatchLen;
    }

    void setInputFullyMatched(boolean b) {
        this.m_inputFullyMatched = b;
    }

    @Override
    public boolean isFullInputMatch() {
        return this.m_inputFullyMatched;
    }

    ITreeNode<V> getNode() {
        return this.m_transition.getNode();
    }

    int getFullMatchedPrefixLength() {
        return this.m_matchedNodeKeyLen;
    }

    void setWeight(int weight) {
        this.m_weight = weight;
    }

    @Override
    public int getWeight() {
        return this.m_weight;
    }

    int unmatchedCharsLength() {
        return this.m_transition.getKeyLen() - this.m_matchedNodeKeyLen;
    }

    boolean isFullKeyMatch() {
        return this.m_transition.getKeyLen() == this.m_matchedNodeKeyLen;
    }

    @Override
    public V getValue() {
        return this.m_value == null ? this.getNode().getValue() : this.m_value;
    }

    protected void setValue(V v) {
        this.m_value = v;
    }

    private boolean acceptResult(TreeTransition<V> trans, NodeFilter<V> filter, boolean intermediate) {
        INodeKeyFilter keyFilter;
        if (!trans.getNode().hasValue()) {
            return false;
        }
        INodeKeyFilter iNodeKeyFilter = keyFilter = filter == null ? null : filter.getKeyFilter();
        return keyFilter == null || !(intermediate ? !keyFilter.acceptIntermediateKey(trans.getKey()) : !keyFilter.acceptKey(trans.getKey()));
    }

    private NodeMatchResult<V> makeNodeMatchResult(TreeTransition<V> trans, NodeFilter<V> filter, boolean isIntermediate) {
        V value;
        if (trans.hasNodeValue() && this.acceptResult(trans, filter, isIntermediate) && (value = this.filterValues(trans, filter)) != null) {
            NodeMatchResult<V> nodeMatchResult = NodeMatchResult.getInstance(trans);
            nodeMatchResult.setWeight(this.getWeight());
            nodeMatchResult.setTargetMatchLen(this.getTargetMatchLen());
            nodeMatchResult.setInputFullyMatched(this.isFullInputMatch());
            nodeMatchResult.setValue(value);
            return nodeMatchResult;
        }
        return null;
    }

    boolean hasChildMatches() {
        return this.getNode().hasChildren();
    }

    private V filterValues(TreeTransition<V> trans, NodeFilter<V> filter) {
        ITreeNode<V> node = trans.getNode();
        Object value = null;
        if (node.hasValue()) {
            INodeValueFilter<Object> valueFilter;
            value = node.getValue();
            INodeValueFilter<Object> iNodeValueFilter = valueFilter = filter == null ? null : filter.getValueFilter();
            if (valueFilter != null) {
                value = valueFilter.filter(value);
            }
        }
        return value;
    }

    private void adjustTransition(TreeTransition<V> trans, NodeFilter<V> nodeFilter) {
        V v;
        INodeValueFilter<V> nodeValueFilter;
        if (nodeFilter != null && (nodeValueFilter = nodeFilter.getValueFilter()) != null && this.m_transition.hasNodeValue() && (v = this.m_transition.getNode().getValue()) instanceof IFilterableNodeValue && !((IFilterableNodeValue)v).isFullyRead()) {
            this.m_transition.refetchNode(nodeFilter.getValueFilter());
        }
    }

    public Iterator<NodeMatchResult<V>> getChildResultIterator(final NodeFilter<V> nodeFilter) {
        this.adjustTransition(this.m_transition, nodeFilter);
        final TreeWalker<V> treeWalker = TreeWalker.getTreeWalkerInstance(new char[0], this.m_transition, nodeFilter);
        return new ReadOnlyIterator<NodeMatchResult<V>>(){
            final Iterator<TreeTransition<V>> m_transIt;
            NodeMatchResult<V> m_next;
            {
                this.m_transIt = treeWalker.traverse(true).iterator();
                this.moveNext();
            }

            @Override
            public boolean hasNext() {
                return this.m_next != null;
            }

            @Override
            public NodeMatchResult<V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                NodeMatchResult curr = this.m_next;
                this.moveNext();
                return curr;
            }

            private void moveNext() {
                this.m_next = null;
                while (this.m_transIt.hasNext()) {
                    TreeTransition trans = this.m_transIt.next();
                    this.m_next = NodeMatchResult.this.makeNodeMatchResult(trans, nodeFilter, false);
                    if (this.m_next == null) continue;
                    break;
                }
            }
        };
    }

    @Override
    public int compareTo(IMatchResult<?> o) {
        boolean fullMatch = this.isFullInputMatch();
        if (fullMatch == o.isFullInputMatch()) {
            int c = this.m_weight - o.getWeight();
            if (c == 0 && (c = this.compareMatchedCharDifference(o)) == 0) {
                return this.m_transition.getKey().compareTo(((NodeMatchResult)o).m_transition.getKey());
            }
            return c;
        }
        if (fullMatch) {
            return 1;
        }
        return -1;
    }

    private int compareMatchedCharDifference(IMatchResult<?> o) {
        NodeMatchResult other;
        int c = 0;
        if (o instanceof NodeMatchResult && (c = (other = (NodeMatchResult)o).unmatchedCharsLength() - this.unmatchedCharsLength()) == 0) {
            int d1 = Math.abs(this.getTargetMatchLen() - this.getFullMatchedPrefixLength());
            int d2 = Math.abs(other.getTargetMatchLen() - other.getFullMatchedPrefixLength());
            c = d2 - d1;
        }
        return c;
    }

    public int hashCode() {
        return this.m_transition.getKey().hashCode();
    }

    public boolean equals(Object obj) {
        NodeMatchResult other = (NodeMatchResult)obj;
        return this.m_weight == other.getWeight() && this.m_transition.getKey().equals(other.m_transition.getKey());
    }

    @Override
    public String getKey() {
        return this.m_transition.getKey();
    }

    public String toString() {
        String s = this.getKey();
        if (this.m_value != null) {
            s = s + "[" + this.m_value + "]";
        }
        return s;
    }

    static class SingleNodeMatchResult<V>
    extends NodeMatchResult<V> {
        SingleNodeMatchResult(TreeTransition<V> trans, int matchedKeyLen) {
            super(trans, matchedKeyLen);
        }

        SingleNodeMatchResult(NodeMatchResult<V> copy) {
            super(copy);
        }

        @Override
        public Iterator<NodeMatchResult<V>> getChildResultIterator(NodeFilter<V> nodeFilter) {
            TreeTransition trans = this.getTranstition();
            ((NodeMatchResult)this).adjustTransition(trans, nodeFilter);
            NodeMatchResult result = ((NodeMatchResult)this).makeNodeMatchResult(trans, nodeFilter, !this.isFullInputMatch());
            if (result != null) {
                return Collections.singletonList(result).iterator();
            }
            return null;
        }

        @Override
        boolean hasChildMatches() {
            return false;
        }
    }
}

