/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.radixtree;

import com.mapinfo.mapmarker.autosuggest.utils.radixtree.AbstractTreeNode;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.DuplicateKeyException;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.INodeKeyFilter;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.ITreeNode;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.MatchStats;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.NodeFilter;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.NodeMatchResult;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.RadixTreeMatchResult;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.RadixTreeUtils;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.TreeNode;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.TreeTransition;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.TreeWalker;
import com.mapinfo.mapmarker.cgge.utils.CharArray;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadixTree<V> {
    private static final Logger LOG = LoggerFactory.getLogger((String)RadixTree.class.getName());
    private int m_size = 0;
    private ITreeNode<V> m_root = new TreeNode<Object>(new char[0], null);
    private boolean m_allowModifications = true;

    void setRoot(ITreeNode<V> node) {
        this.m_root = node;
    }

    void setCanModify(boolean b) {
        this.m_allowModifications = b;
    }

    void setSize(int s) {
        this.m_size = s;
    }

    public void add(String key, V value) {
        this.checkModification();
        Object prefixKey = key.toCharArray();
        int keyLen = ((char[])prefixKey).length;
        NodeMatchResult<V> result = this.bestNodeToAdd((char[])prefixKey);
        int charsMatched = result.getFullMatchedPrefixLength();
        ITreeNode<V> node = result.getNode();
        int unmatchedKeyLen = result.unmatchedCharsLength();
        if (charsMatched < keyLen || unmatchedKeyLen > 0) {
            if (unmatchedKeyLen > 0) {
                this.splitNode(node, node.getKeyLength() - unmatchedKeyLen);
                prefixKey = ((char[])prefixKey).length - charsMatched > 0 ? CharArray.subArray((char[])prefixKey, (int)charsMatched) : null;
            } else {
                prefixKey = CharArray.subArray((char[])prefixKey, (int)charsMatched);
            }
            if (prefixKey != null) {
                TreeNode<V> childNode = new TreeNode<V>((char[])prefixKey, value);
                node.addChildNode(childNode);
            } else {
                node.setValue(value);
            }
        } else if (node.getValue() == null) {
            node.setValue(value);
        } else {
            throw new DuplicateKeyException("Key '" + key + "' already exists in tree");
        }
        ++this.m_size;
    }

    private void splitNode(ITreeNode<V> node, int splitAt) {
        char[] currentKey = node.getKey();
        char[] newKey = CharArray.subArray((char[])currentKey, (int)0, (int)splitAt);
        char[] childKey = CharArray.subArray((char[])currentKey, (int)splitAt);
        TreeNode<V> childNode = new TreeNode<V>(childKey, node.getValue());
        childNode.copyChildren((AbstractTreeNode)node);
        node.removeChildren();
        node.addChildNode(childNode);
        node.setValue(null);
        node.setKey(newKey);
    }

    public V find(String key) {
        List<NodeMatchResult<V>> result = this.findNodeWithKey(key, null);
        return result == null ? null : (V)result.get(0).getValue();
    }

    public RadixTreeMatchResult<V> find(String key, NodeFilter<V> filter) {
        List<NodeMatchResult<V>> results = this.findNodeWithKey(key, filter);
        return results == null ? null : new RadixTreeMatchResult<V>(results, filter);
    }

    public ITreeNode<V> getRootNode() {
        return this.m_root;
    }

    private TreeTransition<V> getRootTranstition() {
        return new TreeTransition<V>(null, this.getRootNode(), 0);
    }

    private List<NodeMatchResult<V>> findNodeWithKey(String key, NodeFilter<V> filter) {
        INodeKeyFilter keyFilter;
        INodeKeyFilter iNodeKeyFilter = keyFilter = filter == null ? null : filter.getKeyFilter();
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("findNodeWithKey('%s')", key));
        }
        List<NodeMatchResult<V>> results = null;
        if (keyFilter == null || keyFilter.onlyAllowExactMatches()) {
            NodeMatchResult<V> result;
            char[] searchChars = key.toCharArray();
            TreeTransition<V> transition = this.findLongestPrefixTransition(searchChars, this.getRootTranstition(), filter);
            if (transition != null && this.isFullKeyMatch(transition, searchChars) && this.acceptTransition(transition, keyFilter, searchChars, false) && (result = this.makeMatchResult(transition, keyFilter, searchChars)) != null) {
                results = Collections.singletonList(NodeMatchResult.getInstance(result, true));
            }
        } else {
            results = this.findMatchingNodes(key.toCharArray(), this.getRootTranstition(), filter);
            if (results != null) {
                ArrayList<NodeMatchResult<V>> filteredResults = new ArrayList<NodeMatchResult<V>>(results.size());
                for (NodeMatchResult<V> result : results) {
                    if (result.unmatchedCharsLength() != 0) continue;
                    filteredResults.add(NodeMatchResult.getInstance(result, true));
                }
                List<NodeMatchResult<V>> list = results = filteredResults.isEmpty() ? null : filteredResults;
            }
        }
        if (LOG.isDebugEnabled()) {
            if (results != null) {
                StringBuilder sb = new StringBuilder();
                sb.append(String.format("findNodeWithKey('%s'): found [", key));
                for (NodeMatchResult<V> result : results) {
                    sb.append(" ");
                    sb.append(result.getKey());
                }
                sb.append(" ]");
                LOG.debug(sb.toString());
            } else if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("findNodeWithKey('%s'): found [ ]", key));
            }
        }
        return results;
    }

    private NodeMatchResult<V> bestNodeToAdd(char[] key) {
        return this.findNodeWithLongestPrefix(key, this.getRootTranstition());
    }

    private NodeMatchResult<V> findNodeWithLongestPrefix(char[] searchChars, TreeTransition<V> startFrom) {
        TreeTransition<V> longestMatchedTransition = this.findLongestPrefixTransition(searchChars, startFrom, null);
        return NodeMatchResult.getInstance(longestMatchedTransition, this.calculateMatchedKeyLen(longestMatchedTransition, searchChars));
    }

    private TreeTransition<V> findLongestPrefixTransition(char[] searchChars, TreeTransition<V> startFrom, NodeFilter<V> filter) {
        TreeWalker<V> treeWalker = TreeWalker.getExactTreeWalkerInstance(searchChars, startFrom, filter);
        TreeTransition<V> longestMatchedTransition = startFrom;
        for (TreeTransition<V> trans : treeWalker.traverse()) {
            longestMatchedTransition = trans;
        }
        return longestMatchedTransition;
    }

    private int calculateMatchedKeyLen(TreeTransition<V> transition, char[] searchChars) {
        int prefixMatched = transition.getParentKeyLen();
        prefixMatched += RadixTreeUtils.getMatchedPrefixLength(searchChars, transition.getNode().getKey(), prefixMatched);
        return prefixMatched;
    }

    private boolean isFullKeyMatch(TreeTransition<V> transition, char[] searchChars) {
        return searchChars.length == transition.getKeyLen();
    }

    private List<NodeMatchResult<V>> findMatchingNodes(char[] searchChars, TreeTransition<V> startFrom, NodeFilter<V> filter) {
        return this.findMatchingNodes(searchChars, startFrom, filter, false);
    }

    private List<NodeMatchResult<V>> findMatchingNodes(char[] searchChars, TreeTransition<V> startFrom, NodeFilter<V> filter, boolean includeIntermediate) {
        StringBuilder sb;
        List<NodeMatchResult<V>> matchResults = new ArrayList<NodeMatchResult<V>>();
        INodeKeyFilter keyFilter = filter == null ? null : filter.getKeyFilter();
        TreeWalker<V> treeWalker = this.getTreeWalker(searchChars, startFrom, filter);
        for (TreeTransition<V> trans : treeWalker.traverse()) {
            NodeMatchResult<V> nodeMatchResult;
            if (!this.acceptTransition(trans, keyFilter, searchChars, includeIntermediate) || (nodeMatchResult = this.makeMatchResult(trans, keyFilter, searchChars)) == null) continue;
            matchResults.add(nodeMatchResult);
        }
        if (LOG.isDebugEnabled()) {
            sb = new StringBuilder(100);
            sb.append("Tree traversing for '");
            sb.append(searchChars);
            sb.append("' -> ");
            for (TreeTransition<V> treeTransition : treeWalker.traverse()) {
                sb.append("'");
                sb.append(treeTransition.getKey());
                sb.append("', ");
            }
            LOG.debug(sb.toString());
        }
        if (!matchResults.isEmpty()) {
            matchResults = this.getSortedList(matchResults);
            if (LOG.isDebugEnabled()) {
                sb = new StringBuilder();
                String.format("findMatchingNodes('%s'): found matches:", new String(searchChars));
                for (NodeMatchResult nodeMatchResult : matchResults) {
                    sb.append(String.format(" %s", nodeMatchResult.getKey()));
                }
                LOG.debug(sb.toString());
            }
            return matchResults;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("findMatchingNodes('%s'): found [ ]", new String(searchChars)));
        }
        return null;
    }

    private List<NodeMatchResult<V>> findMatchingNodes(char[] searchCharsPrefix, char[] searchCharsSuffix, TreeTransition<V> startFrom, NodeFilter<V> filter, boolean includeIntermediate, List<TreeTransition<V>> prefixMatchList) {
        List<NodeMatchResult<V>> matchResults = new ArrayList<NodeMatchResult<V>>();
        INodeKeyFilter keyFilter = filter == null ? null : filter.getKeyFilter();
        char[] fullSearchChars = CharArray.addArrays((char[])searchCharsPrefix, (char[])searchCharsSuffix);
        int prefixLen = searchCharsPrefix.length;
        TreeWalker<V> treeWalker = this.getTreeWalker(fullSearchChars, startFrom, filter);
        TreeTransition<V> lastPrefixMatchAdded = null;
        for (TreeTransition<V> trans : treeWalker.traverse()) {
            if (!this.acceptTransition(trans, keyFilter, fullSearchChars, includeIntermediate)) continue;
            NodeMatchResult<V> nodeMatchResult = this.makeMatchResult(trans, keyFilter, fullSearchChars);
            if (nodeMatchResult != null && (nodeMatchResult.isFullInputMatch() || trans.hasNodeValue())) {
                matchResults.add(nodeMatchResult);
            }
            if (lastPrefixMatchAdded == null || lastPrefixMatchAdded != trans.previous()) {
                prefixMatchList.add(trans);
            } else if (trans.getKeyLen() <= prefixLen) {
                prefixMatchList.set(prefixMatchList.size() - 1, trans);
            }
            lastPrefixMatchAdded = trans;
        }
        if (!matchResults.isEmpty()) {
            matchResults = this.getSortedList(matchResults);
            if (LOG.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                String.format("findMatchingNodes('%s'): found matches:", new String(fullSearchChars));
                for (NodeMatchResult<V> result : matchResults) {
                    sb.append(String.format(" %s", result.getKey()));
                }
                LOG.debug(sb.toString());
            }
            return matchResults;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("findMatchingNodes('%s'): found [ ]", new String(fullSearchChars)));
        }
        return null;
    }

    private TreeWalker<V> getTreeWalker(char[] searchChars, TreeTransition<V> startFrom, NodeFilter<V> filter) {
        INodeKeyFilter keyFilter;
        INodeKeyFilter iNodeKeyFilter = keyFilter = filter == null ? null : filter.getKeyFilter();
        if (keyFilter == null || keyFilter.onlyAllowExactMatches()) {
            return TreeWalker.getExactTreeWalkerInstance(searchChars, startFrom, filter);
        }
        return TreeWalker.getPrefixTreeWalkerInstance(searchChars, startFrom, filter);
    }

    private NodeMatchResult<V> makeMatchResult(TreeTransition<V> trans, INodeKeyFilter keyFilter, char[] searchChars) {
        boolean accepted;
        MatchStats matchStats = this.getMatchStats(trans, searchChars, keyFilter);
        boolean fullMatch = matchStats.isFullMatch();
        boolean bl = accepted = fullMatch || trans.hasNodeValue();
        if (accepted) {
            int matchedKeyLen = keyFilter == null ? matchStats.targetMatchLength() : trans.getKeyLen();
            NodeMatchResult<V> matchResult = NodeMatchResult.getInstance(trans, matchedKeyLen, !fullMatch);
            matchResult.setWeight(matchStats.getMatchWeight());
            matchResult.setTargetMatchLen(matchStats.targetMatchLength());
            matchResult.setInputFullyMatched(matchStats.isFullMatch());
            return matchResult;
        }
        return null;
    }

    private MatchStats getMatchStats(TreeTransition<V> trans, char[] searchChars, INodeKeyFilter keyFilter) {
        if (keyFilter != null) {
            return keyFilter.getMatchStats(trans.getKey());
        }
        int targetMatchLen = this.getTargetMatchLen(trans, searchChars);
        return new MatchStats(targetMatchLen == searchChars.length, 100, targetMatchLen);
    }

    private int getTargetMatchLen(TreeTransition<V> trans, char[] searchChars) {
        int targetMatchLen = trans.getParentKeyLen();
        targetMatchLen += RadixTreeUtils.getMatchedPrefixLength(searchChars, trans.getNode().getKey(), targetMatchLen);
        return targetMatchLen;
    }

    private boolean acceptTransition(TreeTransition<V> trans, INodeKeyFilter keyFilter, char[] searchChars, boolean acceptIntermediates) {
        String key = trans.getKey();
        boolean accept = false;
        if (keyFilter == null) {
            int searchCharLen = searchChars.length;
            if (trans.getKeyLen() >= searchCharLen) {
                accept = this.getTargetMatchLen(trans, searchChars) == searchCharLen;
            } else if (acceptIntermediates) {
                accept = trans.getKeyLen() <= this.getTargetMatchLen(trans, searchChars);
            }
        } else {
            accept = keyFilter.acceptKey(key);
            if (!accept && acceptIntermediates) {
                accept = keyFilter.acceptIntermediateKey(key);
            }
        }
        return accept;
    }

    public RadixTreeMatchResult<V> findAll(String prefix) {
        return this.findAll(prefix, null);
    }

    public RadixTreeMatchResult<V> findAll(String prefix, NodeFilter<V> filter) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("findAll('" + prefix + "')");
        }
        List<NodeMatchResult<V>> edgeNodes = this.findMatchingNodes(prefix.toCharArray(), this.getRootTranstition(), filter);
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("findAll('%s'): results: [", prefix));
            if (edgeNodes != null) {
                for (NodeMatchResult<V> result : edgeNodes) {
                    sb.append(" ");
                    sb.append(result.getKey());
                }
            }
            sb.append(" ]");
            LOG.debug(sb.toString());
        }
        return edgeNodes == null ? null : new RadixTreeMatchResult<V>(edgeNodes, filter);
    }

    public RadixTreeMatchResult<V> findAllIncludingIntermediateWords(String prefix, NodeFilter<V> filter) {
        return this.findAllIncludingIntermediateWords(prefix, null, filter);
    }

    public RadixTreeMatchResult<V> findAllIncludingIntermediateWords(String prefix, String[] prefixExtensions, NodeFilter<V> filter) {
        List<NodeMatchResult<V>> edgeNodes = this.findResultsWithIntermediateWords(prefix, prefixExtensions, filter);
        return edgeNodes == null ? null : new RadixTreeMatchResult<V>(edgeNodes, filter);
    }

    private List<NodeMatchResult<V>> findResultsWithIntermediateWords(String prefix, String[] prefixExtensions, NodeFilter<V> filter) {
        char[] prefixChars = prefix.toCharArray();
        int extCount = prefixExtensions == null ? 0 : prefixExtensions.length;
        ArrayList<TreeTransition<V>> prefixMatchTransList = null;
        List<NodeMatchResult<V>> resultList = null;
        if (extCount > 1) {
            prefixMatchTransList = new ArrayList<TreeTransition<V>>();
            resultList = this.findMatchingNodes(prefixChars, prefixExtensions[0].toCharArray(), this.getRootTranstition(), filter, true, prefixMatchTransList);
        } else {
            char[] searchChars = extCount == 0 ? prefixChars : CharArray.addArrays((char[])prefixChars, (char[])prefixExtensions[0].toCharArray());
            resultList = this.findMatchingNodes(searchChars, this.getRootTranstition(), filter, true);
        }
        HashSet<NodeMatchResult<V>> resultSet = new HashSet<NodeMatchResult<V>>();
        if (resultList != null) {
            resultSet.addAll(resultList);
        }
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("findResultsWithIntermediateWords('%s'): results: [", prefix));
            if (resultList != null) {
                for (NodeMatchResult<V> result : resultList) {
                    sb.append(" ");
                    sb.append(result.getKey());
                }
            }
            sb.append(" ]");
            LOG.debug(sb.toString());
        }
        if (prefixMatchTransList != null) {
            int prefixMatchCount = prefixMatchTransList.size();
            for (int prefixNdx = 0; prefixNdx < prefixMatchCount; ++prefixNdx) {
                TreeTransition prefixMatchTrans = (TreeTransition)prefixMatchTransList.get(prefixNdx);
                for (int i = 1; i < extCount; ++i) {
                    List<NodeMatchResult<V>> extendedResults = this.findMatchingNodes(CharArray.addArrays((char[])prefixChars, (char[])prefixExtensions[i].toCharArray()), prefixMatchTrans, filter, false);
                    if (extendedResults == null) continue;
                    resultSet.addAll(extendedResults);
                    if (!LOG.isDebugEnabled()) continue;
                    StringBuilder sb = new StringBuilder();
                    sb.append(String.format("findResultsWithIntermediateWords('%s'): results (extended): [", new String(CharArray.addArrays((char[])prefixChars, (char[])prefixExtensions[i].toCharArray()))));
                    for (NodeMatchResult<V> result : extendedResults) {
                        sb.append(" ");
                        sb.append(result.getKey());
                    }
                    sb.append(" ]");
                    LOG.debug(sb.toString());
                }
            }
        }
        if (!resultSet.isEmpty()) {
            return this.getSortedList(new ArrayList<NodeMatchResult<V>>(resultSet));
        }
        return null;
    }

    private List<NodeMatchResult<V>> getSortedList(List<NodeMatchResult<V>> results) {
        Collections.sort(results);
        Collections.reverse(results);
        return results;
    }

    private boolean canAddToResults(NodeMatchResult<V> nodeMatchResult) {
        return nodeMatchResult.getNode().hasValue();
    }

    public int size() {
        return this.m_size;
    }

    public boolean isEmpty() {
        return this.m_size == 0;
    }

    public boolean updatesAllowed() {
        return this.m_allowModifications;
    }

    public void updatesAllowed(boolean b) {
        this.m_allowModifications = b;
    }

    private void checkModification() {
        if (!this.m_allowModifications) {
            throw new IllegalStateException("Modification not allowed");
        }
    }

    public int hashCode() {
        return 31 * this.m_size;
    }
}

