/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.substitution;

import com.mapinfo.mapmarker.autosuggest.utils.AutoSuggestLog;
import com.mapinfo.mapmarker.autosuggest.utils.substitution.SubstitutionMap;
import com.mapinfo.mapmarker.autosuggest.utils.substitution.SubstitutionSet;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;

public class SubstitutionSetLoader {
    public static final String PRETYPE_FILENAME = "preTypes.properties";
    public static final String POSTTYPE_FILENAME = "postTypes.properties";
    public static final String ATTACHED_TYPE_FILENAME = "attachedTypes.properties";
    public static final String DIRECTIONALS_FILENAME = "directionals.properties";
    public static final String ORDINALS_FILENAME = "ordinals.properties";
    public static final String NUMBER_WORDS_FILENAME = "numberWords.properties";
    public static final String ABBREVIATIONS_FILENAME = "abbreviations.properties";
    public static final String NON_SIGNIFICANT_WORDS_FILENAME = "commonWords.properties";
    public static final String SECONDARY_WORDS_FILENAME = "secondaryWords.properties";
    public static final String PREFIXES_FILENAME = "prefixes.properties";
    public static final String SUFFIXES_FILENAME = "suffixes.properties";
    public static final String GEOGRAPHIC_FILENAME = "geographicAbbrevs.properties";
    protected SubstitutionSet substitutionSet = new SubstitutionSet();

    public SubstitutionSet getSubstitutionSet() {
        return this.substitutionSet;
    }

    public void importSubstitutionSet(String path, String prefix, int setsToImport) throws IOException {
        if ((setsToImport & 1) > 0) {
            this.importMap(path, prefix + "_" + PRETYPE_FILENAME, this.substitutionSet.preTypeMap);
        }
        if ((setsToImport & 2) > 0) {
            this.importMap(path, prefix + "_" + POSTTYPE_FILENAME, this.substitutionSet.postTypeMap);
        }
        if ((setsToImport & 4) > 0) {
            this.importMap(path, prefix + "_" + ATTACHED_TYPE_FILENAME, this.substitutionSet.attachedTypeMap);
        }
        if ((setsToImport & 8) > 0) {
            this.importMap(path, prefix + "_" + DIRECTIONALS_FILENAME, this.substitutionSet.directionalMap);
        }
        if ((setsToImport & 0x800) > 0) {
            this.importMap(path, prefix + "_" + ORDINALS_FILENAME, this.substitutionSet.ordinalMap);
        }
        if ((setsToImport & 0x10) > 0) {
            this.importMap(path, prefix + "_" + NUMBER_WORDS_FILENAME, this.substitutionSet.numberMap);
        }
        if ((setsToImport & 0x40) > 0) {
            this.importMap(path, prefix + "_" + ABBREVIATIONS_FILENAME, this.substitutionSet.abbrevMap);
        }
        if ((setsToImport & 0x100) > 0) {
            this.importMap(path, prefix + "_" + PREFIXES_FILENAME, this.substitutionSet.prefixMap);
        }
        if ((setsToImport & 0x1000) > 0) {
            this.importMap(path, prefix + "_" + SUFFIXES_FILENAME, this.substitutionSet.suffixMap);
        }
        if ((setsToImport & 0x400) > 0) {
            this.importMap(path, prefix + "_" + GEOGRAPHIC_FILENAME, this.substitutionSet.geoMap);
        }
        if ((setsToImport & 0x20) > 0) {
            this.importSet(path, prefix + "_" + NON_SIGNIFICANT_WORDS_FILENAME, this.substitutionSet.commonWords);
        }
        if ((setsToImport & 0x200) > 0) {
            this.importSet(path, prefix + "_" + SECONDARY_WORDS_FILENAME, this.substitutionSet.secondaryCommonWords);
        }
        if (this.substitutionSet.isEmpty()) {
            AutoSuggestLog.getLog().error((Object)"SubstitutionSetLoader no substitutions were found");
            throw new IOException("Unable to load substitution sets");
        }
    }

    protected void importMap(String path, String name, SubstitutionMap map) throws IOException {
        String fullFile = this.appendToPath(path, name);
        try (BufferedReader in = null;){
            in = this.prepareReader(fullFile);
            if (in == null) {
                return;
            }
            if (map == null) {
                map = new SubstitutionMap();
            }
            Properties properties = new Properties();
            properties.load(in);
            for (Object key : properties.keySet()) {
                String keyStr = (String)key;
                String value = (String)properties.get(key);
                if (value == null) {
                    map.add(keyStr, value);
                    continue;
                }
                StringTokenizer st = new StringTokenizer(value, ",");
                while (st.hasMoreTokens()) {
                    map.add(keyStr, st.nextToken());
                }
            }
        }
    }

    protected void importSet(String path, String name, HashSet<String> set) throws IOException {
        String fullFile = this.appendToPath(path, name);
        try (BufferedReader in = null;){
            in = this.prepareReader(fullFile);
            if (in == null) {
                return;
            }
            if (set == null) {
                set = new HashSet();
            }
            Properties properties = new Properties();
            properties.load(in);
            for (String key : properties.stringPropertyNames()) {
                set.add(key);
            }
        }
    }

    private BufferedReader prepareReader(String fullFile) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(fullFile);
        if (is == null) {
            AutoSuggestLog.getLog().info((Object)("SubstitutionSetLoader: unable to locate file " + fullFile + ", not loaded"));
            return null;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
        this.eatTheBOM(in);
        return in;
    }

    private void eatTheBOM(BufferedReader in) throws IOException {
        char[] theBOM = new char[]{'\ufeff'};
        if (in != null && in.ready()) {
            in.mark(theBOM.length);
            char[] possibleBOM = new char[theBOM.length];
            in.read(possibleBOM, 0, theBOM.length);
            if (!Arrays.equals(theBOM, possibleBOM)) {
                in.reset();
            }
        }
    }

    private String appendToPath(String path, String name) {
        StringBuilder sb = new StringBuilder(path);
        if (!path.endsWith("\\") || path.endsWith("/")) {
            sb.append('/');
        }
        sb.append(name);
        return sb.toString().replace('\\', '/');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String fullPath) throws IOException {
        File substitutionSetPath = new File(fullPath);
        try (DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(substitutionSetPath));){
            this.substitutionSet.write(dataOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(String fullPath) throws IOException {
        File substitutionSetPath = new File(fullPath);
        if (substitutionSetPath.exists() && substitutionSetPath.isFile()) {
            try (DataInputStream dataStream = new DataInputStream(new FileInputStream(substitutionSetPath));){
                this.substitutionSet.read(dataStream);
            }
        } else {
            String message = "Unable to load substitutions for data at " + fullPath;
            AutoSuggestLog.getLog().error((Object)message);
        }
    }

    static class NumberSorter
    implements Comparator<String> {
        NumberSorter() {
        }

        @Override
        public int compare(String left, String right) {
            int leftParsedAsInt = 0;
            int rightParsedAsInt = 0;
            if (left != null && right != null) {
                try {
                    leftParsedAsInt = Integer.parseInt(left);
                    rightParsedAsInt = Integer.parseInt(right);
                }
                catch (NumberFormatException nfe) {
                    AutoSuggestLog.getLog().warn((Object)("String not parsable as int, Left: " + left + " , Right: " + right));
                }
            }
            int returnVal = leftParsedAsInt == rightParsedAsInt ? 0 : (leftParsedAsInt > rightParsedAsInt ? 1 : -1);
            return returnVal;
        }
    }
}

