/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.substitution;

import com.mapinfo.mapmarker.autosuggest.utils.substitution.SubstitutionSetLoader;
import com.mapinfo.mapmarker.cgge.utils.PropertiesUtil;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubstitutionSetManager {
    static final Logger logger = LoggerFactory.getLogger(SubstitutionSetManager.class);
    public static final String KEY_SUBSTITUTION_SET_COUNT = "substitutionSetCount";
    public static final String KEY_SUBSTITUTION_SET_PATH = "substitutionSetPath";
    public static final String KEY_SUBSTITUTION_SET_PREFIX = "substitutionSetPrefix";
    public static final String KEY_SUBSTITUTION_SETS_TO_LOAD = "substitutionSetsToLoad";
    public static final int PRE_THOROUGHFARE_TYPES = 1;
    public static final int POST_THOROUGHFARE_TYPES = 2;
    public static final int ATTACHED_THOROUGHFARE_TYPES = 4;
    public static final int DIRECTIONALS = 8;
    public static final int NUMBER_WORDS = 16;
    public static final int NON_SIGNIFICANT_WORDS = 32;
    public static final int ALTERNATE_STRINGS = 64;
    public static final int DIGITS = 128;
    public static final int OPTIONAL_PREFIXES = 256;
    public static final int SECONDARY_COMMON_WORDS = 512;
    public static final int GEOGRAPHIC_AREA_ABBREVIATIONS = 1024;
    public static final int ORDINAL_WORDS = 2048;
    public static final int OPTIONAL_SUFFIXES = 4096;
    protected SubstitutionSetLoader loader = new SubstitutionSetLoader();

    public void loadSubstitutionSet(String path, String prefix) throws IOException {
        this.loadSubstitutionSet(path, prefix, 65535);
    }

    public void loadSubstitutionSet(String path, String prefix, int setsToLoad) throws IOException {
        this.loader.importSubstitutionSet(path, prefix, setsToLoad);
    }

    public Set<String> getPossibleSubstitutions(String input) {
        return this.getPossibleSubstitutions(input, 65535);
    }

    public Set<String> getPossibleSubstitutions(String input, int setsToUse) {
        return this.loader.getSubstitutionSet().getPossibleSubstitutions(input, setsToUse);
    }

    public Set<String> getPossibleSubstitutions(String input, int setsToUse, int setsToRemove) {
        return this.loader.getSubstitutionSet().getPossibleSubstitutions(input, setsToUse, setsToRemove);
    }

    public Set<String> removeSubstitutions(String input, int setsToRemove) {
        return this.loader.getSubstitutionSet().removeSubstitutions(input, setsToRemove);
    }

    public void loadSubstitutionSet(Properties dataProps) throws IOException {
        int count = PropertiesUtil.getIntegerPropertyValue((Properties)dataProps, (String)KEY_SUBSTITUTION_SET_COUNT, (int)1);
        for (int i = 1; i <= count; ++i) {
            String setPath = dataProps.getProperty(KEY_SUBSTITUTION_SET_PATH + i);
            String prefix = dataProps.getProperty(KEY_SUBSTITUTION_SET_PREFIX + i);
            int setsToLoad = PropertiesUtil.getIntegerPropertyValue((Properties)dataProps, (String)(KEY_SUBSTITUTION_SETS_TO_LOAD + i), (int)65535);
            if (setPath == null || prefix == null || setsToLoad <= 0) continue;
            this.loadSubstitutionSet(setPath, prefix, setsToLoad);
        }
    }

    public Set<String> getSubstitutionsForToken(String inputToken, int setsToUse) {
        return this.loader.getSubstitutionSet().getSubstitutionsForToken(inputToken, setsToUse);
    }

    public String getShortestVersion(String str, int typesToRemove) {
        Set<String> possibles = this.removeSubstitutions(str, typesToRemove);
        if (possibles == null || possibles.size() == 0) {
            return null;
        }
        String shortest = null;
        for (String possible : possibles) {
            if (shortest == null) {
                shortest = possible;
                continue;
            }
            if (possible.length() >= shortest.length()) continue;
            shortest = possible;
        }
        if (shortest != null && shortest.length() >= str.length()) {
            return null;
        }
        return this.removeSingleCharacters(shortest);
    }

    protected String removeSingleCharacters(String str) {
        if (str != null) {
            StringTokenizer st = new StringTokenizer(str);
            if (st.countTokens() == 1) {
                return str;
            }
            StringBuilder stringBuilder = new StringBuilder();
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                if (tok.length() <= 1 && !Character.isDigit(tok.charAt(0))) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(tok);
            }
            return stringBuilder.toString();
        }
        return str;
    }

    public void write(String fullPath) throws IOException {
        this.loader.write(fullPath);
    }

    public void read(String fullPath) throws IOException {
        this.loader.read(fullPath);
    }
}

