/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.wrapper;

import com.mapinfo.mapmarker.autosuggest.dp.AddressMetaData;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AdditionalFieldInfo {
    public static final String KEY_BRAND_NAME = "brand_name";
    public static final String KEY_CATEGORY = AddressMetaData.CATEGORY_FIELD_NAME;
    public static final String KEY_SUB_CATEGORY = AddressMetaData.SUB_CATEGORY_FIELD_NAME;
    private static Set<Integer> knownKeys;
    private Map<String, Integer> additionalFieldMap;
    private AddressMetaData theMetaData;

    public AdditionalFieldInfo(AddressMetaData metaData) {
        Map<Integer, String> metaDataFieldMap = metaData.getFieldMap();
        HashMap<String, Integer> additionalFieldMap = new HashMap<String, Integer>();
        for (Integer id : metaDataFieldMap.keySet()) {
            if (knownKeys.contains(id)) continue;
            additionalFieldMap.put(metaDataFieldMap.get(id), id);
        }
        this.additionalFieldMap = Collections.unmodifiableMap(additionalFieldMap);
        this.theMetaData = metaData;
    }

    public String getKey(int i) {
        return this.theMetaData.getFieldName(i);
    }

    public int getCategoryID() {
        return this.getIDForKey(KEY_CATEGORY);
    }

    public int getSubCategoryID() {
        return this.getIDForKey(KEY_SUB_CATEGORY);
    }

    public int getBrandNameID() {
        return this.getIDForKey(KEY_BRAND_NAME);
    }

    public int getIDForKey(String key) {
        if (!this.additionalFieldMap.containsKey(key)) {
            return -1;
        }
        return this.additionalFieldMap.get(key);
    }

    public Set<String> keySet() {
        return this.additionalFieldMap.keySet();
    }

    public static String getExternalNameForKey(String key) {
        String value = null;
        value = KEY_BRAND_NAME.equals(key) ? FieldType.getExternalName((String)KEY_BRAND_NAME) : (KEY_CATEGORY.equals(key) ? "Category" : (KEY_SUB_CATEGORY.equals(key) ? "SubCategory" : FieldType.getExternalName((String)key)));
        if (value == null) {
            value = FieldType.UNKNOWN_FIELD_TYPE.getExternalName();
        }
        return value;
    }

    public List<Integer> getAdditionalFieldsForLevel(int level) {
        return this.theMetaData.getAdditionalFieldsForLevel(level);
    }

    static {
        HashSet<Integer> knownKeysMap = new HashSet<Integer>();
        knownKeysMap.add(FieldType.PLACE_NAME_FIELD_TYPE.getKey());
        knownKeysMap.add(FieldType.STREET_NAME_FIELD_TYPE.getKey());
        knownKeysMap.add(FieldType.POST_CODE_FIELD_TYPE.getKey());
        knownKeysMap.add(FieldType.AREA_NAME_1_FIELD_TYPE.getKey());
        knownKeysMap.add(FieldType.AREA_NAME_2_FIELD_TYPE.getKey());
        knownKeysMap.add(FieldType.AREA_NAME_3_FIELD_TYPE.getKey());
        knownKeysMap.add(FieldType.AREA_NAME_4_FIELD_TYPE.getKey());
        knownKeys = Collections.unmodifiableSet(knownKeysMap);
    }
}

