/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.wrapper;

import com.mapinfo.mapmarker.autosuggest.api.AutoSuggestAPI;
import com.mapinfo.mapmarker.autosuggest.api.AutoSuggestFactorySettingsProvider;
import com.mapinfo.mapmarker.autosuggest.api.BoundingBox;
import com.mapinfo.mapmarker.autosuggest.api.IAutoSuggestConstraints;
import com.mapinfo.mapmarker.autosuggest.utils.AutoSuggestLog;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.Rectangle;
import com.mapinfo.mapmarker.autosuggest.wrapper.CompositeWrapper;
import com.mapinfo.mapmarker.autosuggest.wrapper.WrapperDataInfo;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoSuggestFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AutoSuggestFactory.class);

    public static AutoSuggestAPI getInstance(String country, int type) {
        List<WrapperDataInfo> handlers;
        AutoSuggestFactorySettingsProvider provider = AutoSuggestFactorySettingsProvider.getInstance();
        if (type == 0) {
            type = 65535;
        }
        if (country == null) {
            country = provider.getDefaultCountry();
        }
        if ((handlers = provider.getUsableDictionaryWrappersForCountry(country, type, null)).isEmpty()) {
            AutoSuggestLog.getLog().debug((Object)"unable to find any handlers");
            return null;
        }
        return new CompositeWrapper(handlers);
    }

    public static List<AutoSuggestAPI> getInstanceList(String country, IAutoSuggestConstraints constraints) {
        String defaultCountry;
        List<WrapperDataInfo> handlers;
        boolean hasBoundingBox;
        AutoSuggestFactorySettingsProvider provider = AutoSuggestFactorySettingsProvider.getInstance();
        ArrayList<AutoSuggestAPI> instanceList = new ArrayList<AutoSuggestAPI>();
        DirectPosition origin = null;
        BoundingBox boundingBox = null;
        int type = 124;
        if (constraints != null) {
            origin = constraints.getOriginPointWGS84();
            boundingBox = constraints.getBoundingBoxWGS84();
            int searchType = constraints.getSearchType();
            if (searchType != 0) {
                type = searchType;
            }
        }
        boolean hasOrigin = origin != null && (origin.getX() != 0.0 || origin.getY() != 0.0);
        boolean hasDistanceBounds = hasOrigin && constraints.getSearchDistance() != 0.0;
        boolean bl = hasBoundingBox = boundingBox != null && !boundingBox.isEmpty();
        if (StringUtilities.isEmpty((String)country) && !hasOrigin && !hasBoundingBox) {
            country = provider.getDefaultCountry();
        }
        String localCountry = country;
        if (constraints.getSearchType() == 125) {
            localCountry = "XWG";
        }
        if (!(handlers = localCountry == null ? AutoSuggestFactory.getHandlersForCountry(null, origin, boundingBox, type, provider, constraints) : (!hasDistanceBounds && !hasBoundingBox ? provider.getUsableDictionaryWrappersForCountry(localCountry, type, constraints) : AutoSuggestFactory.getHandlersForCountry(localCountry, origin, boundingBox, type, provider, constraints))).isEmpty()) {
            instanceList.add(new CompositeWrapper(handlers));
        }
        if (instanceList.isEmpty() && (handlers = (defaultCountry = provider.getDefaultCountry()) != null ? provider.getUsableDictionaryWrappersForCountry(defaultCountry, type, constraints) : provider.getUsableConfiguredDictionaryWrappers(type, constraints)) != null && !handlers.isEmpty()) {
            instanceList.add(new CompositeWrapper(handlers));
        }
        if (instanceList.isEmpty()) {
            LOG.info("no handlers found!");
        }
        return instanceList;
    }

    private static List<WrapperDataInfo> getHandlersForCountry(String country, DirectPosition origin, BoundingBox boundingBox, int type, AutoSuggestFactorySettingsProvider provider, IAutoSuggestConstraints constraints) {
        ArrayList<WrapperDataInfo> handlers = new ArrayList<WrapperDataInfo>();
        boolean bNoOrigin = origin == null || origin.getX() == 0.0 && origin.getY() == 0.0;
        List<WrapperDataInfo> wrappers = country == null ? provider.getUsableConfiguredDictionaryWrappers(type, constraints) : provider.getUsableDictionaryWrappersForCountry(country, type, constraints);
        if (wrappers == null) {
            return handlers;
        }
        for (WrapperDataInfo wrapperDataInfo : wrappers) {
            Rectangle countryExtent = wrapperDataInfo.getHandler().getExtent();
            if (!(origin != null && countryExtent.pointInRect(origin.getX(), origin.getY()) || bNoOrigin && boundingBox == null) && (boundingBox == null || boundingBox.isPoint() || !countryExtent.intersects(boundingBox))) continue;
            handlers.add(wrapperDataInfo);
        }
        if (handlers.isEmpty()) {
            AutoSuggestLog.getLog().debug((Object)"unable to find any handlers");
        }
        return handlers;
    }
}

