/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.wrapper;

import com.mapinfo.mapmarker.autosuggest.api.ISuggestedCandidate;
import com.mapinfo.mapmarker.autosuggest.wrapper.SuggestedCandidate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CandidateCompareConfigurable
implements Comparator<ISuggestedCandidate> {
    private static final Logger LOG = LoggerFactory.getLogger((String)CandidateCompareConfigurable.class.getName());
    private List<SortRule> ruleList = new ArrayList<SortRule>();
    public static final List<SortRule> DEFAULT_RULE_LIST;
    public static final SortRule RULE_BANDED_DISTANCE_SCORE;
    public static final SortRule RULE_MATCH_SCORE;
    public static final SortRule RULE_MATCHES_INPUT_FLAG;
    public static final SortRule RULE_DICTIONARY_PRIORITY;
    public static final SortRule RULE_STREET_ON_STREET;
    public static final SortRule RULE_POI_OVER_STREET;
    public static final SortRule RULE_ACTUAL_DISTANCE;
    public static final SortRule RULE_PLACE_STREET_SCORE;
    public static final SortRule RULE_STREET_MATCH_QUALITY;
    public static final SortRule RULE_POI_LENGTH_CHECK;
    public static final SortRule RULE_NUM_FIELDS_MATCHED;
    public static final SortRule RULE_POST_CODE_SCORE;
    public static final SortRule RULE_AREA_NAME_3_SCORE;
    public static final SortRule RULE_STREET_PLACE_SCORE;
    public static final SortRule RULE_PLACE_NAME_SCORE;
    public static final SortRule RULE_RATIO_MATCHED_SCORE;

    @Override
    public final int compare(ISuggestedCandidate a, ISuggestedCandidate b) {
        SuggestedCandidate c1 = (SuggestedCandidate)a;
        SuggestedCandidate c2 = (SuggestedCandidate)b;
        int result = 0;
        String activeRule = "none";
        for (SortRule r : this.ruleList) {
            activeRule = r.getName();
            result = r.compare(c1, c2);
            if (result == 0) continue;
            break;
        }
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Comparing:\n");
            sb.append(c1);
            sb.append("to:\n");
            sb.append(c2).append("\n");
            sb.append("Operative sort rule: ").append(activeRule).append("\n");
            sb.append("*** Comparison result: ").append(result);
            LOG.debug(sb.toString());
        }
        return result;
    }

    public CandidateCompareConfigurable() {
        for (SortRule r : DEFAULT_RULE_LIST) {
            this.ruleList.add(r);
        }
    }

    public CandidateCompareConfigurable(List<SortRule> yourRules) {
        this.vaidateRules(yourRules);
        this.ruleList = yourRules;
    }

    public void setRules(List<SortRule> yourRules) {
        this.vaidateRules(yourRules);
        this.ruleList = yourRules;
    }

    private void vaidateRules(List<SortRule> yourRules) {
        if (yourRules == null) {
            throw new IllegalArgumentException("Rule list must not be null");
        }
    }

    public List<SortRule> getRules() {
        return this.ruleList;
    }

    private static int preferGreater(double c1Score, double c2Score) {
        return Double.compare(c2Score, c1Score);
    }

    static {
        RULE_BANDED_DISTANCE_SCORE = new BandedDistanceScore();
        RULE_MATCH_SCORE = new MatchScore();
        RULE_MATCHES_INPUT_FLAG = new MatchesInputFlag();
        RULE_DICTIONARY_PRIORITY = new DictionaryPriority();
        RULE_STREET_ON_STREET = new StreetOnStreetMatch();
        RULE_POI_OVER_STREET = new POIOverStreet();
        RULE_ACTUAL_DISTANCE = new ActualDistance();
        RULE_PLACE_STREET_SCORE = new PlaceStreetScore();
        RULE_STREET_MATCH_QUALITY = new StreetMatchQuality();
        RULE_POI_LENGTH_CHECK = new POILengthCheck();
        RULE_NUM_FIELDS_MATCHED = new NumFieldsMatched();
        RULE_POST_CODE_SCORE = new PostCodeScore();
        RULE_AREA_NAME_3_SCORE = new AreaName3Score();
        RULE_STREET_PLACE_SCORE = new StreetPlaceScore();
        RULE_PLACE_NAME_SCORE = new PlaceNameScore();
        RULE_RATIO_MATCHED_SCORE = new RatioMatchedScore();
        ArrayList<SortRule> rules = new ArrayList<SortRule>();
        rules.add(RULE_BANDED_DISTANCE_SCORE);
        rules.add(RULE_MATCH_SCORE);
        rules.add(RULE_MATCHES_INPUT_FLAG);
        rules.add(RULE_DICTIONARY_PRIORITY);
        rules.add(RULE_STREET_ON_STREET);
        rules.add(RULE_POI_OVER_STREET);
        rules.add(RULE_PLACE_STREET_SCORE);
        rules.add(RULE_STREET_MATCH_QUALITY);
        rules.add(RULE_POI_LENGTH_CHECK);
        rules.add(RULE_NUM_FIELDS_MATCHED);
        rules.add(RULE_POST_CODE_SCORE);
        rules.add(RULE_ACTUAL_DISTANCE);
        rules.add(RULE_AREA_NAME_3_SCORE);
        rules.add(RULE_STREET_PLACE_SCORE);
        rules.add(RULE_PLACE_NAME_SCORE);
        rules.add(RULE_RATIO_MATCHED_SCORE);
        DEFAULT_RULE_LIST = Collections.unmodifiableList(rules);
    }

    static class Blank
    implements SortRule {
        Blank() {
        }

        @Override
        public String getName() {
            return "Blank";
        }

        @Override
        public int compare(SuggestedCandidate c1, SuggestedCandidate c2) {
            return 0;
        }
    }

    static class RatioMatchedScore
    implements SortRule {
        RatioMatchedScore() {
        }

        @Override
        public String getName() {
            return "ratio matched score";
        }

        @Override
        public int compare(SuggestedCandidate c1, SuggestedCandidate c2) {
            return CandidateCompareConfigurable.preferGreater(c1.getRatioMatchedScore(), c2.getRatioMatchedScore());
        }
    }

    static class PlaceNameScore
    implements SortRule {
        PlaceNameScore() {
        }

        @Override
        public String getName() {
            return "exact place name score";
        }

        @Override
        public int compare(SuggestedCandidate c1, SuggestedCandidate c2) {
            return CandidateCompareConfigurable.preferGreater(c1.getExactPlaceNameScore(), c2.getExactPlaceNameScore());
        }
    }

    static class StreetPlaceScore
    implements SortRule {
        StreetPlaceScore() {
        }

        @Override
        public String getName() {
            return "street + place score";
        }

        @Override
        public int compare(SuggestedCandidate c1, SuggestedCandidate c2) {
            return CandidateCompareConfigurable.preferGreater(c1.getMatchesStreetScore() + c1.getMatchesPlaceScore(), c2.getMatchesStreetScore() + c2.getMatchesPlaceScore());
        }
    }

    static class AreaName3Score
    implements SortRule {
        AreaName3Score() {
        }

        @Override
        public String getName() {
            return "exact area name 3 score";
        }

        @Override
        public int compare(SuggestedCandidate c1, SuggestedCandidate c2) {
            return CandidateCompareConfigurable.preferGreater(c1.getExactAreaName3Score(), c2.getExactAreaName3Score());
        }
    }

    static class PostCodeScore
    implements SortRule {
        PostCodeScore() {
        }

        @Override
        public String getName() {
            return "post code score";
        }

        @Override
        public int compare(SuggestedCandidate c1, SuggestedCandidate c2) {
            return CandidateCompareConfigurable.preferGreater(c1.getPostCodeScore(), c2.getPostCodeScore());
        }
    }

    static class NumFieldsMatched
    implements SortRule {
        NumFieldsMatched() {
        }

        @Override
        public String getName() {
            return "num fields matched";
        }

        @Override
        public int compare(SuggestedCandidate c1, SuggestedCandidate c2) {
            return c2.address.getNumFieldsMatched() - c1.address.getNumFieldsMatched();
        }
    }

    static class POILengthCheck
    implements SortRule {
        POILengthCheck() {
        }

        @Override
        public String getName() {
            return "poiLenCheck";
        }

        @Override
        public int compare(SuggestedCandidate c1, SuggestedCandidate c2) {
            int c1Type = c1.getType();
            int c2Type = c2.getType();
            if ((c1Type & 3) != 0 && (c2Type & 3) != 0) {
                int c1matchLen = c1.getNumCharsMatchedForField(7);
                int c2matchLen = c2.getNumCharsMatchedForField(7);
                if (c1matchLen > 0 && c2matchLen > 0) {
                    if (c1matchLen > c2matchLen) {
                        String matched2 = c2.getName();
                        if (matched2.length() > c2matchLen) {
                            matched2 = matched2.substring(0, c2matchLen);
                        }
                        if (c1.getName().startsWith(matched2)) {
                            return -1;
                        }
                    }
                    if (c2matchLen > c1matchLen) {
                        String matched1 = c1.getName();
                        if (matched1.length() > c1matchLen) {
                            matched1 = matched1.substring(0, c1matchLen);
                        }
                        if (c2.getName().startsWith(matched1)) {
                            return 1;
                        }
                    }
                }
            }
            return 0;
        }
    }

    static class StreetMatchQuality
    implements SortRule {
        String name;

        StreetMatchQuality() {
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int compare(SuggestedCandidate c1, SuggestedCandidate c2) {
            String c1FmtStreet = c1.getFormattedStreetAddress();
            String c2FmtStreet = c2.getFormattedStreetAddress();
            this.name = "null formatted street";
            if (c1FmtStreet != null && c2FmtStreet == null) {
                return -1;
            }
            if (c1FmtStreet == null && c2FmtStreet != null) {
                return 1;
            }
            if (c1FmtStreet != null && c2FmtStreet != null) {
                this.name = "num street chars matched";
                int c1NumMatched = c1.getNumStreetCharsMatched();
                int c2NumMatched = c2.getNumStreetCharsMatched();
                return c2NumMatched - c1NumMatched;
            }
            return 0;
        }
    }

    static class PlaceStreetScore
    implements SortRule {
        PlaceStreetScore() {
        }

        @Override
        public String getName() {
            return "placeName + streetName score";
        }

        @Override
        public int compare(SuggestedCandidate c1, SuggestedCandidate c2) {
            return CandidateCompareConfigurable.preferGreater(c1.getPlaceNameScore() + c1.getStreetNameScore(), c2.getPlaceNameScore() + c2.getStreetNameScore());
        }
    }

    static class ActualDistance
    implements SortRule {
        ActualDistance() {
        }

        @Override
        public String getName() {
            return "actual distance";
        }

        @Override
        public int compare(SuggestedCandidate c1, SuggestedCandidate c2) {
            return Double.compare(c1.getDistance(), c2.getDistance());
        }
    }

    static class POIOverStreet
    implements SortRule {
        POIOverStreet() {
        }

        @Override
        public String getName() {
            return "POI over street";
        }

        @Override
        public int compare(SuggestedCandidate c1, SuggestedCandidate c2) {
            return c1.getType() - c2.getType();
        }
    }

    static class StreetOnStreetMatch
    implements SortRule {
        StreetOnStreetMatch() {
        }

        @Override
        public String getName() {
            return "street/street over poi/street";
        }

        @Override
        public int compare(SuggestedCandidate c1, SuggestedCandidate c2) {
            int c1Type = c1.getType();
            int c2Type = c2.getType();
            boolean c1MatchedStreet = c1.address.matchedOnField(8);
            boolean c2MatchedStreet = c2.address.matchedOnField(8);
            if (c1MatchedStreet && c2MatchedStreet && c1Type != c2Type) {
                return c2Type - c1Type;
            }
            return 0;
        }
    }

    static class DictionaryPriority
    implements SortRule {
        DictionaryPriority() {
        }

        @Override
        public String getName() {
            return "dictionary priority";
        }

        @Override
        public int compare(SuggestedCandidate c1, SuggestedCandidate c2) {
            return c1.getDictionaryPriority() - c2.getDictionaryPriority();
        }
    }

    static class MatchesInputFlag
    implements SortRule {
        MatchesInputFlag() {
        }

        @Override
        public String getName() {
            return "matchesInput flag";
        }

        @Override
        public int compare(SuggestedCandidate c1, SuggestedCandidate c2) {
            boolean c2MatchesInput;
            boolean c1MatchesInput = c1.getMatchesInput();
            if (c1MatchesInput == (c2MatchesInput = c2.getMatchesInput())) {
                return 0;
            }
            return c1MatchesInput ? -1 : 1;
        }
    }

    static class MatchScore
    implements SortRule {
        MatchScore() {
        }

        @Override
        public String getName() {
            return "match score (fuzzy)";
        }

        @Override
        public int compare(SuggestedCandidate c1, SuggestedCandidate c2) {
            return c2.address.getMatchScore() - c1.address.getMatchScore();
        }
    }

    static class BandedDistanceScore
    implements SortRule {
        BandedDistanceScore() {
        }

        @Override
        public String getName() {
            return "banded distance score";
        }

        @Override
        public int compare(SuggestedCandidate c1, SuggestedCandidate c2) {
            return CandidateCompareConfigurable.preferGreater(c1.getDistanceScore(), c2.getDistanceScore());
        }
    }

    public static interface SortRule {
        public int compare(SuggestedCandidate var1, SuggestedCandidate var2);

        public String getName();
    }
}

