/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.wrapper;

import com.mapinfo.mapmarker.autosuggest.IDictionarySearchPriority;
import com.mapinfo.mapmarker.autosuggest.SimpleAddress;
import com.mapinfo.mapmarker.autosuggest.api.AutoSuggestAPI;
import com.mapinfo.mapmarker.autosuggest.api.AutoSuggestConstraints;
import com.mapinfo.mapmarker.autosuggest.api.BoundingBox;
import com.mapinfo.mapmarker.autosuggest.api.IAutoSuggestConstraints;
import com.mapinfo.mapmarker.autosuggest.api.ISuggestedCandidate;
import com.mapinfo.mapmarker.autosuggest.api.ISuggestedCandidates;
import com.mapinfo.mapmarker.autosuggest.dp.AddressMetaData;
import com.mapinfo.mapmarker.autosuggest.exception.SuggestFailureException;
import com.mapinfo.mapmarker.autosuggest.utils.GeomUtil;
import com.mapinfo.mapmarker.autosuggest.utils.LongLatBox;
import com.mapinfo.mapmarker.autosuggest.wrapper.AdditionalFieldInfo;
import com.mapinfo.mapmarker.autosuggest.wrapper.AddressSearchWrapper;
import com.mapinfo.mapmarker.autosuggest.wrapper.CurrentSearchInfo;
import com.mapinfo.mapmarker.autosuggest.wrapper.IWrappedSearchResult;
import com.mapinfo.mapmarker.autosuggest.wrapper.SearchResultCollator;
import com.mapinfo.mapmarker.autosuggest.wrapper.SuggestedCandidate;
import com.mapinfo.mapmarker.autosuggest.wrapper.SuggestedCandidates;
import com.mapinfo.mapmarker.autosuggest.wrapper.WrapperDataInfo;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.midev.geometry.DirectPosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeWrapper
implements AutoSuggestAPI {
    private static final Logger LOG = LoggerFactory.getLogger((String)CompositeWrapper.class.getName());
    List<CurrentSearchInfo> handlers = new ArrayList<CurrentSearchInfo>();

    public CompositeWrapper(List<WrapperDataInfo> autosuggestHandlers) {
        for (WrapperDataInfo info : autosuggestHandlers) {
            CurrentSearchInfo currentSearchInfo = new CurrentSearchInfo(info);
            currentSearchInfo.setWrapper(new AddressSearchWrapper(info.getHandler()));
            this.handlers.add(currentSearchInfo);
        }
    }

    @Override
    public ISuggestedCandidates suggest(String str, IAutoSuggestConstraints constraints) throws SuggestFailureException {
        return this.suggest(str, null, constraints);
    }

    @Override
    public ISuggestedCandidates suggest(String str, String country, IAutoSuggestConstraints constraints) throws SuggestFailureException {
        if (str == null) {
            return null;
        }
        AddressImpl address = new AddressImpl();
        address.setMainAddress(str);
        address.setCountry(country);
        return this.suggest((Address)address, constraints);
    }

    @Override
    public ISuggestedCandidates suggest(Address address, IAutoSuggestConstraints constraints) throws SuggestFailureException {
        if (address == null) {
            return null;
        }
        if (constraints == null) {
            constraints = new AutoSuggestConstraints();
        } else {
            BoundingBox boundingBox = (constraints = new AutoSuggestConstraints(constraints)).getBoundingBoxWGS84();
            if (boundingBox == null) {
                DirectPosition origin = constraints.getOriginPointWGS84();
                double distanceFromOrigin = constraints.getSearchDistance();
                IAutoSuggestConstraints.DistanceUnits units = constraints.getUnits();
                if (origin != null && (origin.getX() != 0.0 || origin.getY() != 0.0) && distanceFromOrigin > 0.0) {
                    LongLatBox box = new LongLatBox(origin.getX(), origin.getY(), origin.getX(), origin.getY());
                    DirectPosition longLatDelta = GeomUtil.calcDeltaLongLatDegrees(distanceFromOrigin, units, origin);
                    box.buffer(longLatDelta);
                    boundingBox = new BoundingBox(box.getWest(), box.getSouth(), box.getEast(), box.getNorth());
                    constraints.setBoundingBox(boundingBox);
                }
            } else {
                constraints.setSearchDistance(0.0);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("suggest('" + address.getMainAddress() + "')");
        }
        SearchResultCollator collatedResults = this.searchAddress(address, constraints);
        SuggestedCandidates candidateList = collatedResults.combine(address);
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("suggest('");
            sb.append(address.getMainAddress());
            sb.append("'): found [");
            for (int i = 0; i < candidateList.getCount(); ++i) {
                sb.append(" '");
                sb.append(candidateList.getCandidateAt(i).getFormattedString());
                sb.append("'");
            }
            sb.append(" ]");
            LOG.debug(sb.toString());
        }
        boolean bFoundMore = true;
        while (bFoundMore && candidateList.getCount() < constraints.getMaxCandidates()) {
            bFoundMore = this.searchMoreAddresses(address, constraints);
            if (!bFoundMore) continue;
            candidateList = collatedResults.combine(address);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("suggest('" + address.getMainAddress() + "'): found " + candidateList.getCount() + " candidate(s) (final)");
        }
        if (candidateList != null) {
            int suggestedCandidateCount = candidateList.getCount();
            ArrayList<ISuggestedCandidate> newcandidateList = new ArrayList<ISuggestedCandidate>();
            for (int i = 0; i < suggestedCandidateCount; ++i) {
                newcandidateList.add(candidateList.getCandidateAt(i));
            }
            collatedResults.reCalculateFormattedFields(newcandidateList);
        }
        return candidateList;
    }

    protected SearchResultCollator searchAddress(Address address, IAutoSuggestConstraints constraints) throws SuggestFailureException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("searchAddress('" + address.getMainAddress() + "')");
        }
        SearchResultCollator collator = new SearchResultCollator(constraints);
        IDictionarySearchPriority searchPriority = constraints.getDictionarySearchPriority();
        for (CurrentSearchInfo info : this.handlers) {
            IWrappedSearchResult result;
            AutoSuggestConstraints localConstraints = new AutoSuggestConstraints(constraints);
            if (!this.canSearchCountry(address, info)) continue;
            if ("XWG".equals(info.getDataInfo().getCountry())) {
                if (localConstraints.isCompressAreaResults()) {
                    localConstraints.setCompressAreaResults(false);
                }
                if (localConstraints.getFuzzyMatchMode() == IAutoSuggestConstraints.FuzzyMatchMode.HARD_MATCH || localConstraints.getFuzzyMatchMode() == IAutoSuggestConstraints.FuzzyMatchMode.SOFT_MATCH) {
                    localConstraints.setFuzzyMatchMode(IAutoSuggestConstraints.FuzzyMatchMode.NONE);
                }
            }
            String dataName = info.getDataInfo().getDictionaryName();
            if (searchPriority != null && !searchPriority.isDictionaryAvailableForSearch(dataName) || (result = info.getWrapper().searchAddress(address, localConstraints)) == null) continue;
            info.setResult(result);
            collator.add(info);
        }
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("searchAddress('");
            sb.append(address.getMainAddress());
            sb.append("'): found [");
            for (CurrentSearchInfo info : collator.getResults()) {
                if (info.getResult() == null || info.getResult().getResultIterator() == null) continue;
                Iterator<SimpleAddress> iter = info.getResult().getResultIterator();
                while (iter.hasNext()) {
                    SimpleAddress addr = iter.next();
                    sb.append(" '" + addr + "'");
                }
            }
            sb.append(" ]");
            LOG.debug(sb.toString());
        }
        return collator;
    }

    private boolean canSearchCountry(Address address, CurrentSearchInfo searchInfo) {
        String inputCntry = address.getCountry();
        if (MMUtils.isEmpty((String)inputCntry)) {
            return true;
        }
        return inputCntry.equalsIgnoreCase(searchInfo.getDataInfo().getCountry()) || searchInfo.getDataInfo().getHandler().getAddressMetaData().getSupportedCountries() != null && (searchInfo.getDataInfo().getHandler().getAddressMetaData().getSupportedCountries().contains(',' + inputCntry + ',') || searchInfo.getDataInfo().getHandler().getAddressMetaData().getSupportedCountries().contains(',' + inputCntry) || searchInfo.getDataInfo().getHandler().getAddressMetaData().getSupportedCountries().contains(inputCntry + ','));
    }

    protected boolean searchMoreAddresses(Address address, IAutoSuggestConstraints constraints) {
        IDictionarySearchPriority searchPriority = constraints.getDictionarySearchPriority();
        boolean moreCandidatesFound = false;
        for (CurrentSearchInfo info : this.handlers) {
            int numCandidates;
            if (!this.canSearchCountry(address, info)) continue;
            String dataName = info.getDataInfo().getDictionaryName();
            if (searchPriority != null && !searchPriority.isDictionaryAvailableForSearch(dataName)) continue;
            int n = numCandidates = info.getResult() != null ? info.getResult().getCandidateCount() : constraints.getMaxCandidates();
            int numNewCandidates = info.getWrapper().searchMoreAddresses(address, constraints, info);
            if (numNewCandidates <= numCandidates) continue;
            moreCandidatesFound = true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("searchMoreAddresses('" + address.getMainAddress() + "'): done");
        }
        return moreCandidatesFound;
    }

    @Override
    public ISuggestedCandidates findNearestPOIs(IAutoSuggestConstraints constraints) throws SuggestFailureException {
        return this.findNearestPOIs(null, constraints);
    }

    @Override
    public ISuggestedCandidates findNearestPOIs(String country, IAutoSuggestConstraints constraints) throws SuggestFailureException {
        ArrayList<ISuggestedCandidate> candidateList = new ArrayList<ISuggestedCandidate>();
        SuggestedCandidates candidates = new SuggestedCandidates(candidateList);
        int maximum = constraints.getMaxCandidates();
        DirectPosition origin = constraints.getOriginPoint();
        double searchDistance = constraints.getSearchDistance();
        if (searchDistance > 0.0) {
            searchDistance = GeomUtil.convertToMeters(searchDistance, constraints.getUnits());
        }
        List<CurrentSearchInfo> preferredHandlers = this.applyLanguagePrefs(constraints, this.handlers);
        if (origin != null) {
            for (CurrentSearchInfo info : preferredHandlers) {
                WrapperDataInfo wdi = info.getDataInfo();
                if (country != null && !wdi.getCountry().equals(country)) break;
                ArrayList<SimpleAddress> addresses = new ArrayList<SimpleAddress>();
                addresses.addAll(info.getWrapper().doPointDistanceSearch(origin, searchDistance, maximum));
                AddressMetaData metaData = wdi.getHandler().getAddressMetaData();
                AdditionalFieldInfo afi = new AdditionalFieldInfo(metaData);
                AddressImpl fakeInput = new AddressImpl();
                fakeInput.setMainAddress(" ");
                for (SimpleAddress addr : addresses) {
                    candidateList.add(new SuggestedCandidate((Address)fakeInput, addr, constraints, wdi.getType(), wdi.getCountry(), afi, metaData.getDataName(), -1, metaData.isCustomData(), null));
                }
            }
        }
        return candidates;
    }

    private List<CurrentSearchInfo> applyLanguagePrefs(IAutoSuggestConstraints c, List<CurrentSearchInfo> handlerList) {
        List<CurrentSearchInfo> preferredHandlers = handlerList;
        if (handlerList.size() > 1) {
            String preferredLanguage = null;
            Locale locale = c.getLocale();
            if (locale != null) {
                preferredLanguage = locale.getLanguage();
            }
            if (preferredLanguage == null) {
                preferredLanguage = "";
            }
            preferredHandlers = new ArrayList<CurrentSearchInfo>();
            HashMap dataSets = new HashMap();
            for (CurrentSearchInfo handler : handlerList) {
                ArrayList<CurrentSearchInfo> handlers;
                String language = handler.getDataInfo().getHandler().getAddressMetaData().getLanguage();
                if (language == null || language.isEmpty()) {
                    preferredHandlers.add(handler);
                    continue;
                }
                String country = handler.getDataInfo().getCountry();
                if (dataSets.containsKey(country)) {
                    Map languages = (Map)dataSets.get(country);
                    if (languages.containsKey(language)) {
                        ((List)languages.get(language)).add(handler);
                        continue;
                    }
                    handlers = new ArrayList();
                    handlers.add(handler);
                    languages.put(language, handlers);
                    continue;
                }
                HashMap l = new HashMap();
                handlers = new ArrayList<CurrentSearchInfo>();
                handlers.add(handler);
                l.put(language, handlers);
                dataSets.put(country, l);
            }
            for (Map langMap : dataSets.values()) {
                if (langMap.containsKey(preferredLanguage)) {
                    preferredHandlers.addAll((Collection)langMap.get(preferredLanguage));
                    continue;
                }
                if (preferredLanguage.length() == 0) {
                    for (String language : langMap.keySet()) {
                        if (language.equals(Locale.ENGLISH.getLanguage())) continue;
                        preferredHandlers.addAll((Collection)langMap.get(language));
                    }
                    continue;
                }
                for (String language : langMap.keySet()) {
                    if (!language.equals(Locale.ENGLISH.getLanguage())) continue;
                    preferredHandlers.addAll((Collection)langMap.get(language));
                }
            }
        }
        return preferredHandlers;
    }
}

