/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.wrapper;

import com.mapinfo.mapmarker.autosuggest.FieldMatchInfo;
import com.mapinfo.mapmarker.autosuggest.SimpleAddress;
import com.mapinfo.mapmarker.autosuggest.api.ISuggestedCandidate;
import com.mapinfo.mapmarker.autosuggest.utils.StringNormalizer;
import com.mapinfo.mapmarker.autosuggest.wrapper.ICandidateScoreRule;
import com.mapinfo.mapmarker.autosuggest.wrapper.SuggestedCandidate;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import java.util.Iterator;
import java.util.List;

public class ScoreRuleFields
implements ICandidateScoreRule {
    private SimpleAddress address = null;

    @Override
    public void apply(ISuggestedCandidate candidate) {
        Object input;
        String areaName3;
        String inputAreaName1;
        SuggestedCandidate c = (SuggestedCandidate)candidate;
        this.address = c.address;
        double addressNumberScore = 0.0;
        double streetNameScore = 0.0;
        double placeNameScore = 0.0;
        double areaName1Score = 0.0;
        double areaName2Score = 0.0;
        double areaName3Score = 0.0;
        double areaName4Score = 0.0;
        double postCodeScore = 0.0;
        double exactAreaName3Score = 0.0;
        if (this.address.matchedOnField(4)) {
            addressNumberScore += 1.0;
        }
        if (this.address.matchedOnField(8)) {
            streetNameScore += 1.0;
        }
        if (this.address.matchedOnField(7) || this.address.matchedOnField(24)) {
            placeNameScore += 1.0;
        }
        if (this.address.matchedOnField(16)) {
            areaName1Score += 1.0;
            areaName2Score += this.duplicateMatchBonus(16, 17);
            areaName3Score += this.duplicateMatchBonus(16, 18);
            areaName4Score += this.duplicateMatchBonus(16, 19);
        } else if ("XWG".equals(c.getDictionaryName()) && (inputAreaName1 = c.getInputAddress().getAreaName1()) != null) {
            String normalizedAreaName1 = StringNormalizer.normalise(inputAreaName1);
            List<String> dataAreaName1s = c.address.getField(FieldType.AREA_NAME_1_FIELD_TYPE.getKey());
            if (dataAreaName1s != null) {
                for (String s : dataAreaName1s) {
                    if (!normalizedAreaName1.equalsIgnoreCase(StringNormalizer.normalise(s))) continue;
                    areaName1Score += 1.0;
                    break;
                }
            }
        }
        if (this.address.matchedOnField(17)) {
            areaName2Score += 1.0;
            areaName3Score += this.duplicateMatchBonus(17, 18);
            areaName4Score += this.duplicateMatchBonus(17, 19);
        }
        if (this.address.matchedOnField(18)) {
            areaName3Score += 1.0;
            areaName4Score += this.duplicateMatchBonus(18, 19);
        }
        if (this.address.matchedOnField(19)) {
            areaName4Score += 1.0;
        }
        if (this.address.matchedOnField(15)) {
            postCodeScore += 1.0;
        }
        if ((areaName3 = c.getAreaName3(false)) != null) {
            areaName3 = StringNormalizer.normalise(areaName3);
            areaName3 = areaName3.toLowerCase();
            List<String> input2 = c.getInput();
            for (String inputToken : input2) {
                if (!areaName3.startsWith(StringNormalizer.normalise(inputToken = inputToken.replaceAll("[,:-]", "")).toLowerCase())) continue;
                exactAreaName3Score = 1.0;
                break;
            }
        }
        boolean exactAreaName3Match = false;
        boolean exactMatchAreaName3NonNormalized = false;
        if (exactAreaName3Score > 0.0) {
            StringBuilder b = new StringBuilder();
            input = c.getInput();
            Iterator<String> iterator = input.iterator();
            while (iterator.hasNext()) {
                String inputToken = iterator.next();
                b.append(inputToken);
                b.append(' ');
            }
            String inputString = StringNormalizer.normalise(b.toString().trim()).toLowerCase();
            if (inputString.equals(areaName3)) {
                exactAreaName3Match = true;
            }
        }
        if (areaName3Score > 0.0 && this.address.getFieldMatchInfo(18) != null && "XWG".equals(c.getDictionaryName())) {
            int count = c.getInput().size();
            if (count == 1 || this.address.getFieldMatchInfo(18).getMatchStartCharNdx() == 0) {
                String nonNormalized = c.getInput().get(0).toUpperCase();
                if (!nonNormalized.equals(StringNormalizer.normalise(nonNormalized)) && c.getInput().get(0).toUpperCase().equals(this.address.getFieldValue(18, this.address.getFieldMatchInfo(18).getMatchedValueNdx()).toUpperCase())) {
                    exactMatchAreaName3NonNormalized = true;
                }
            } else {
                String testField;
                String testInput;
                input = this.getInputForMatch(c, this.address.getFieldMatchInfo(18));
                if (input != null && (testInput = ((String)input).toLowerCase()).equals(testField = this.address.getFieldValue(18, this.address.getFieldMatchInfo(18).getMatchedValueNdx()).toLowerCase())) {
                    exactMatchAreaName3NonNormalized = true;
                }
            }
        }
        c.setAddressNumberScore(addressNumberScore);
        c.setStreetNameScore(streetNameScore);
        c.setPlaceNameScore(placeNameScore);
        c.setAreaName1Score(areaName1Score);
        c.setAreaName2Score(areaName2Score);
        c.setAreaName3Score(areaName3Score);
        c.setAreaName4Score(areaName4Score);
        c.setPostCodeScore(postCodeScore);
        c.setExactAreaName3Score(exactAreaName3Score);
        c.setExactMatchAreaName3(exactAreaName3Match);
        c.setExactAreaName3MatchNonNormalized(exactMatchAreaName3NonNormalized);
        this.address = null;
    }

    private String getInputForMatch(SuggestedCandidate candidate, FieldMatchInfo info) {
        if (info == null) {
            return null;
        }
        int fieldStart = this.getClosestSpaceLocation(info.getMatchStartCharNdx(), candidate.getInputAddress().getMainAddress());
        int fieldEnd = this.getClosestSpaceLocation(info.getMatchStartCharNdx() + info.getMatchedLength(), candidate.getInputAddress().getMainAddress());
        if (fieldStart < 0 || fieldEnd < 0) {
            return null;
        }
        return candidate.getInputAddress().getMainAddress().substring(fieldStart, fieldEnd).trim();
    }

    private int getClosestSpaceLocation(int start, String s) {
        if (start == 0) {
            return start;
        }
        if (s.length() > start) {
            if (s.charAt(start) == ' ') {
                return start;
            }
            for (int i = 1; i < s.length() / 2; ++i) {
                if (start - i > 0 && s.charAt(start - i) == ' ') {
                    return start - i;
                }
                if (start + i >= s.length() || s.charAt(start + 1) != ' ') continue;
                return start + i;
            }
        } else {
            return s.length();
        }
        return -1;
    }

    private double duplicateMatchBonus(int sourceField, int valuesField) {
        double factor = 0.0;
        String target = this.address.getFieldMatchInfo(sourceField).getMatchedString().toLowerCase();
        List<String> values = this.address.getField(valuesField);
        if (values != null) {
            for (String value : values) {
                if (value == null || !value.toLowerCase().contains(target)) continue;
                factor += 0.75;
                break;
            }
        }
        return factor;
    }
}

