/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.wrapper;

import com.mapinfo.mapmarker.autosuggest.FieldMatchInfo;
import com.mapinfo.mapmarker.autosuggest.SimpleAddress;
import com.mapinfo.mapmarker.autosuggest.api.ISuggestedCandidate;
import com.mapinfo.mapmarker.autosuggest.utils.StringNormalizer;
import com.mapinfo.mapmarker.autosuggest.wrapper.ICandidateScoreRule;
import com.mapinfo.mapmarker.autosuggest.wrapper.SuggestedCandidate;
import com.mapinfo.mapmarker.autosuggest.wrapper.SuggestedCandidateRange;
import com.mapinfo.mapmarker.autosuggest.wrapper.SuggestedCandidateRangeUnit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class ScoreRulePreferOriginal
implements ICandidateScoreRule {
    @Override
    public void apply(ISuggestedCandidate candidate) {
        SimpleAddress address = ((SuggestedCandidate)candidate).address;
        String hnr = address.getHNR();
        List<String> streetNameList = address.getField(8);
        List<String> placeNameList = address.getField(7);
        FieldMatchInfo streetFieldMatchInfo = address.getFieldMatchInfo(8);
        FieldMatchInfo placeFieldMatchInfo = address.getFieldMatchInfo(7);
        ArrayList<String> input = new ArrayList<String>();
        for (String token : candidate.getInput()) {
            String normToken = StringNormalizer.normalise(token);
            if ("".equals(normToken)) continue;
            input.add(normToken);
        }
        int numTokensMatched = 0;
        int streetTokenMatched = 0;
        int placeNameTokenMatched = 0;
        boolean bMatchesInput = false;
        if (streetNameList == null || streetFieldMatchInfo == null && placeFieldMatchInfo == null) {
            String inputToken;
            String fmtLoc = StringNormalizer.normalise(candidate.getFormattedLocationAddress());
            Iterator iterator = input.iterator();
            if (iterator.hasNext() && fmtLoc.contains(inputToken = (String)iterator.next())) {
                ++numTokensMatched;
            }
            bMatchesInput = numTokensMatched > 0;
            ((SuggestedCandidate)candidate).setMatchesInput(bMatchesInput);
        }
        double streetNameScore = 0.0;
        double placeNameScore = 0.0;
        boolean isLastFiedMatchedOnStreet = false;
        boolean isLastFiedMatchedOnPlaceName = false;
        for (String inputToken : input) {
            boolean bUsedInputToken = false;
            if (streetNameList != null) {
                for (String streetName : streetNameList) {
                    streetName = StringNormalizer.normalise(streetName);
                    if (!inputToken.equals(hnr) && streetName.startsWith(inputToken)) {
                        ++numTokensMatched;
                        ++streetTokenMatched;
                        isLastFiedMatchedOnStreet = true;
                        isLastFiedMatchedOnPlaceName = false;
                    } else if (isLastFiedMatchedOnStreet && !inputToken.equals(hnr) && streetName.contains(inputToken)) {
                        ++numTokensMatched;
                        ++streetTokenMatched;
                        isLastFiedMatchedOnStreet = true;
                        isLastFiedMatchedOnPlaceName = false;
                    }
                    StringTokenizer streetNameTokens = new StringTokenizer(streetName);
                    while (streetNameTokens.hasMoreTokens()) {
                        String streetToken = streetNameTokens.nextToken();
                        if (bUsedInputToken || !streetToken.startsWith(inputToken)) continue;
                        streetNameScore += 0.1;
                        bUsedInputToken = true;
                    }
                }
            }
            if (placeNameList == null) continue;
            for (String placeName : placeNameList) {
                if ((placeName = StringNormalizer.normalise(placeName)).startsWith(inputToken)) {
                    ++numTokensMatched;
                    ++placeNameTokenMatched;
                    isLastFiedMatchedOnPlaceName = true;
                    isLastFiedMatchedOnStreet = false;
                } else if (isLastFiedMatchedOnPlaceName && !inputToken.equals(hnr) && placeName.contains(inputToken)) {
                    ++numTokensMatched;
                    ++placeNameTokenMatched;
                    isLastFiedMatchedOnPlaceName = true;
                    isLastFiedMatchedOnStreet = false;
                }
                StringTokenizer placeNameTokens = new StringTokenizer(placeName);
                while (placeNameTokens.hasMoreTokens()) {
                    String placeToken = placeNameTokens.nextToken();
                    if (bUsedInputToken || !placeToken.startsWith(inputToken)) continue;
                    placeNameScore += 0.1;
                    bUsedInputToken = true;
                }
            }
        }
        int rangeCount = candidate.getRangeCount();
        if (rangeCount > 0 && ((SuggestedCandidate)candidate).address.getNumFieldsMatched() == 1) {
            double score = 0.0;
            boolean ismatchRangeUnit = false;
            int unitCount = candidate.getSuggestedRange(0).getUnitCount();
            if (unitCount > 0 && (score = ((SuggestedCandidateRangeUnit)candidate.getSuggestedRange(0).getUnitAt(0)).getScore()) != 0.0 && score % 1.0 == 0.0) {
                ismatchRangeUnit = true;
            }
            if (!ismatchRangeUnit) {
                score = ((SuggestedCandidateRange)candidate.getSuggestedRange(0)).getScore();
            }
            if (!ismatchRangeUnit && score != 0.0 && score % 1.0 == 0.0) {
                ismatchRangeUnit = true;
            }
            ((SuggestedCandidate)candidate).setPerfectRangeUnitMatched(ismatchRangeUnit);
        }
        if (streetTokenMatched == input.size() || placeNameTokenMatched == input.size()) {
            ((SuggestedCandidate)candidate).setPerfectRangeUnitMatched(true);
        }
        bMatchesInput = numTokensMatched > 0;
        ((SuggestedCandidate)candidate).setMatchesInput(bMatchesInput);
        ((SuggestedCandidate)candidate).setMatchesStreetScore(streetNameScore);
        ((SuggestedCandidate)candidate).setMatchesPlaceScore(placeNameScore);
    }
}

