/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.wrapper;

import com.mapinfo.mapmarker.autosuggest.AddressStringFormatter;
import com.mapinfo.mapmarker.autosuggest.FieldMatchInfo;
import com.mapinfo.mapmarker.autosuggest.api.ISuggestedRangeUnit;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleUnit;
import com.mapinfo.mapmarker.autosuggest.utils.SuggestedCandidateRangeUnitUtils;
import com.mapinfo.mapmarker.autosuggest.wrapper.AdditionalFieldInfo;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Map;

public class SuggestedCandidateRangeUnit
implements ISuggestedRangeUnit {
    private SimpleUnit simpleUnit;
    private Map<Integer, FieldMatchInfo> fieldMatchInfos;
    private double score;
    private boolean isMatchedRangeUnit;
    private Map<String, String> additionalFields;
    AdditionalFieldInfo additionalFieldInfo;
    private String[] streetFormatPattern;

    public SuggestedCandidateRangeUnit(SimpleUnit simpleUnit, Map<Integer, FieldMatchInfo> fieldMatchInfos, AdditionalFieldInfo additionalFieldInfo, String[] streetFormatFields) {
        this.simpleUnit = simpleUnit;
        this.fieldMatchInfos = fieldMatchInfos;
        this.additionalFieldInfo = additionalFieldInfo;
        this.streetFormatPattern = streetFormatFields;
        String formattedUnitString = simpleUnit.getFieldValue(201);
        simpleUnit.getFields().remove(201);
        this.additionalFields = SuggestedCandidateRangeUnitUtils.populateAdditionalFields(simpleUnit.getFields(), additionalFieldInfo);
        this.additionalFields.put("FORMATTED_STRING", formattedUnitString);
    }

    @Override
    public String getUnitString() {
        StringBuilder builder = new StringBuilder();
        if (this.simpleUnit != null) {
            AddressStringFormatter formatter = new AddressStringFormatter(this.fieldMatchInfos, this.simpleUnit);
            builder.append(formatter.getFormattedAddressString(false, this.streetFormatPattern).getAddressString());
        }
        return builder.toString().trim();
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public boolean isMatchedRangeUnit() {
        return this.isMatchedRangeUnit;
    }

    public void setMatchedRangeUnit(boolean isMatchedRangeUnit) {
        this.isMatchedRangeUnit = isMatchedRangeUnit;
    }

    @Override
    public Map<String, String> getAdditionalFields() {
        return this.additionalFields;
    }

    protected String getMatchingString(String additionalFieldKey) {
        FieldMatchInfo fieldMatchInfo;
        String matchedString = null;
        if (!StringUtilities.isEmpty((String)additionalFieldKey) && (fieldMatchInfo = this.fieldMatchInfos.get(this.additionalFieldInfo.getIDForKey(additionalFieldKey))) != null && fieldMatchInfo.getMatchedLength() > 0) {
            matchedString = fieldMatchInfo.getMatchedString();
        }
        return matchedString;
    }
}

