/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.unit;

import com.mapinfo.midev.util.ArgumentValidator;
import com.mapinfo.midev.util.PrivateAPI;
import com.mapinfo.midev.util.PublicAPI;

@PublicAPI
public enum AngularUnit {
    DEGREE(1.0, "deg", "deg", "degree", "9102"),
    MINUTE(0.016666666666666666, null, "min", "arc-minute", "9103"),
    SECOND(2.777777777777778E-4, null, "sec", "arc-second", "9104"),
    RADIAN(57.29577951308232, "rad", "rad", "radian", "9101"),
    GRADIAN(0.9, null, null, "gradian", "9105");

    private final String m_mapInfoCode;
    private final String m_mapBasicAbbreviation;
    private final String m_displayName;
    private final String m_epsgCode;
    private final double m_degreesPerUnit;

    private AngularUnit(double degreesPerUnit, String mapInfoCode, String mapBasicAbbreviation, String displayName, String epsgCode) {
        this.m_degreesPerUnit = degreesPerUnit;
        this.m_mapInfoCode = mapInfoCode;
        this.m_mapBasicAbbreviation = mapBasicAbbreviation;
        this.m_displayName = displayName;
        this.m_epsgCode = epsgCode;
    }

    public double getDegreesPerUnit() {
        return this.m_degreesPerUnit;
    }

    @PrivateAPI
    public String getMapInfoCode() {
        return this.m_mapInfoCode;
    }

    @PrivateAPI
    public String getMapBasicAbbreviation() {
        return this.m_mapBasicAbbreviation;
    }

    @PrivateAPI
    public String getDisplayName() {
        return this.m_displayName;
    }

    @PrivateAPI
    public String getEPSGCode() {
        return this.m_epsgCode;
    }

    public static double convert(double angle, AngularUnit fromUnit, AngularUnit toUnit) {
        ArgumentValidator.assertNotNullReference((String)"fromUnit", (Object)((Object)fromUnit));
        ArgumentValidator.assertNotNullReference((String)"toUnit", (Object)((Object)toUnit));
        double result = angle;
        if (fromUnit != toUnit) {
            result = angle * (fromUnit.m_degreesPerUnit / toUnit.m_degreesPerUnit);
        }
        return result;
    }

    @PrivateAPI
    public static AngularUnit getFromMapBasicAbbreviation(String abbreviation) {
        ArgumentValidator.assertNotNullReference((String)"abbreviation", (Object)abbreviation);
        String trimmedAbbreviation = abbreviation.trim();
        for (AngularUnit angularUnit : AngularUnit.values()) {
            if (!trimmedAbbreviation.equals(angularUnit.m_mapBasicAbbreviation)) continue;
            return angularUnit;
        }
        return null;
    }

    @PrivateAPI
    public static AngularUnit getFromDisplayName(String code) {
        ArgumentValidator.assertNotNullReference((String)"code", (Object)code);
        String trimmedCode = AngularUnit.trim(code);
        for (AngularUnit angularUnit : AngularUnit.values()) {
            if (!trimmedCode.equals(angularUnit.m_displayName)) continue;
            return angularUnit;
        }
        return null;
    }

    private static String trim(String inputString) {
        return inputString.trim().replaceAll("\\s+", " ").toLowerCase();
    }
}

