/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.unit;

import com.mapinfo.midev.unit.AreaUnit;
import com.mapinfo.midev.unit.ComputationType;
import com.mapinfo.midev.util.ArgumentValidator;
import com.mapinfo.midev.util.PublicAPI;
import java.io.Serializable;

@PublicAPI
public final class Area
implements Serializable {
    private final AreaUnit m_unit;
    private final double m_value;
    private final ComputationType m_computationType;

    public Area(double value, AreaUnit unit) {
        this(value, unit, ComputationType.SPHERICAL);
    }

    public Area(double value, AreaUnit unit, ComputationType computationType) {
        ArgumentValidator.assertNotNullReference((String)"unit", (Object)((Object)unit));
        ArgumentValidator.assertNotNullReference((String)"ct", (Object)((Object)computationType));
        ArgumentValidator.assertNotOutOfRangeMinimum((String)"value", (double)value, (double)0.0);
        this.m_value = value;
        this.m_unit = unit;
        this.m_computationType = computationType;
    }

    public AreaUnit getUnit() {
        return this.m_unit;
    }

    public double getValue() {
        return this.m_value;
    }

    public double getValue(AreaUnit unit) {
        ArgumentValidator.assertNotNullReference((String)"unit", (Object)((Object)unit));
        double val = this.m_value;
        if (this.m_unit != unit) {
            val = this.m_value * (this.m_unit.getSquareMetersPerUnit() / unit.getSquareMetersPerUnit());
        }
        return val;
    }

    public ComputationType getComputationType() {
        return this.m_computationType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Area area = (Area)o;
        if (Double.compare(area.m_value, this.m_value) != 0) {
            return false;
        }
        if (this.m_computationType != area.m_computationType) {
            return false;
        }
        return this.m_unit == area.m_unit;
    }

    public int hashCode() {
        int result = 17;
        result = 29 * result + this.m_unit.hashCode();
        long temp = this.m_value != 0.0 ? Double.doubleToLongBits(this.m_value) : 0L;
        result = 29 * result + (int)(temp ^ temp >>> 32);
        result = 29 * result + this.m_computationType.hashCode();
        return result;
    }
}

