/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.unit;

import com.mapinfo.midev.unit.Angle;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.ComputationType;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.ArgumentValidator;
import com.mapinfo.midev.util.PublicAPI;
import java.io.Serializable;

@PublicAPI
public final class Length
implements Serializable,
Comparable<Length> {
    private final LinearUnit m_unit;
    private final double m_value;
    private final ComputationType m_computationType;

    public Length(double value, LinearUnit unit) {
        this(value, unit, ComputationType.SPHERICAL);
    }

    public Length(double value, LinearUnit unit, ComputationType ct) {
        ArgumentValidator.assertNotNullReference((String)"unit", (Object)((Object)unit));
        ArgumentValidator.assertNotNullReference((String)"ct", (Object)((Object)ct));
        ArgumentValidator.assertNotOutOfRangeMinimum((String)"value", (double)value, (double)0.0);
        this.m_value = value;
        this.m_unit = unit;
        this.m_computationType = ct;
    }

    public LinearUnit getUnit() {
        return this.m_unit;
    }

    public double getValue() {
        return this.m_value;
    }

    public ComputationType getComputationType() {
        return this.m_computationType;
    }

    public double getValue(LinearUnit unit) {
        return LinearUnit.convert(this.m_value, this.m_unit, unit);
    }

    public boolean equivalent(Length length) {
        return this.equivalent(length, 0.0);
    }

    public boolean equivalent(Length length, double tolerance) {
        double thisValue;
        if (length == null) {
            return false;
        }
        double lengthValue = length.m_unit.getMetersPerUnit() * length.m_value;
        return Math.abs(lengthValue - (thisValue = this.m_unit.getMetersPerUnit() * this.m_value)) <= tolerance;
    }

    public static Angle convert(Length length) {
        double meters = length.getValue(LinearUnit.METER);
        double degrees = meters * 8.993220293948077E-6;
        return new Angle(degrees, AngularUnit.DEGREE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Length length = (Length)o;
        if (Double.compare(length.m_value, this.m_value) != 0) {
            return false;
        }
        if (this.m_computationType != length.m_computationType) {
            return false;
        }
        return this.m_unit == length.m_unit;
    }

    public int hashCode() {
        int result = 17;
        result = 29 * result + this.m_unit.hashCode();
        long temp = this.m_value != 0.0 ? Double.doubleToLongBits(this.m_value) : 0L;
        result = 29 * result + (int)(temp ^ temp >>> 32);
        result = 29 * result + this.m_computationType.hashCode();
        return result;
    }

    public static Length convert(Length length, LinearUnit unit) {
        ArgumentValidator.assertNotNullReference((String)"length", (Object)length);
        ArgumentValidator.assertNotNullReference((String)"unit", (Object)((Object)unit));
        if (unit == length.getUnit()) {
            return length;
        }
        return new Length(length.getValue(unit), unit, length.getComputationType());
    }

    @Override
    public int compareTo(Length length) {
        return Double.compare(this.getValue(length.getUnit()), length.getValue());
    }

    public String toString() {
        return "Length[" + this.m_value + " " + (Object)((Object)this.m_unit) + " " + (Object)((Object)this.m_computationType) + "]";
    }
}

