/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.unit;

import com.mapinfo.midev.util.ArgumentValidator;
import com.mapinfo.midev.util.PrivateAPI;
import com.mapinfo.midev.util.PublicAPI;

@PublicAPI
public enum LinearUnit {
    INCH(0.0254, "in", "in", "inch", null, 2),
    IN(0.0254, "in", "in", "inch", null, 2),
    FOOT(0.3048, "ft", "ft", "foot", "9002", 3),
    FT(0.3048, "ft", "ft", "foot", "9002", 3),
    YARD(0.9144, "yd", "yd", "yard", null, 4),
    YD(0.9144, "yd", "yd", "yard", null, 4),
    MILE(1609.344, "mi", "mi", "mile", "9093", 0),
    MI(1609.344, "mi", "mi", "mile", "9093", 0),
    MILLIMETER(0.001, "mm", "mm", "millimeter", null, 5),
    MM(0.001, "mm", "mm", "millimeter", null, 5),
    CENTIMETER(0.01, "cm", "cm", "centimeter", null, 6),
    CM(0.01, "cm", "cm", "centimeter", null, 6),
    METER(1.0, "m", "m", "meter", "9001", 7),
    M(1.0, "m", "m", "meter", "9001", 7),
    KILOMETER(1000.0, "km", "km", "kilometer", "9036", 1),
    KM(1000.0, "km", "km", "kilometer", "9036", 1),
    SURVEY_FOOT(0.3048006096012192, "sft", "survey ft", "survey foot", "9003", 8),
    NAUTICAL_MILE(1852.0, "nmi", "nmi", "nautical mile", "9030", 9),
    LINK(0.201168, "li", "li", "link", "9034", 30),
    CHAIN(20.1168, "ch", "ch", "chain", "9033", 31),
    ROD(5.0292, "rd", "rd", "rod", null, 32),
    TWIP(1.763888888888889E-5, "twip", "twip", "twip", null, 10),
    POINT(3.5277777777777776E-4, "pt", "pt", "point", null, 11),
    PICA(0.004233333333333333, "pica", "pica", "pica", null, 12);

    private final double m_metersPerUnit;
    private final String m_mapInfoCode;
    private final String m_mapBasicAbbreviation;
    private final String m_displayName;
    private final String m_epsgCode;
    private final int m_miProIndex;

    private LinearUnit(double metersPerUnit, String mapInfoCode, String mapBasicAbbreviation, String displayName, String epsgCode, int miProIndex) {
        this.m_metersPerUnit = metersPerUnit;
        this.m_mapInfoCode = mapInfoCode;
        this.m_mapBasicAbbreviation = mapBasicAbbreviation;
        this.m_displayName = displayName;
        this.m_epsgCode = epsgCode;
        this.m_miProIndex = miProIndex;
    }

    public double getMetersPerUnit() {
        return this.m_metersPerUnit;
    }

    @PrivateAPI
    public String getMapInfoCode() {
        return this.m_mapInfoCode;
    }

    @PrivateAPI
    public String getDisplayName() {
        return this.m_displayName;
    }

    @PrivateAPI
    public String getMapBasicAbbreviation() {
        return this.m_mapBasicAbbreviation;
    }

    @PrivateAPI
    public String getEPSGCode() {
        return this.m_epsgCode;
    }

    @PrivateAPI
    public int getMapInfoProIndex() {
        return this.m_miProIndex;
    }

    public static double convert(double length, LinearUnit fromUnit, LinearUnit toUnit) {
        ArgumentValidator.assertNotNullReference((String)"fromUnit", (Object)((Object)fromUnit));
        ArgumentValidator.assertNotNullReference((String)"toUnit", (Object)((Object)toUnit));
        double result = length;
        if (fromUnit != toUnit) {
            result = length * (fromUnit.m_metersPerUnit / toUnit.m_metersPerUnit);
        }
        return result;
    }

    public static LinearUnit valueOfIgnoreCase(String name) {
        ArgumentValidator.assertNotNullReference((String)"name", (Object)name);
        for (LinearUnit linearUnit : LinearUnit.values()) {
            if (!linearUnit.name().equalsIgnoreCase(name)) continue;
            return linearUnit;
        }
        throw new IllegalArgumentException("Invalid linear unit: " + name);
    }

    @PrivateAPI
    public static LinearUnit getFromMapInfoCode(String code) {
        ArgumentValidator.assertNotNullReference((String)"code", (Object)code);
        String trimmedCode = LinearUnit.trim(code);
        for (LinearUnit linearUnit : LinearUnit.values()) {
            if (!trimmedCode.equals(linearUnit.m_mapInfoCode)) continue;
            return linearUnit;
        }
        return null;
    }

    @PrivateAPI
    public static LinearUnit getFromMapBasicAbbreviation(String abbreviation) {
        ArgumentValidator.assertNotNullReference((String)"abbreviation", (Object)abbreviation);
        String trimmedAbbreviation = LinearUnit.trim(abbreviation);
        for (LinearUnit linearUnit : LinearUnit.values()) {
            if (!trimmedAbbreviation.equals(linearUnit.m_mapBasicAbbreviation)) continue;
            return linearUnit;
        }
        return null;
    }

    @PrivateAPI
    public static LinearUnit getFromMapInfoProIndex(int index) {
        for (LinearUnit linearUnit : LinearUnit.values()) {
            if (linearUnit.m_miProIndex != index) continue;
            return linearUnit;
        }
        return null;
    }

    private static String trim(String inputString) {
        return inputString.trim().replaceAll("\\s+", " ").toLowerCase();
    }
}

