/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.unit;

import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.ArgumentValidator;
import com.mapinfo.midev.util.PublicAPI;
import java.io.Serializable;

@PublicAPI
public final class Offset
implements Serializable {
    private final LinearUnit m_unit;
    private final double m_value;

    public Offset(double value, LinearUnit unit) {
        ArgumentValidator.assertNotNullReference((String)"unit", (Object)((Object)unit));
        this.m_value = value;
        this.m_unit = unit;
    }

    public LinearUnit getUnit() {
        return this.m_unit;
    }

    public double getValue() {
        return this.m_value;
    }

    public double getValue(LinearUnit unit) {
        return LinearUnit.convert(this.m_value, this.m_unit, unit);
    }

    public boolean equivalent(Offset offset) {
        return this.equivalent(offset, 0.0);
    }

    public boolean equivalent(Offset offset, double tolerance) {
        double thisValue;
        if (offset == null) {
            return false;
        }
        double offsetValue = offset.m_unit.getMetersPerUnit() * offset.m_value;
        return Math.abs(offsetValue - (thisValue = this.m_unit.getMetersPerUnit() * this.m_value)) <= tolerance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Offset offset = (Offset)o;
        if (Double.compare(offset.m_value, this.m_value) != 0) {
            return false;
        }
        return this.m_unit == offset.m_unit;
    }

    public int hashCode() {
        int result = 17;
        result = 29 * result + this.m_unit.hashCode();
        long temp = this.m_value != 0.0 ? Double.doubleToLongBits(this.m_value) : 0L;
        result = 29 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public static Offset convert(Offset offset, LinearUnit unit) {
        ArgumentValidator.assertNotNullReference((String)"offset", (Object)offset);
        ArgumentValidator.assertNotNullReference((String)"unit", (Object)((Object)unit));
        if (unit == offset.getUnit()) {
            return offset;
        }
        return new Offset(offset.getValue(unit), unit);
    }
}

