/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.unit;

import com.mapinfo.midev.unit.PaperUnit;
import com.mapinfo.midev.util.ArgumentValidator;
import com.mapinfo.midev.util.PublicAPI;
import java.io.Serializable;

@PublicAPI
public final class PaperLength
implements Serializable {
    private final PaperUnit m_unit;
    private double m_value;

    public PaperLength(double value, PaperUnit unit) {
        ArgumentValidator.assertNotNullReference((String)"unit", (Object)unit);
        this.m_unit = unit;
        this.m_value = value;
    }

    public PaperUnit getUnit() {
        return this.m_unit;
    }

    public double getValue() {
        return this.m_value;
    }

    public double getValue(PaperUnit unit, Integer dotsPerInch) {
        ArgumentValidator.assertNotNullReference((String)"unit", (Object)unit);
        return PaperUnit.convert(this.m_value, this.m_unit, unit, dotsPerInch);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaperLength that = (PaperLength)o;
        if (Double.compare(that.m_value, this.m_value) != 0) {
            return false;
        }
        return !(this.m_unit != null ? !this.m_unit.equals(that.m_unit) : that.m_unit != null);
    }

    public int hashCode() {
        int result = this.m_unit != null ? this.m_unit.hashCode() : 0;
        long temp = this.m_value != 0.0 ? Double.doubleToLongBits(this.m_value) : 0L;
        result = 29 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "PaperLength: " + this.m_value + ' ' + this.m_unit;
    }
}

