/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.unit;

import com.mapinfo.midev.util.ArgumentValidator;
import com.mapinfo.midev.util.PrivateAPI;
import com.mapinfo.midev.util.PublicAPI;
import java.io.Serializable;

@PublicAPI
public enum PaperUnit implements Serializable
{
    INCH(72.0, "in"),
    POINT(1.0, "pt"),
    PICA(12.0, "pica"),
    TWIP(0.05, "twip"),
    MILLIMETER(2.834645669291339, "mm"),
    CENTIMETER(28.346456692913385, "cm"),
    PIXEL(0.75, "pixel"),
    METER(2834.6456692913384, "m");

    private final double m_pointsPerUnit;
    private final String m_mapInfoCode;
    public static final int DEFAULT_DPI = 96;

    private PaperUnit(double pointsPerUnit, String mapInfoCode) {
        this.m_pointsPerUnit = pointsPerUnit;
        this.m_mapInfoCode = mapInfoCode;
    }

    public double getPointsPerUnit() {
        return this.m_pointsPerUnit;
    }

    public static double convert(double length, PaperUnit fromUnit, PaperUnit toUnit, Integer dotsPerInch) {
        ArgumentValidator.assertNotNullReference((String)"fromUnit", (Object)fromUnit);
        ArgumentValidator.assertNotNullReference((String)"toUnit", (Object)toUnit);
        if (fromUnit == toUnit) {
            return length;
        }
        if (PIXEL == fromUnit) {
            ArgumentValidator.assertNotNullReference((String)"dotsPerInch", (Object)dotsPerInch);
            length = PaperUnit.convert(length / dotsPerInch.doubleValue(), INCH, toUnit, null);
        } else if (PIXEL == toUnit) {
            ArgumentValidator.assertNotNullReference((String)"dotsPerInch", (Object)dotsPerInch);
            length = PaperUnit.convert(length, fromUnit, INCH, null) * (double)dotsPerInch.intValue();
        } else {
            length *= PaperUnit.calculateConversionFactor(fromUnit, toUnit, null);
        }
        return length;
    }

    public static double calculateConversionFactor(PaperUnit fromUnit, PaperUnit toUnit, Integer dotsPerInch) {
        ArgumentValidator.assertNotNullReference((String)"fromUnit", (Object)fromUnit);
        ArgumentValidator.assertNotNullReference((String)"toUnit", (Object)toUnit);
        if (fromUnit == toUnit) {
            return 1.0;
        }
        if (PIXEL == fromUnit || PIXEL == toUnit) {
            return PaperUnit.convert(1.0, fromUnit, toUnit, dotsPerInch);
        }
        return fromUnit.m_pointsPerUnit / toUnit.m_pointsPerUnit;
    }

    @PrivateAPI
    public static PaperUnit getFromMapInfoCode(String code) {
        ArgumentValidator.assertNotNullReference((String)"code", (Object)code);
        String trimmedCode = PaperUnit.trim(code);
        for (PaperUnit paperUnit : PaperUnit.values()) {
            if (!trimmedCode.equals(paperUnit.m_mapInfoCode)) continue;
            return paperUnit;
        }
        return null;
    }

    private static String trim(String inputString) {
        return inputString.trim().replaceAll("\\s+", " ").toLowerCase();
    }
}

