/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.unit;

import com.mapinfo.midev.util.ArgumentValidator;
import com.mapinfo.midev.util.PrivateAPI;
import com.mapinfo.midev.util.PublicAPI;

@PublicAPI
public enum TimeUnit {
    MILLISECOND(0.001, "msec", "millisecond"),
    SECOND(1.0, "sec", "second"),
    MINUTE(60.0, "min", "minute"),
    HOUR(3600.0, "hr", "hour"),
    DAY(86400.0, "day", "day"),
    WEEK(604800.0, "week", "week");

    private final double m_secondsPerUnit;
    private final String m_mapInfoCode;
    private final String m_displayName;

    private TimeUnit(double secondsPerUnit, String mapInfoCode, String displayName) {
        this.m_secondsPerUnit = secondsPerUnit;
        this.m_mapInfoCode = mapInfoCode;
        this.m_displayName = displayName;
    }

    public double getSecondsPerUnit() {
        return this.m_secondsPerUnit;
    }

    @PrivateAPI
    public String getMapInfoCode() {
        return this.m_mapInfoCode;
    }

    @PrivateAPI
    public String getDisplayName() {
        return this.m_displayName;
    }

    public static double convert(double time, TimeUnit fromUnit, TimeUnit toUnit) {
        ArgumentValidator.assertNotNullReference((String)"fromUnit", (Object)((Object)fromUnit));
        ArgumentValidator.assertNotNullReference((String)"toUnit", (Object)((Object)toUnit));
        double result = time;
        if (fromUnit != toUnit) {
            result = time * (fromUnit.m_secondsPerUnit / toUnit.m_secondsPerUnit);
        }
        return result;
    }

    @PrivateAPI
    public static TimeUnit getFromMapInfoCode(String code) {
        ArgumentValidator.assertNotNullReference((String)"code", (Object)code);
        String trimmedCode = TimeUnit.trim(code);
        for (TimeUnit timeUnit : TimeUnit.values()) {
            if (!trimmedCode.equals(timeUnit.m_mapInfoCode)) continue;
            return timeUnit;
        }
        return null;
    }

    @PrivateAPI
    public static TimeUnit getFromDisplayName(String code) {
        ArgumentValidator.assertNotNullReference((String)"code", (Object)code);
        String trimmedCode = TimeUnit.trim(code);
        for (TimeUnit timeUnit : TimeUnit.values()) {
            if (!trimmedCode.equals(timeUnit.m_displayName)) continue;
            return timeUnit;
        }
        return null;
    }

    private static String trim(String inputString) {
        return inputString.trim().replaceAll("\\s+", " ").toLowerCase();
    }
}

