/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.util;

import com.mapinfo.util.DoubleRect;
import com.mapinfo.util.IntPoint;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

public class DoublePoint
implements Cloneable,
Serializable {
    public double x;
    public double y;
    private static final String m_xmlName = "double_point";

    public DoublePoint() {
    }

    public DoublePoint(double d, double d2) {
        this.set(d, d2);
    }

    public DoublePoint(DoublePoint doublePoint) {
        if (doublePoint != null) {
            this.set(doublePoint.x, doublePoint.y);
        }
    }

    public DoublePoint(IntPoint intPoint) {
        if (intPoint != null) {
            this.set(intPoint.x, (double)intPoint.y);
        }
    }

    public DoublePoint(double[] dArray) {
        this.set(dArray);
    }

    public DoublePoint(double[] dArray, int n) {
        this.set(dArray, n);
    }

    public DoublePoint(DataInput dataInput) throws IOException {
        this.read(dataInput);
    }

    public void set(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public void set(DoublePoint doublePoint) {
        if (doublePoint != null) {
            this.set(doublePoint.x, doublePoint.y);
        }
    }

    public void set(IntPoint intPoint) {
        if (intPoint != null) {
            this.set(intPoint.x, (double)intPoint.y);
        }
    }

    public void set(double[] dArray) {
        this.set(dArray, 0);
    }

    public void set(double[] dArray, int n) {
        this.set(dArray[n], dArray[n + 1]);
    }

    public void get(double[] dArray) {
        this.get(dArray, 0);
    }

    public void get(double[] dArray, int n) {
        dArray[n] = this.x;
        dArray[n + 1] = this.y;
    }

    public void read(DataInput dataInput) throws IOException {
        this.set(dataInput.readDouble(), dataInput.readDouble());
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeDouble(this.x);
        dataOutput.writeDouble(this.y);
    }

    public void offset(double d, double d2) {
        this.x += d;
        this.y += d2;
    }

    public boolean equals(DoublePoint doublePoint) {
        return this.x == doublePoint.x && this.y == doublePoint.y;
    }

    public boolean equals(Object object) {
        return object instanceof DoublePoint && this.equals((DoublePoint)object);
    }

    public int hashCode() {
        return (int)(Double.doubleToLongBits(this.x + this.y) >> 20);
    }

    public boolean intersects(DoubleRect doubleRect) {
        return doubleRect.intersects(this);
    }

    public boolean within(DoubleRect doubleRect) {
        return doubleRect.contains(this, true);
    }

    public boolean within(DoubleRect doubleRect, boolean bl) {
        return doubleRect.contains(this, bl);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public String toSpatialString() {
        return "ST_POINT" + this.toString();
    }

    static {
        m_xmlName = m_xmlName;
    }
}

