/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.util;

import com.mapinfo.util.DoublePoint;
import com.mapinfo.util.IntPoint;
import com.mapinfo.util.IntRect;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

public class DoubleRect
implements Cloneable,
Serializable {
    public double xmin;
    public double ymin;
    public double xmax;
    public double ymax;
    private static final String m_xmlName = "double_rect";

    public DoubleRect() {
    }

    public DoubleRect(double d, double d2, double d3, double d4) {
        this.set(d, d2, d3, d4);
    }

    public DoubleRect(DoublePoint doublePoint, DoublePoint doublePoint2) {
        this.set(doublePoint.x, doublePoint.y, doublePoint2.x, doublePoint2.y);
    }

    public DoubleRect(DoublePoint doublePoint, double d, double d2) {
        this.set(doublePoint, d, d2);
    }

    public DoubleRect(IntPoint intPoint, IntPoint intPoint2) {
        this.set(intPoint.x, intPoint.y, intPoint2.x, intPoint2.y);
    }

    public DoubleRect(DoublePoint[] doublePointArray, int n) {
        this.set(doublePointArray, n);
    }

    public DoubleRect(DoublePoint[] doublePointArray, int n, int n2) {
        this.set(doublePointArray, n, n2);
    }

    public DoubleRect(double[] dArray, int n) {
        this.set(dArray, n);
    }

    public DoubleRect(double[] dArray, int n, int n2) {
        this.set(dArray, n, n2);
    }

    public DoubleRect(DoubleRect doubleRect) {
        this.set(doubleRect);
    }

    public DoubleRect(IntRect intRect) {
        this.set(intRect);
    }

    public DoubleRect(DataInput dataInput) throws IOException {
        this.read(dataInput);
    }

    public void set(double d, double d2, double d3, double d4) {
        this.xmin = Math.min(d, d3);
        this.xmax = Math.max(d, d3);
        this.ymin = Math.min(d2, d4);
        this.ymax = Math.max(d2, d4);
    }

    public void set(DoublePoint doublePoint, DoublePoint doublePoint2) {
        this.set(doublePoint.x, doublePoint.y, doublePoint2.x, doublePoint2.y);
    }

    public void set(IntPoint intPoint, IntPoint intPoint2) {
        this.set(intPoint.x, intPoint.y, intPoint2.x, intPoint2.y);
    }

    public void set(DoublePoint doublePoint, double d, double d2) {
        this.set(doublePoint.x - d / 2.0, doublePoint.y - d2 / 2.0, doublePoint.x + d / 2.0, doublePoint.y + d2 / 2.0);
    }

    public void set(DoublePoint[] doublePointArray, int n) {
        this.set(doublePointArray, 0, n);
    }

    public void set(DoublePoint[] doublePointArray, int n, int n2) {
        this.initBounds();
        while (n2-- > 0) {
            this.merge(doublePointArray[n++]);
        }
    }

    public void set(double[] dArray, int n) {
        this.set(dArray, 0, n);
    }

    public void set(double[] dArray, int n, int n2) {
        this.initBounds();
        while (n2-- > 0) {
            double d = dArray[n++];
            double d2 = dArray[n++];
            this.merge(d, d2);
        }
    }

    public void set(DoubleRect doubleRect) {
        this.xmin = doubleRect.xmin;
        this.ymin = doubleRect.ymin;
        this.xmax = doubleRect.xmax;
        this.ymax = doubleRect.ymax;
    }

    public void set(IntRect intRect) {
        this.xmin = intRect.xmin;
        this.ymin = intRect.ymin;
        this.xmax = intRect.xmax;
        this.ymax = intRect.ymax;
    }

    public void get(DoublePoint[] doublePointArray, int n) {
        this.get(doublePointArray, 0, n);
    }

    public void get(DoublePoint[] doublePointArray, int n, int n2) {
        if (n2 <= 4) {
            doublePointArray[n++].set(this.xmin, this.ymin);
            doublePointArray[n++].set(this.xmax, this.ymax);
            if (n2 == 4) {
                doublePointArray[n++].set(this.xmin, this.ymax);
                doublePointArray[n++].set(this.xmax, this.ymin);
            }
        } else {
            int n3 = n2 / 4;
            DoubleRect.sampleLine(this.xmin, this.ymin, this.xmax, this.ymin, doublePointArray, n, n3);
            DoubleRect.sampleLine(this.xmax, this.ymin, this.xmax, this.ymax, doublePointArray, n + n3, n3);
            DoubleRect.sampleLine(this.xmax, this.ymax, this.xmin, this.ymax, doublePointArray, n + n3 * 2, n3);
            DoubleRect.sampleLine(this.xmin, this.ymax, this.xmin, this.ymin, doublePointArray, n + n3 * 3, n3);
        }
    }

    public void get(double[] dArray, int n) {
        this.get(dArray, 0, n);
    }

    public void get(double[] dArray, int n, int n2) {
        if (n2 <= 4) {
            dArray[n++] = this.xmin;
            dArray[n++] = this.ymin;
            dArray[n++] = this.xmax;
            dArray[n++] = this.ymax;
            if (n2 == 4) {
                dArray[n++] = this.xmin;
                dArray[n++] = this.ymax;
                dArray[n++] = this.xmax;
                dArray[n++] = this.ymin;
            }
        } else {
            int n3 = n2 / 4;
            DoubleRect.sampleLine(this.xmin, this.ymin, this.xmax, this.ymin, dArray, n, n3);
            DoubleRect.sampleLine(this.xmax, this.ymin, this.xmax, this.ymax, dArray, n + n3 * 2, n3);
            DoubleRect.sampleLine(this.xmax, this.ymax, this.xmin, this.ymax, dArray, n + n3 * 4, n3);
            DoubleRect.sampleLine(this.xmin, this.ymax, this.xmin, this.ymin, dArray, n + n3 * 6, n3);
        }
    }

    private static void sampleLine(double d, double d2, double d3, double d4, DoublePoint[] doublePointArray, int n, int n2) {
        double d5 = (d3 - d) / (double)n2;
        double d6 = (d4 - d2) / (double)n2;
        int n3 = 0;
        while (n3 < n2) {
            doublePointArray[n++].set(d + d5 * (double)n3, d2 + d6 * (double)n3);
            ++n3;
        }
    }

    private static void sampleLine(double d, double d2, double d3, double d4, double[] dArray, int n, int n2) {
        double d5 = (d3 - d) / (double)n2;
        double d6 = (d4 - d2) / (double)n2;
        int n3 = 0;
        while (n3 < n2) {
            dArray[n++] = d + d5 * (double)n3;
            dArray[n++] = d2 + d6 * (double)n3;
            ++n3;
        }
    }

    public void read(DataInput dataInput) throws IOException {
        this.set(dataInput.readDouble(), dataInput.readDouble(), dataInput.readDouble(), dataInput.readDouble());
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeDouble(this.xmin);
        dataOutput.writeDouble(this.ymin);
        dataOutput.writeDouble(this.xmax);
        dataOutput.writeDouble(this.ymax);
    }

    public void sort() {
        double d;
        if (this.xmin > this.xmax) {
            d = this.xmin;
            this.xmin = this.xmax;
            this.xmax = d;
        }
        if (this.ymin > this.ymax) {
            d = this.ymin;
            this.ymin = this.ymax;
            this.ymax = d;
        }
    }

    public void offset(double d, double d2) {
        this.xmin += d;
        this.ymin += d2;
        this.xmax += d;
        this.ymax += d2;
    }

    public void expand(double d, double d2) {
        this.xmin -= d / 2.0;
        this.ymin -= d2 / 2.0;
        this.xmax += d / 2.0;
        this.ymax += d2 / 2.0;
    }

    public boolean isEmpty() {
        return this.xmin >= this.xmax || this.ymin >= this.ymax;
    }

    public boolean equals(DoubleRect doubleRect) {
        return this.xmin == doubleRect.xmin && this.ymin == doubleRect.ymin && this.xmax == doubleRect.xmax && this.ymax == doubleRect.ymax;
    }

    public boolean equals(Object object) {
        return object instanceof DoubleRect && this.equals((DoubleRect)object);
    }

    public int hashCode() {
        return (int)(Double.doubleToLongBits(this.xmin + this.ymin + this.xmax + this.ymax) >> 20);
    }

    public double width() {
        return this.xmax - this.xmin;
    }

    public double height() {
        return this.ymax - this.ymin;
    }

    public double area() {
        return this.width() * this.height();
    }

    public DoublePoint center() {
        return new DoublePoint((this.xmin + this.xmax) / 2.0, (this.ymin + this.ymax) / 2.0);
    }

    public boolean intersects(DoubleRect doubleRect) {
        return this.xmin <= doubleRect.xmax && this.xmax >= doubleRect.xmin && this.ymin <= doubleRect.ymax && this.ymax >= doubleRect.ymin;
    }

    public boolean intersects(DoublePoint doublePoint) {
        return this.intersects(doublePoint.x, doublePoint.y);
    }

    public boolean intersects(double d, double d2) {
        return this.xmin <= d && this.xmax >= d && this.ymin <= d2 && this.ymax >= d2;
    }

    public boolean contains(DoubleRect doubleRect) {
        return this.contains(doubleRect, true);
    }

    public boolean contains(DoubleRect doubleRect, boolean bl) {
        if (bl) {
            return this.xmin <= doubleRect.xmin && this.xmax >= doubleRect.xmax && this.ymin <= doubleRect.ymin && this.ymax >= doubleRect.ymax;
        }
        return this.xmin < doubleRect.xmin && this.xmax > doubleRect.xmax && this.ymin < doubleRect.ymin && this.ymax > doubleRect.ymax;
    }

    public boolean contains(DoublePoint doublePoint) {
        return this.contains(doublePoint.x, doublePoint.y, true);
    }

    public boolean contains(DoublePoint doublePoint, boolean bl) {
        return this.contains(doublePoint.x, doublePoint.y, bl);
    }

    public boolean contains(double d, double d2) {
        return this.contains(d, d2, true);
    }

    public boolean contains(double d, double d2, boolean bl) {
        if (bl) {
            return this.xmin <= d && this.xmax >= d && this.ymin <= d2 && this.ymax >= d2;
        }
        return this.xmin < d && this.xmax > d && this.ymin < d2 && this.ymax > d2;
    }

    public boolean within(DoubleRect doubleRect) {
        return doubleRect.contains(this, true);
    }

    public boolean within(DoubleRect doubleRect, boolean bl) {
        return doubleRect.contains(this, bl);
    }

    public void merge(DoublePoint doublePoint) {
        this.merge(doublePoint.x, doublePoint.y);
    }

    public void merge(double d, double d2) {
        this.xmin = Math.min(this.xmin, d);
        this.ymin = Math.min(this.ymin, d2);
        this.xmax = Math.max(this.xmax, d);
        this.ymax = Math.max(this.ymax, d2);
    }

    public void merge(DoubleRect doubleRect) {
        this.xmin = Math.min(this.xmin, doubleRect.xmin);
        this.ymin = Math.min(this.ymin, doubleRect.ymin);
        this.xmax = Math.max(this.xmax, doubleRect.xmax);
        this.ymax = Math.max(this.ymax, doubleRect.ymax);
    }

    public void initBounds() {
        this.ymin = Double.MAX_VALUE;
        this.xmin = Double.MAX_VALUE;
        this.ymax = -1.7976931348623157E308;
        this.xmax = -1.7976931348623157E308;
    }

    public DoubleRect intersection(DoubleRect doubleRect) {
        DoubleRect doubleRect2 = new DoubleRect();
        doubleRect2.xmin = Math.max(this.xmin, doubleRect.xmin);
        doubleRect2.ymin = Math.max(this.ymin, doubleRect.ymin);
        doubleRect2.xmax = Math.min(this.xmax, doubleRect.xmax);
        doubleRect2.ymax = Math.min(this.ymax, doubleRect.ymax);
        return doubleRect2;
    }

    public DoubleRect union(DoubleRect doubleRect) {
        DoubleRect doubleRect2 = new DoubleRect();
        doubleRect2.xmin = Math.min(this.xmin, doubleRect.xmin);
        doubleRect2.ymin = Math.min(this.ymin, doubleRect.ymin);
        doubleRect2.xmax = Math.max(this.xmax, doubleRect.xmax);
        doubleRect2.ymax = Math.max(this.ymax, doubleRect.ymax);
        return doubleRect2;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        return "(" + this.xmin + ", " + this.ymin + ", " + this.xmax + ", " + this.ymax + ")";
    }

    public String toSpatialString() {
        return "ST_POINT(" + this.xmin + ", " + this.ymin + "),ST_POINT(" + this.xmax + ", " + this.ymax + ")";
    }

    static {
        m_xmlName = m_xmlName;
    }
}

