/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.util;

import com.mapinfo.util.DoublePoint;
import com.mapinfo.util.DoubleRect;
import com.mapinfo.util.IntPoint;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class IntRect
implements Cloneable {
    public int xmin;
    public int ymin;
    public int xmax;
    public int ymax;

    public IntRect() {
    }

    public IntRect(int n, int n2, int n3, int n4) {
        this.set(n, n2, n3, n4);
    }

    public IntRect(double d, double d2, double d3, double d4) {
        this.set(d, d2, d3, d4);
    }

    public IntRect(IntPoint intPoint, IntPoint intPoint2) {
        this.set(intPoint.x, intPoint.y, intPoint2.x, intPoint2.y);
    }

    public IntRect(DoublePoint doublePoint, DoublePoint doublePoint2) {
        this.set(doublePoint.x, doublePoint.y, doublePoint2.x, doublePoint2.y);
    }

    public IntRect(IntRect intRect) {
        this.set(intRect);
    }

    public IntRect(DoubleRect doubleRect) {
        this.set(doubleRect);
    }

    public IntRect(DataInput dataInput) throws IOException {
        this.read(dataInput);
    }

    public IntRect(DataInput dataInput, IntPoint intPoint) throws IOException {
        this.read(dataInput, intPoint);
    }

    public void set(int n, int n2, int n3, int n4) {
        this.xmin = Math.min(n, n3);
        this.xmax = Math.max(n, n3);
        this.ymin = Math.min(n2, n4);
        this.ymax = Math.max(n2, n4);
    }

    public void set(double d, double d2, double d3, double d4) {
        this.set((int)d, (int)d2, (int)d3, (int)d4);
    }

    public void set(IntPoint intPoint, IntPoint intPoint2) {
        this.set(intPoint.x, intPoint.y, intPoint2.x, intPoint2.y);
    }

    public void set(DoublePoint doublePoint, DoublePoint doublePoint2) {
        this.set(doublePoint.x, doublePoint.y, doublePoint2.x, doublePoint2.y);
    }

    public void set(IntRect intRect) {
        this.xmin = intRect.xmin;
        this.ymin = intRect.ymin;
        this.xmax = intRect.xmax;
        this.ymax = intRect.ymax;
    }

    public void set(DoubleRect doubleRect) {
        this.xmin = (int)doubleRect.xmin;
        this.ymin = (int)doubleRect.ymin;
        this.xmax = (int)doubleRect.xmax;
        this.ymax = (int)doubleRect.ymax;
    }

    public void read(DataInput dataInput) throws IOException {
        this.set(dataInput.readInt(), dataInput.readInt(), dataInput.readInt(), dataInput.readInt());
    }

    public void read(DataInput dataInput, IntPoint intPoint) throws IOException {
        this.read(dataInput, intPoint.x, intPoint.y);
    }

    public void read(DataInput dataInput, int n, int n2) throws IOException {
        this.set(dataInput.readShort() + n, dataInput.readShort() + n2, dataInput.readShort() + n, dataInput.readShort() + n2);
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.xmin);
        dataOutput.writeInt(this.ymin);
        dataOutput.writeInt(this.xmax);
        dataOutput.writeInt(this.ymax);
    }

    public void write(DataOutput dataOutput, IntPoint intPoint) throws IOException {
        dataOutput.writeShort(this.xmin - intPoint.x);
        dataOutput.writeShort(this.ymin - intPoint.y);
        dataOutput.writeShort(this.xmax - intPoint.x);
        dataOutput.writeShort(this.ymax - intPoint.y);
    }

    public void sort() {
        int n;
        if (this.xmin > this.xmax) {
            n = this.xmin;
            this.xmin = this.xmax;
            this.xmax = n;
        }
        if (this.ymin > this.ymax) {
            n = this.ymin;
            this.ymin = this.ymax;
            this.ymax = n;
        }
    }

    public void offset(int n, int n2) {
        this.xmin += n;
        this.ymin += n2;
        this.xmax += n;
        this.ymax += n2;
    }

    public void expand(int n, int n2) {
        this.xmin -= n / 2;
        this.ymin -= n2 / 2;
        this.xmax += n / 2;
        this.ymax += n2 / 2;
    }

    public boolean isEmpty() {
        return this.xmin >= this.xmax || this.ymin >= this.ymax;
    }

    public boolean equals(IntRect intRect) {
        return this.xmin == intRect.xmin && this.ymin == intRect.ymin && this.xmax == intRect.xmax && this.ymax == intRect.ymax;
    }

    public boolean equals(Object object) {
        return object instanceof IntRect && this.equals((IntRect)object);
    }

    public int hashCode() {
        return this.xmin + this.ymin + this.xmax + this.ymax;
    }

    public int width() {
        return this.xmax - this.xmin;
    }

    public int height() {
        return this.ymax - this.ymin;
    }

    public long area() {
        int n = this.width();
        int n2 = this.height();
        return (long)n * (long)n2;
    }

    public IntPoint center() {
        return new IntPoint((this.xmin + this.xmax) / 2, (this.ymin + this.ymax) / 2);
    }

    public boolean intersects(IntRect intRect) {
        return this.xmin <= intRect.xmax && this.xmax >= intRect.xmin && this.ymin <= intRect.ymax && this.ymax >= intRect.ymin;
    }

    public boolean intersects(IntPoint intPoint) {
        return this.xmin <= intPoint.x && this.xmax >= intPoint.x && this.ymin <= intPoint.y && this.ymax >= intPoint.y;
    }

    public boolean contains(IntRect intRect) {
        return this.xmin <= intRect.xmin && this.xmax >= intRect.xmax && this.ymin <= intRect.ymin && this.ymax >= intRect.ymax;
    }

    public boolean contains(IntPoint intPoint) {
        return this.intersects(intPoint);
    }

    public boolean within(IntRect intRect) {
        return intRect.contains(this);
    }

    public void merge(IntPoint intPoint) {
        this.xmin = Math.min(this.xmin, intPoint.x);
        this.ymin = Math.min(this.ymin, intPoint.y);
        this.xmax = Math.max(this.xmax, intPoint.x);
        this.ymax = Math.max(this.ymax, intPoint.y);
    }

    public void merge(IntRect intRect) {
        this.xmin = Math.min(this.xmin, intRect.xmin);
        this.ymin = Math.min(this.ymin, intRect.ymin);
        this.xmax = Math.max(this.xmax, intRect.xmax);
        this.ymax = Math.max(this.ymax, intRect.ymax);
    }

    public void initBounds() {
        this.ymin = Integer.MAX_VALUE;
        this.xmin = Integer.MAX_VALUE;
        this.ymax = -2147483647;
        this.xmax = -2147483647;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        return "(" + this.xmin + ", " + this.ymin + ", " + this.xmax + ", " + this.ymax + ")";
    }
}

