/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.util;

import com.mapinfo.xmlprot.XMLUtils;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public final class Logger {
    private static final String a = "Logger";
    private static final String b = "File";
    private static final String c = "System.out";
    private static final String d = "System.err";
    private static final String e = "level";
    private static final String f = "com.mapinfo.logger.inputfile";
    private static final int g = 1;
    private static final int h = 2;
    private static final int i = 3;
    private static final int j = 4;
    private static final int k = 5;
    public static final Level LOG_LEVEL_FATAL;
    public static final Level LOG_LEVEL_ERROR;
    public static final Level LOG_LEVEL_WARN;
    public static final Level LOG_LEVEL_INFO;
    public static final Level LOG_LEVEL_DEBUG;
    public static final Level DEFAULT_LOG_LEVEL;
    private static final String l = "FATAL: ";
    private static final String m = "ERROR: ";
    private static final String n = "WARNING: ";
    private static final String o = "INFO: ";
    private static final String p = "DEBUG: ";
    private static ServletContext q;
    private static Level r;
    private static ArrayList s;
    private static ArrayList t;
    private static boolean u;

    private Logger() {
    }

    public static void createLogger(ServletContext servletContext, int n) {
        Logger.createLogger(servletContext, new Level(n));
    }

    public static void createLogger(ServletContext servletContext, Level level) {
        if (q == null) {
            q = servletContext;
            r = level;
            u = true;
        } else if (level.getLevel() > r.getLevel()) {
            r = level;
        }
    }

    public static void initializeLoggers(InputStream inputStream) throws IOException, JDOMException {
        if (inputStream != null) {
            SAXBuilder sAXBuilder = XMLUtils.createSAXBuilder(false);
            Document document = sAXBuilder.build(inputStream);
            Logger.a(document.getRootElement());
        }
    }

    private static void a(Element element) throws IOException {
        List list = element.getChildren(a);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            int n = Integer.parseInt(element2.getAttributeValue(e));
            Level level = new Level(n);
            if (element2.getChild(c) != null) {
                Logger.createLogger(System.out, level);
            }
            if (element2.getChild(d) != null) {
                Logger.createLogger(System.err, level);
            }
            List list2 = element2.getChildren(b);
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                Element element3 = (Element)iterator2.next();
                String string = element3.getText();
                Logger.createLogger(new FileOutputStream(string), level);
            }
        }
    }

    public static synchronized void createLogger(Writer writer, Level level) {
        t.add(level);
        s.add(new PrintWriter(writer));
        u = true;
    }

    public static synchronized void createLogger(OutputStream outputStream, Level level) {
        t.add(level);
        s.add(new PrintWriter(outputStream));
        u = true;
    }

    private static boolean a(Level level, Level level2) {
        return level.a(level2) >= 0;
    }

    public static boolean isAtLeastLevel(Level level) {
        boolean bl = false;
        if (q != null) {
            bl = Logger.a(r, level);
        }
        int n = 0;
        while (!bl && n < t.size()) {
            bl = Logger.a((Level)t.get(n), level);
            ++n;
        }
        return bl;
    }

    private static String a(Level level) {
        if (level != null) {
            switch (level.getLevel()) {
                case 1: {
                    return l;
                }
                case 2: {
                    return m;
                }
                case 3: {
                    return n;
                }
                case 4: {
                    return o;
                }
                case 5: {
                    return p;
                }
            }
            return "";
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(String string, Throwable throwable, Level level) {
        String string2 = Logger.a(level);
        if (u) {
            if (q != null && Logger.a(r, level)) {
                if (throwable != null) {
                    q.log(string2 + string, throwable);
                } else {
                    q.log(string2 + string);
                }
            }
            int n = 0;
            while (n < t.size()) {
                if (Logger.a((Level)t.get(n), level)) {
                    PrintWriter printWriter;
                    PrintWriter printWriter2 = printWriter = (PrintWriter)s.get(n);
                    synchronized (printWriter2) {
                        printWriter.println(string2 + string);
                        if (throwable != null) {
                            throwable.printStackTrace(printWriter);
                        }
                        printWriter.flush();
                    }
                }
                ++n;
            }
        } else if (Logger.a(LOG_LEVEL_ERROR, level)) {
            System.out.println(string2 + string);
            if (throwable != null) {
                throwable.printStackTrace();
            }
        }
    }

    public static void log(String string, Level level) {
        Logger.log(string, null, level);
    }

    public static void log(Throwable throwable, Level level) {
        Logger.log(throwable.getMessage(), throwable, level);
    }

    public static void log(String string, Throwable throwable) {
        Logger.log(string, throwable, new Level(0));
    }

    public static void log(String string) {
        Logger.log(string, new Level(0));
    }

    public static void log(Throwable throwable) {
        Logger.log(throwable.getMessage(), throwable);
    }

    static {
        a = a;
        b = b;
        c = c;
        d = d;
        e = e;
        f = f;
        g = 1;
        h = 2;
        i = 3;
        j = 4;
        k = 5;
        LOG_LEVEL_FATAL = new Level(1);
        LOG_LEVEL_ERROR = new Level(2);
        LOG_LEVEL_WARN = new Level(3);
        LOG_LEVEL_INFO = new Level(4);
        LOG_LEVEL_DEBUG = new Level(5);
        DEFAULT_LOG_LEVEL = LOG_LEVEL_ERROR;
        l = l;
        m = m;
        n = n;
        o = o;
        p = p;
        q = null;
        r = DEFAULT_LOG_LEVEL;
        s = null;
        t = null;
        u = false;
        s = new ArrayList();
        t = new ArrayList();
        try {
            String string = System.getProperty(f);
            if (string != null) {
                Logger.initializeLoggers(new FileInputStream(string));
                Logger.log("Created from input file " + string, LOG_LEVEL_INFO);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class Level {
        private int a;

        private Level(int n) {
            this.a = n;
        }

        public int getLevel() {
            return this.a;
        }

        private int a(Level level) {
            int n = level.getLevel();
            return this.a == n ? 0 : (this.a < n ? -1 : 1);
        }
    }
}

