/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.util.cache;

import com.mapinfo.util.cache.Cache;
import com.mapinfo.util.cache.CacheLog;
import com.mapinfo.util.cache.CachedObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CacheImpl
implements Cache {
    protected Map a = Collections.synchronizedMap(new HashMap(27));
    private long b = 0L;
    private int c = 0;

    public void addObject(Object object, CachedObject cachedObject) {
        this.a.put(object, cachedObject);
        CacheLog.getLog().debug((Object)(object + " added to cache."));
    }

    public void removeObject(Object object) {
        CachedObject cachedObject = (CachedObject)this.a.get(object);
        if (cachedObject != null) {
            this.a.remove(object);
            cachedObject.destroy();
        }
        CacheLog.getLog().debug((Object)(object + " removed from cache."));
    }

    public CachedObject getObject(Object object) {
        return (CachedObject)this.a.get(object);
    }

    public int getCacheSize() {
        return this.a.size();
    }

    public long getAverageLife() {
        return this.b / (long)(this.c > 0 ? this.c : 1);
    }

    public Iterator getKeys() {
        return this.a.keySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        CachedObject cachedObject;
        ArrayList<CachedObject> arrayList = new ArrayList<CachedObject>(13);
        CacheImpl cacheImpl = this;
        synchronized (cacheImpl) {
            Iterator iterator = this.a.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                cachedObject = (CachedObject)this.a.get(k);
                if (!cachedObject.isStale()) continue;
                iterator.remove();
                arrayList.add(cachedObject);
            }
        }
        int n = 0;
        while (n < arrayList.size()) {
            cachedObject = (CachedObject)arrayList.get(n);
            long l = cachedObject.lastTouch() > cachedObject.getCreated() ? cachedObject.lastTouch() : System.currentTimeMillis();
            this.b += l - cachedObject.getCreated();
            cachedObject.destroy();
            ++this.c;
            ++n;
        }
        arrayList = null;
    }
}

