/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.util.io;

import com.mapinfo.util.io.MIByteBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.InvalidMarkException;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class SlicedByteBuffer
extends MIByteBuffer {
    private final MIByteBuffer a;
    private int b = Integer.MAX_VALUE;
    private int c = 0;
    private int d = 0;
    private int e = -1;
    private ByteOrder f = ByteOrder.nativeOrder();

    public SlicedByteBuffer(MIByteBuffer mIByteBuffer) {
        this(mIByteBuffer, mIByteBuffer.position());
    }

    public SlicedByteBuffer(MIByteBuffer mIByteBuffer, int n) {
        super(mIByteBuffer.a(), mIByteBuffer.getMode());
        this.a = mIByteBuffer;
        this.d = n;
        this.f = mIByteBuffer.order();
    }

    public void dispose() throws IOException {
    }

    public boolean isMapped() {
        return this.a.isMapped();
    }

    public void force() {
        this.a.force();
    }

    public int capacity() {
        return this.a.capacity() - this.d;
    }

    public MIByteBuffer clear() {
        this.c = 0;
        this.b = Integer.MAX_VALUE;
        return this;
    }

    public MIByteBuffer flip() {
        this.b = this.c;
        this.c = 0;
        return this;
    }

    public boolean hasRemaining() {
        return this.limit() - this.position() > 0;
    }

    public int limit() {
        return Math.min(this.a.limit() - this.d, this.b);
    }

    public MIByteBuffer limit(int n) {
        this.b = n;
        return this;
    }

    public MIByteBuffer mark() {
        this.e = this.position();
        return this;
    }

    public int position() {
        return this.c;
    }

    public MIByteBuffer position(int n) {
        this.c = n;
        return this;
    }

    public int remaining() {
        return this.limit() - this.position();
    }

    public MIByteBuffer reset() {
        if (this.e < 0) {
            throw new InvalidMarkException();
        }
        this.c = this.e;
        return this;
    }

    public MIByteBuffer rewind() {
        this.c = 0;
        return this;
    }

    public ByteOrder order() {
        return this.f;
    }

    public void order(ByteOrder byteOrder) {
        this.f = byteOrder;
    }

    public MIByteBuffer compact() {
        this.a.compact();
        return this;
    }

    public int compareTo(Object object) {
        return this.a.compareTo(object);
    }

    public MIByteBuffer duplicate() throws IOException {
        return new SlicedByteBuffer(this, 0);
    }

    public MIByteBuffer slice() {
        return new SlicedByteBuffer(this);
    }

    public byte get() {
        byte by = this.get(this.c);
        ++this.c;
        return by;
    }

    public MIByteBuffer get(byte[] byArray) {
        return this.get(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MIByteBuffer get(byte[] byArray, int n, int n2) {
        MIByteBuffer mIByteBuffer = this.a;
        synchronized (mIByteBuffer) {
            int n3 = this.a.position();
            try {
                this.a.position(this.c + this.d);
                if (!this.f.equals(this.a.order())) {
                    ByteOrder byteOrder = this.a.order();
                    try {
                        this.a.order(this.f);
                        this.a.get(byArray, n, n2);
                        Object var8_7 = null;
                        this.a.order(byteOrder);
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        this.a.order(byteOrder);
                        throw throwable;
                    }
                } else {
                    this.a.get(byArray, n, n2);
                }
                this.c += n2 - n;
                Object var10_10 = null;
                this.a.position(n3);
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                this.a.position(n3);
                throw throwable;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte get(int n) {
        byte by;
        if (!this.f.equals(this.a.order())) {
            MIByteBuffer mIByteBuffer = this.a;
            synchronized (mIByteBuffer) {
                ByteOrder byteOrder = this.a.order();
                try {
                    this.a.order(this.f);
                    by = this.a.get(n + this.d);
                    Object var6_5 = null;
                    this.a.order(byteOrder);
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.a.order(byteOrder);
                    throw throwable;
                }
            }
        }
        by = this.a.get(n + this.d);
        return by;
    }

    public char getChar() {
        char c = this.getChar(this.c);
        this.c += 2;
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char getChar(int n) {
        char c;
        if (!this.f.equals(this.a.order())) {
            MIByteBuffer mIByteBuffer = this.a;
            synchronized (mIByteBuffer) {
                ByteOrder byteOrder = this.a.order();
                try {
                    this.a.order(this.f);
                    c = this.a.getChar(n + this.d);
                    Object var6_5 = null;
                    this.a.order(byteOrder);
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.a.order(byteOrder);
                    throw throwable;
                }
            }
        }
        c = this.a.getChar(n + this.d);
        return c;
    }

    public double getDouble() {
        double d = this.getDouble(this.c);
        this.c += 8;
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int n) {
        double d;
        if (!this.f.equals(this.a.order())) {
            MIByteBuffer mIByteBuffer = this.a;
            synchronized (mIByteBuffer) {
                ByteOrder byteOrder = this.a.order();
                try {
                    this.a.order(this.f);
                    d = this.a.getDouble(n + this.d);
                    Object var7_5 = null;
                    this.a.order(byteOrder);
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    this.a.order(byteOrder);
                    throw throwable;
                }
            }
        }
        d = this.a.getDouble(n + this.d);
        return d;
    }

    public float getFloat() {
        float f = this.getFloat(this.c);
        this.c += 4;
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(int n) {
        float f;
        if (!this.f.equals(this.a.order())) {
            MIByteBuffer mIByteBuffer = this.a;
            synchronized (mIByteBuffer) {
                ByteOrder byteOrder = this.a.order();
                try {
                    this.a.order(byteOrder);
                    f = this.a.getFloat(n + this.d);
                    Object var6_5 = null;
                    this.a.order(byteOrder);
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.a.order(byteOrder);
                    throw throwable;
                }
            }
        }
        f = this.a.getFloat(n + this.d);
        return f;
    }

    public int getInt() {
        int n = this.getInt(this.c);
        this.c += 4;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(int n) {
        int n2;
        if (!this.f.equals(this.a.order())) {
            MIByteBuffer mIByteBuffer = this.a;
            synchronized (mIByteBuffer) {
                ByteOrder byteOrder = this.a.order();
                try {
                    this.a.order(this.f);
                    n2 = this.a.getInt(n + this.d);
                    Object var6_5 = null;
                    this.a.order(byteOrder);
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.a.order(byteOrder);
                    throw throwable;
                }
            }
        }
        n2 = this.a.getInt(n + this.d);
        return n2;
    }

    public long getLong() {
        long l = this.getLong(this.c);
        this.c += 8;
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int n) {
        long l;
        if (!this.f.equals(this.a.order())) {
            MIByteBuffer mIByteBuffer = this.a;
            synchronized (mIByteBuffer) {
                ByteOrder byteOrder = this.a.order();
                try {
                    this.a.order(this.f);
                    l = this.a.getLong(n + this.d);
                    Object var7_5 = null;
                    this.a.order(byteOrder);
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    this.a.order(byteOrder);
                    throw throwable;
                }
            }
        }
        l = this.a.getLong(n + this.d);
        return l;
    }

    public short getShort() {
        short s = this.getShort(this.c);
        this.c += 2;
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(int n) {
        short s;
        if (!this.f.equals(this.a.order())) {
            MIByteBuffer mIByteBuffer = this.a;
            synchronized (mIByteBuffer) {
                ByteOrder byteOrder = this.a.order();
                try {
                    this.a.order(this.f);
                    s = this.a.getShort(n + this.d);
                    Object var6_5 = null;
                    this.a.order(byteOrder);
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.a.order(byteOrder);
                    throw throwable;
                }
            }
        }
        s = this.a.getShort(n + this.d);
        return s;
    }

    public MIByteBuffer put(byte by) {
        this.put(this.c, by);
        ++this.c;
        return this;
    }

    public MIByteBuffer put(byte[] byArray) {
        this.put(byArray, 0, byArray.length);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MIByteBuffer put(byte[] byArray, int n, int n2) {
        MIByteBuffer mIByteBuffer = this.a;
        synchronized (mIByteBuffer) {
            int n3 = this.a.position();
            try {
                this.a.position(this.c + this.d);
                if (!this.f.equals(this.a.order())) {
                    ByteOrder byteOrder = this.a.order();
                    try {
                        this.a.order(this.f);
                        this.a.put(byArray, n, n2);
                        Object var8_7 = null;
                        this.a.order(byteOrder);
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        this.a.order(byteOrder);
                        throw throwable;
                    }
                } else {
                    this.a.put(byArray, n, n2);
                }
                this.c += n2 - n;
                Object var10_10 = null;
                this.a.position(n3);
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                this.a.position(n3);
                throw throwable;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MIByteBuffer put(ByteBuffer byteBuffer) {
        MIByteBuffer mIByteBuffer = this.a;
        synchronized (mIByteBuffer) {
            int n = this.a.position();
            try {
                this.a.position(this.c + this.d);
                this.c += byteBuffer.limit() - byteBuffer.position();
                if (!this.f.equals(this.a.order())) {
                    ByteOrder byteOrder = this.a.order();
                    try {
                        this.a.order(this.f);
                        this.a.put(byteBuffer);
                        Object var6_5 = null;
                        this.a.order(byteOrder);
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        this.a.order(byteOrder);
                        throw throwable;
                    }
                } else {
                    this.a.put(byteBuffer);
                }
                Object var8_8 = null;
                this.a.position(n);
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.a.position(n);
                throw throwable;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MIByteBuffer put(int n, byte by) {
        if (!this.f.equals(this.a.order())) {
            MIByteBuffer mIByteBuffer = this.a;
            synchronized (mIByteBuffer) {
                ByteOrder byteOrder = this.a.order();
                try {
                    this.a.order(this.f);
                    this.a.put(n + this.d, by);
                    Object var6_5 = null;
                    this.a.order(byteOrder);
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.a.order(byteOrder);
                    throw throwable;
                }
            }
        }
        this.a.put(n + this.d, by);
        return this;
    }

    public MIByteBuffer putChar(char c) {
        this.putChar(this.c, c);
        this.c += 2;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MIByteBuffer putChar(int n, char c) {
        if (!this.f.equals(this.a.order())) {
            MIByteBuffer mIByteBuffer = this.a;
            synchronized (mIByteBuffer) {
                ByteOrder byteOrder = this.a.order();
                try {
                    this.a.order(this.f);
                    this.a.putChar(n + this.d, c);
                    Object var6_5 = null;
                    this.a.order(byteOrder);
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.a.order(byteOrder);
                    throw throwable;
                }
            }
        }
        this.a.putChar(n + this.d, c);
        return this;
    }

    public MIByteBuffer putDouble(double d) {
        this.putDouble(this.c, d);
        this.c += 8;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MIByteBuffer putDouble(int n, double d) {
        if (!this.f.equals(this.a.order())) {
            MIByteBuffer mIByteBuffer = this.a;
            synchronized (mIByteBuffer) {
                ByteOrder byteOrder = this.a.order();
                try {
                    this.a.order(this.f);
                    this.a.putDouble(n + this.d, d);
                    Object var7_5 = null;
                    this.a.order(byteOrder);
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    this.a.order(byteOrder);
                    throw throwable;
                }
            }
        }
        this.a.putDouble(n + this.d, d);
        return this;
    }

    public MIByteBuffer putFloat(float f) {
        this.putFloat(this.c, f);
        this.c += 4;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MIByteBuffer putFloat(int n, float f) {
        if (!this.f.equals(this.a.order())) {
            MIByteBuffer mIByteBuffer = this.a;
            synchronized (mIByteBuffer) {
                ByteOrder byteOrder = this.a.order();
                try {
                    this.a.order(this.f);
                    this.a.putFloat(n + this.d, f);
                    Object var6_5 = null;
                    this.a.order(byteOrder);
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.a.order(byteOrder);
                    throw throwable;
                }
            }
        }
        this.a.putFloat(n + this.d, f);
        return this;
    }

    public MIByteBuffer putInt(int n) {
        this.putInt(this.c, n);
        this.c += 4;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MIByteBuffer putInt(int n, int n2) {
        if (!this.f.equals(this.a.order())) {
            MIByteBuffer mIByteBuffer = this.a;
            synchronized (mIByteBuffer) {
                ByteOrder byteOrder = this.a.order();
                try {
                    this.a.order(this.f);
                    this.a.putInt(n + this.d, n2);
                    Object var6_5 = null;
                    this.a.order(byteOrder);
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.a.order(byteOrder);
                    throw throwable;
                }
            }
        }
        this.a.putInt(n + this.d, n2);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MIByteBuffer putLong(int n, long l) {
        if (!this.f.equals(this.a.order())) {
            MIByteBuffer mIByteBuffer = this.a;
            synchronized (mIByteBuffer) {
                ByteOrder byteOrder = this.a.order();
                try {
                    this.a.order(this.f);
                    this.a.putLong(n + this.d, l);
                    Object var7_5 = null;
                    this.a.order(byteOrder);
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    this.a.order(byteOrder);
                    throw throwable;
                }
            }
        }
        this.a.putLong(n + this.d, l);
        return this;
    }

    public MIByteBuffer putLong(long l) {
        this.putLong(this.c, l);
        this.c += 8;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MIByteBuffer putShort(int n, short s) {
        if (!this.f.equals(this.a.order())) {
            MIByteBuffer mIByteBuffer = this.a;
            synchronized (mIByteBuffer) {
                ByteOrder byteOrder = this.a.order();
                try {
                    this.a.order(this.f);
                    this.a.putShort(n + this.d, s);
                    Object var6_5 = null;
                    this.a.order(byteOrder);
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.a.order(byteOrder);
                    throw throwable;
                }
            }
        }
        this.a.putShort(n + this.d, s);
        return this;
    }

    public MIByteBuffer putShort(short s) {
        this.putShort(this.c, s);
        this.c += 2;
        return this;
    }

    public CharBuffer asCharBuffer() {
        return this.a.asCharBuffer();
    }

    public DoubleBuffer asDoubleBuffer() {
        return this.a.asDoubleBuffer();
    }

    public FloatBuffer asFloatBuffer() {
        return this.a.asFloatBuffer();
    }

    public IntBuffer asIntBuffer() {
        return this.a.asIntBuffer();
    }

    public LongBuffer asLongBuffer() {
        return this.a.asLongBuffer();
    }

    public ByteBuffer asReadOnlyBuffer() {
        return this.a.asReadOnlyBuffer();
    }

    public ShortBuffer asShortBuffer() {
        return this.a.asShortBuffer();
    }
}

