/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.xml;

import com.mapinfo.xml.XMLAttList;
import com.mapinfo.xml.XMLFactory;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Document;

public class XMLWriter {
    public static final boolean DEFAULT_STANDALONE = true;
    public static final boolean DEFAULT_HUMAN_READABLE = false;
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static final String a;
    private Writer b;
    private boolean c;
    private boolean d;
    private String e;

    private XMLWriter() {
    }

    public XMLWriter(Writer writer) {
        this(writer, true, false, DEFAULT_ENCODING);
    }

    public XMLWriter(Writer writer, boolean bl) {
        this(writer, bl, true, DEFAULT_ENCODING);
    }

    public XMLWriter(Writer writer, boolean bl, boolean bl2, String string) {
        this.b = writer;
        this.c = bl;
        this.d = bl2;
        this.e = string;
    }

    public void close() throws IOException {
        if (this.b != null) {
            this.b.flush();
            this.b.close();
            this.b = null;
        }
    }

    public void writeHeader() throws IOException {
        this.b.write("<?xml version=\"1.0\" encoding=\"");
        this.b.write(this.e);
        this.b.write("\" standalone=\"");
        this.b.write(this.c ? "yes" : "no");
        this.b.write("\"?>");
    }

    public void writeDOCTYPE(String string, String string2) throws IOException {
        if (this.d) {
            this.b.write(a);
        }
        this.b.write("<!DOCTYPE ");
        this.b.write(string);
        this.b.write(" SYSTEM \"");
        this.b.write(string2);
        this.b.write("\">");
    }

    public void openElement(String string) throws IOException {
        if (this.d) {
            this.b.write(a);
        }
        this.b.write(60);
        this.b.write(string);
        this.b.write(62);
    }

    public void openElement(String string, XMLAttList xMLAttList) throws IOException {
        if (this.d) {
            this.b.write(a);
        }
        this.b.write(60);
        this.b.write(string);
        xMLAttList.a(this.b);
        this.b.write(62);
    }

    public void closeElement(String string) throws IOException {
        this.b.write("</");
        this.b.write(string);
        this.b.write(62);
    }

    public void emptyElement(String string) throws IOException {
        if (this.d) {
            this.b.write(a);
        }
        this.b.write(60);
        this.b.write(string);
        this.b.write("/>");
    }

    public void emptyElement(String string, XMLAttList xMLAttList) throws IOException {
        if (this.d) {
            this.b.write(a);
        }
        this.b.write(60);
        this.b.write(string);
        xMLAttList.a(this.b);
        this.b.write("/>");
    }

    public void element(String string, String string2) throws IOException {
        this.openElement(string);
        this.a(string2);
        this.closeElement(string);
    }

    public void element(String string, XMLAttList xMLAttList, String string2) throws IOException {
        this.openElement(string, xMLAttList);
        this.a(string2);
        this.closeElement(string);
    }

    public void fastElement(String string, String string2) throws IOException {
        this.openElement(string);
        this.b(string2);
        this.closeElement(string);
    }

    public void fastElement(String string, XMLAttList xMLAttList, String string2) throws IOException {
        this.openElement(string, xMLAttList);
        this.b(string2);
        this.closeElement(string);
    }

    public void element(String string, int n) throws IOException {
        this.fastElement(string, Integer.toString(n));
    }

    public void element(String string, double d) throws IOException {
        this.fastElement(string, Double.toString(d));
    }

    public void element(String string, boolean bl) throws IOException {
        this.fastElement(string, bl ? "true" : "false");
    }

    private void a(String string) throws IOException {
        if (string != null) {
            this.b.write(XMLWriter.processXMLReservedChar(string));
        }
    }

    private void b(String string) throws IOException {
        if (string != null) {
            this.b.write(string);
        }
    }

    public void freeText(Document document) throws IOException {
        String string = XMLFactory.getXMLDocumentAsString(document);
        this.b(string);
    }

    public boolean getStandalone() {
        return this.c;
    }

    public static final boolean containsReservedXMLChars(String string) {
        return string.indexOf(38) != -1 || string.indexOf(60) != -1 || string.indexOf(62) != -1 || string.indexOf(39) != -1 || string.indexOf("\"") != -1;
    }

    public static final String processXMLReservedChar(String string) {
        String string2;
        if (XMLWriter.containsReservedXMLChars(string)) {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = stringBuffer.length() - 1;
            while (n >= 0) {
                char c = stringBuffer.charAt(n);
                switch (c) {
                    case '&': {
                        stringBuffer.replace(n, n + 1, "&amp;");
                        break;
                    }
                    case '<': {
                        stringBuffer.replace(n, n + 1, "&lt;");
                        break;
                    }
                    case '>': {
                        stringBuffer.replace(n, n + 1, "&gt;");
                        break;
                    }
                    case '\'': {
                        stringBuffer.replace(n, n + 1, "&apos;");
                        break;
                    }
                    case '\"': {
                        stringBuffer.replace(n, n + 1, "&quot;");
                        break;
                    }
                }
                --n;
            }
            string2 = stringBuffer.toString();
        } else {
            string2 = string;
        }
        return string2;
    }

    static {
        DEFAULT_STANDALONE = true;
        DEFAULT_HUMAN_READABLE = false;
        DEFAULT_ENCODING = DEFAULT_ENCODING;
        a = System.getProperty("line.separator");
    }
}

