/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.xmlprot.transform;

import com.mapinfo.xmlprot.transform.MIXMLTransformException;
import com.mapinfo.xmlprot.transform.MIXMLTransformer;
import com.mapinfo.xmlprot.transform.MIXMLTransformerRule;
import java.util.Arrays;
import java.util.Comparator;
import org.jdom.Document;

public class MIXMLTransformerImpl
implements MIXMLTransformer {
    private final MIXMLTransformerRule[] a;

    public MIXMLTransformerImpl(MIXMLTransformerRule[] mIXMLTransformerRuleArray) {
        if (mIXMLTransformerRuleArray == null || mIXMLTransformerRuleArray.length == 0) {
            throw new IllegalArgumentException("INVALID RULE LIST (null or empty)");
        }
        this.a = mIXMLTransformerRuleArray;
        Arrays.sort(this.a, new RuleComparator());
        int n = 0;
        while (n < this.a.length) {
            if (n != 0) {
                if (this.a[n].getFromVersion().equals(this.a[n - 1].getFromVersion())) {
                    throw new IllegalArgumentException("DUPLICATE RULES FROM " + this.a[n].getFromVersion() + " SPECIFIED");
                }
                if (!this.a[n].getFromVersion().equals(this.a[n - 1].getToVersion())) {
                    throw new IllegalArgumentException("INVALID OR MISSING RULE FROM " + this.a[n].getFromVersion() + " TO " + this.a[n - 1].getToVersion());
                }
            }
            ++n;
        }
    }

    public Document transform(Document document, String string, String string2) throws MIXMLTransformException {
        int[] nArray = MIXMLTransformerImpl.a(this.a, string, string2);
        int n = nArray[0];
        int n2 = nArray[1];
        if (n == -1 || n2 == -1) {
            throw new MIXMLTransformException("TRANSFORMER NOT VALID FOR VERSIONS " + string + " TO " + string2);
        }
        if (n <= n2) {
            int n3 = n;
            while (n3 <= n2) {
                document = this.a[n3].transform(document);
                ++n3;
            }
        } else if (n2 < n) {
            throw new MIXMLTransformException("TRANSFORMER NOT VALID FOR VERSIONS " + string + " TO " + string2);
        }
        return document;
    }

    private static final int[] a(MIXMLTransformerRule[] mIXMLTransformerRuleArray, String string, String string2) {
        int[] nArray = new int[]{-1, -1};
        int n = 0;
        while (n < mIXMLTransformerRuleArray.length) {
            if (mIXMLTransformerRuleArray[n].getFromVersion().equals(string)) {
                nArray[0] = n;
            }
            if (mIXMLTransformerRuleArray[n].getToVersion().equals(string2)) {
                nArray[1] = n;
            }
            ++n;
        }
        return nArray;
    }

    private class RuleComparator
    implements Comparator {
        private RuleComparator() {
        }

        public int compare(Object object, Object object2) {
            MIXMLTransformerRule mIXMLTransformerRule = (MIXMLTransformerRule)object;
            MIXMLTransformerRule mIXMLTransformerRule2 = (MIXMLTransformerRule)object2;
            if (mIXMLTransformerRule.getFromVersion().compareTo(mIXMLTransformerRule.getToVersion()) < 0 && mIXMLTransformerRule2.getFromVersion().compareTo(mIXMLTransformerRule2.getToVersion()) < 0) {
                return mIXMLTransformerRule.getFromVersion().compareTo(mIXMLTransformerRule2.getFromVersion());
            }
            if (mIXMLTransformerRule.getFromVersion().compareTo(mIXMLTransformerRule.getToVersion()) > 0 && mIXMLTransformerRule2.getFromVersion().compareTo(mIXMLTransformerRule2.getToVersion()) > 0) {
                return mIXMLTransformerRule2.getFromVersion().compareTo(mIXMLTransformerRule.getFromVersion());
            }
            return 0;
        }
    }
}

