/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.GeometryUtilities;
import com.mapinfo.midev.geometry.ICurve;
import com.mapinfo.midev.geometry.IDirectPositionIterator;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.IFeatureGeometry;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.ILegacyArc;
import com.mapinfo.midev.geometry.ILineString;
import com.mapinfo.midev.geometry.IMultiCurve;
import com.mapinfo.midev.geometry.IMultiPoint;
import com.mapinfo.midev.geometry.IMultiPolygon;
import com.mapinfo.midev.geometry.IPoint;
import com.mapinfo.midev.geometry.IPolygon;
import com.mapinfo.midev.geometry.IRing;
import com.mapinfo.midev.geometry.MeasurementUtilities;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.impl.GeometryFactory;
import com.mapinfo.midev.geometry.impl.LineString;
import com.mapinfo.midev.geometry.operations.GeometryOperations;
import com.mapinfo.midev.unit.AreaUnit;
import com.mapinfo.midev.unit.ComputationType;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;

public final class CentroidUtilities {
    private CentroidUtilities() {
    }

    public static DirectPosition calculateCentroid(IGeometry g) {
        DirectPosition result;
        if (g == null || g.isEmpty()) {
            result = null;
        } else {
            switch (g.getType()) {
                case CURVE: {
                    result = CentroidUtilities.calculateCentroid(((ICurve)g).asLineString());
                    break;
                }
                case LEGACY_ARC: {
                    result = CentroidUtilities.calculateCentroid(((ILegacyArc)g).asLineString());
                    break;
                }
                case LINE_STRING: {
                    result = CentroidUtilities.getCentroid(((ILineString)g).getControlPoints());
                    break;
                }
                case MULTI_CURVE: {
                    result = CentroidUtilities.calculateCentroid(CentroidUtilities.getLongestCurve((IMultiCurve)g));
                    break;
                }
                case MULTI_POINT: {
                    result = CentroidUtilities.getMPointCentroid((IMultiPoint)g);
                    break;
                }
                case MULTI_POLYGON: {
                    result = CentroidUtilities.calculateCentroid(CentroidUtilities.getLargestPolygon((IMultiPolygon)g));
                    break;
                }
                case POINT: {
                    result = ((IPoint)g).getDirectPosition();
                    break;
                }
                case POLYGON: {
                    result = CentroidUtilities.getCentroid((IPolygon)g);
                    break;
                }
                case RING: {
                    result = CentroidUtilities.getCentroid(new GeometryFactory(g.getSpatialInfo()).newPolygon((IRing)g));
                    break;
                }
                case LEGACY_TEXT: 
                case MULTI_FEATURE_GEOMETRY: 
                case RECTANGLE: 
                case ELLIPSE: 
                case ROUNDED_RECTANGLE: {
                    result = g.getEnvelope().getCenter();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return result;
    }

    private static DirectPosition getMPointCentroid(IMultiPoint g) {
        IDirectPositionList directPositionList = g.getPositions();
        IDirectPositionIterator directPositionIterator = directPositionList.getDirectPositionIterator();
        double avgPointX = 0.0;
        double avgPointY = 0.0;
        int numPoints = directPositionList.size();
        DirectPosition directPosition = new DirectPosition();
        while (directPositionIterator.hasNext()) {
            directPositionIterator.nextDirectPosition(directPosition);
            avgPointX += directPosition.getX();
            avgPointY += directPosition.getY();
        }
        DirectPosition avgDirectPosition = new DirectPosition(avgPointX /= (double)numPoints, avgPointY /= (double)numPoints);
        directPositionIterator = directPositionList.getDirectPositionIterator();
        DirectPosition startPosition = directPositionIterator.nextDirectPosition(directPosition);
        CoordSys coordSys = g.getCoordSys();
        Length currentLength = MeasurementUtilities.length(startPosition, avgDirectPosition, coordSys);
        int minDistacePointIndex = 0;
        int curIndex = 0;
        while (directPositionIterator.hasNext()) {
            ++curIndex;
            directPositionIterator.nextDirectPosition(directPosition);
            Length newLength = MeasurementUtilities.length(directPosition, avgDirectPosition, coordSys);
            if (!(currentLength.getValue() > newLength.getValue())) continue;
            currentLength = newLength;
            minDistacePointIndex = curIndex;
        }
        return directPositionList.getDirectPosition(minDistacePointIndex, directPosition);
    }

    private static IPolygon getLargestPolygon(IMultiPolygon multiPolygon) {
        ComputationType ct = GeometryUtilities.getDefaultComputationType(multiPolygon.getCoordSys());
        double largestArea = 0.0;
        IPolygon largestPolygon = null;
        for (IPolygon p : multiPolygon) {
            double area = p.getArea(ct).getValue(AreaUnit.SQUARE_METER);
            if (!(area > largestArea)) continue;
            largestArea = area;
            largestPolygon = p;
        }
        return largestPolygon;
    }

    public static ICurve getLongestCurve(IMultiCurve multiCurve) {
        ComputationType ct = GeometryUtilities.getDefaultComputationType(multiCurve.getCoordSys());
        double longestLength = 0.0;
        ICurve longestCurve = null;
        for (ICurve curve : multiCurve) {
            double length = curve.getLength(ct).getValue(LinearUnit.METER);
            if (!(length >= longestLength)) continue;
            longestLength = length;
            longestCurve = curve;
        }
        return longestCurve;
    }

    private static DirectPosition getCentroid(IDirectPositionList dpl) {
        DirectPosition result;
        if (dpl.size() % 2 == 0) {
            int index = dpl.size() / 2 - 1;
            DirectPosition dp1 = dpl.getDirectPosition(index, new DirectPosition());
            DirectPosition dp2 = dpl.getDirectPosition(index + 1, new DirectPosition());
            result = CentroidUtilities.getMidpoint(dp1, dp2);
        } else {
            result = dpl.getDirectPosition((dpl.size() - 1) / 2, new DirectPosition());
        }
        return result;
    }

    private static DirectPosition getCentroid(IPolygon polygon) {
        Envelope mbr = polygon.getEnvelope();
        DirectPosition result = mbr.getCenter();
        if (!polygon.contains(result)) {
            DirectPosition left = new DirectPosition(mbr.getLLX(), result.getY());
            DirectPosition right = new DirectPosition(mbr.getURX(), result.getY());
            LineString lineString = new GeometryFactory(polygon.getSpatialInfo()).newLineString(new DirectPositionArray(left, right));
            IFeatureGeometry intersection = GeometryOperations.intersection(polygon, lineString);
            if (intersection != null && !intersection.isEmpty()) {
                switch (intersection.getType()) {
                    case MULTI_CURVE: {
                        IMultiCurve mc = (IMultiCurve)intersection;
                        ICurve curve = (ICurve)mc.iterator().next();
                        if (mc.getCurveCount() != 1) {
                            double distance;
                            if (CoordSysUtilities.isLongLat((CoordSys)polygon.getCoordSys())) {
                                distance = Double.POSITIVE_INFINITY;
                                for (ICurve c : mc) {
                                    double dx;
                                    if (!(c.getStartPosition().getX() > result.getX()) || !(c.getEndPosition().getX() > result.getX()) || !((dx = Math.min(c.getStartPosition().getX() - result.getX(), c.getEndPosition().getX() - result.getX())) < distance)) continue;
                                    distance = dx;
                                    curve = c;
                                }
                            } else {
                                distance = Double.POSITIVE_INFINITY;
                                for (ICurve c : mc) {
                                    double dx;
                                    if (!(c.getStartPosition().getX() < result.getX()) || !(c.getEndPosition().getX() < result.getX()) || !((dx = Math.min(result.getX() - c.getStartPosition().getX(), result.getX() - c.getEndPosition().getX())) < distance)) continue;
                                    distance = dx;
                                    curve = c;
                                }
                            }
                        }
                        DirectPosition start = curve.getStartPosition();
                        DirectPosition end = curve.getEndPosition();
                        result = CentroidUtilities.getMidpoint(start, end);
                        break;
                    }
                    default: {
                        result = CentroidUtilities.calculateCentroid(intersection);
                    }
                }
            }
        }
        return result;
    }

    public static DirectPosition getMidpoint(DirectPosition dp1, DirectPosition dp2) {
        return new DirectPosition((dp2.getX() + dp1.getX()) / 2.0, (dp2.getY() + dp1.getY()) / 2.0);
    }
}

