/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry;

import com.mapinfo.midev.coordsys.CodeSet;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.transform.CoordTransform;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.IDirectPositionIterator;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.InvalidGeometryException;
import com.mapinfo.midev.geometry.InvalidGeometryOperationException;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.util.ArgumentValidator;
import com.mapinfo.midev.util.Code;
import com.mapinfo.midev.util.DoubleRect;
import com.mapinfo.midev.util.PrivateAPI;
import com.mapinfo.midev.util.PublicAPI;
import java.io.Serializable;

@PublicAPI
public final class Envelope
implements Serializable {
    private DirectPosition m_ll;
    private DirectPosition m_ur;
    private SpatialInfo m_spatialInfo;

    public Envelope(SpatialInfo spatialInfo) {
        ArgumentValidator.assertNotNullReference((String)"spatialInfo", (Object)spatialInfo);
        this.m_spatialInfo = spatialInfo;
        this.setEmpty();
    }

    public Envelope(Envelope e) {
        ArgumentValidator.assertNotNullReference((String)"e", (Object)e);
        this.m_spatialInfo = e.m_spatialInfo;
        this.m_ll = e.m_ll.getCopy();
        this.m_ur = e.m_ur.getCopy();
    }

    public Envelope(DirectPosition dp1, DirectPosition dp2, SpatialInfo spatialInfo) {
        this(spatialInfo);
        this.extend(dp1);
        this.extend(dp2);
    }

    public Envelope(double x1, double y1, double x2, double y2, SpatialInfo spatialInfo) {
        this(spatialInfo);
        this.extend(x1, y1);
        this.extend(x2, y2);
    }

    @PrivateAPI
    public Envelope(double x1, double y1, double z1, double x2, double y2, double z2, SpatialInfo spatialInfo) {
        this(spatialInfo);
        this.extend(x1, y1, z1);
        this.extend(x2, y2, z2);
    }

    @PrivateAPI
    public Envelope(DoubleRect bounds, SpatialInfo spatialInfo) {
        this(spatialInfo);
        this.m_ll.setXY(bounds.getMinX(), bounds.getMinY());
        this.m_ur.setXY(bounds.getMaxX(), bounds.getMaxY());
    }

    public void set(DirectPosition dp1, DirectPosition dp2) {
        this.setEmpty();
        this.extend(dp1);
        this.extend(dp2);
    }

    public void set(double x1, double y1, double x2, double y2) {
        this.setEmpty();
        this.extend(x1, y1);
        this.extend(x2, y2);
    }

    @PrivateAPI
    public void set(double x1, double y1, double z1, double x2, double y2, double z2) {
        this.setEmpty();
        this.extend(x1, y1, z1);
        this.extend(x2, y2, z2);
    }

    public void offset(double deltaX, double deltaY) {
        this.m_ll.offsetXY(deltaX, deltaY);
        this.m_ur.offsetXY(deltaX, deltaY);
    }

    public void expand(double deltaX, double deltaY) throws InvalidGeometryOperationException {
        if (deltaX < 0.0 && this.getExtentX() / 2.0 < Math.abs(deltaX)) {
            throw new InvalidGeometryOperationException("deltaX is either negative or its absolute value is greater than half the envelope extent for this delta direction: " + deltaX);
        }
        if (deltaY < 0.0 && this.getExtentY() / 2.0 < Math.abs(deltaY)) {
            throw new InvalidGeometryOperationException("deltaY is either negative or its absolute value is greater than half the envelope extent for this delta direction: " + deltaY);
        }
        this.m_ll.offsetXY(-1.0 * deltaX, -1.0 * deltaY);
        this.m_ur.offsetXY(deltaX, deltaY);
    }

    @PrivateAPI
    public void expand(double deltaX, double deltaY, double deltaZ) throws InvalidGeometryOperationException {
        if (this.isExtentZEmpty()) {
            throw new InvalidGeometryOperationException("Envelope has no z extent");
        }
        if (deltaZ < 0.0 && this.getExtentZ() / 2.0 < Math.abs(deltaZ)) {
            throw new InvalidGeometryOperationException("deltaZ is either negative or its absolute value is greater than half the envelope extent for this delta direction: " + deltaZ);
        }
        this.expand(deltaX, deltaY);
        this.m_ll.setZ(this.m_ll.getZ() - deltaZ);
        this.m_ur.setZ(this.m_ur.getZ() + deltaZ);
    }

    public void scale(double scaleX, double scaleY) throws InvalidGeometryOperationException {
        if (scaleX < -1.0) {
            throw new InvalidGeometryOperationException("The x scale factor must be greater than or equal to -1.0");
        }
        if (scaleY < -1.0) {
            throw new InvalidGeometryOperationException("The y scale factor must be greater than or equal to -1.0");
        }
        double deltaX = this.getExtentX() * scaleX / 2.0;
        double deltaY = this.getExtentY() * scaleY / 2.0;
        this.expand(deltaX, deltaY);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Envelope)) {
            return false;
        }
        Envelope e = (Envelope)obj;
        if (this.isEmpty() && e.isEmpty() && this.m_spatialInfo.equals(e.m_spatialInfo)) {
            return true;
        }
        boolean bEqual = false;
        if (!this.isEmpty() && !e.isEmpty() && this.isExtentZEmpty() == e.isExtentZEmpty()) {
            bEqual = !this.isExtentZEmpty() ? this.m_spatialInfo.equals(e.m_spatialInfo) && this.m_ll.equalsXY(e.m_ll) && this.m_ur.equalsXY(e.m_ur) : this.m_spatialInfo.equals(e.m_spatialInfo) && this.m_ll.equalsXYZ(e.m_ll) && this.m_ur.equalsXYZ(e.m_ur);
        }
        return bEqual;
    }

    public int hashCode() {
        int result = this.m_ll.hashCode();
        result = 31 * result + this.m_ur.hashCode();
        result = 31 * result + this.m_spatialInfo.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Rectangle {");
        sb.append(this.m_ll).append(',');
        sb.append(this.m_ur).append(',');
        CoordSys coordSys = this.getSpatialInfo().getCoordSys();
        CodeSet codes = coordSys.getCodes();
        Code code = codes.getFirstCode("epsg");
        if (code == null) {
            code = codes.getFirstCode("mapinfo");
        }
        sb.append(code);
        return sb.append('}').toString();
    }

    @PrivateAPI
    public boolean equalsXY(Envelope e) {
        boolean bEqual = !this.isEmpty() && !e.isEmpty() && this.m_spatialInfo.equals(e.m_spatialInfo) && this.m_ll.equalsXY(e.m_ll) && this.m_ur.equalsXY(e.m_ur);
        return bEqual;
    }

    public Envelope getCopy() {
        return new Envelope(this);
    }

    public Envelope getCopy(SpatialInfo spatialInfo) {
        if (this.isEmpty()) {
            return new Envelope(spatialInfo);
        }
        Envelope env = null;
        if (!this.m_spatialInfo.equals(spatialInfo)) {
            CoordTransform ct = this.m_spatialInfo.getCoordSys().createCoordTransform(spatialInfo.getCoordSys());
            DoubleRect rect = new DoubleRect(this.m_ll.getX(), this.m_ll.getY(), this.m_ur.getX(), this.m_ur.getY());
            rect = ct.transform(rect);
            env = new Envelope(spatialInfo);
            env.m_ll = new DirectPosition(rect.getMinX(), rect.getMinY(), this.getLLZ());
            env.m_ur = new DirectPosition(rect.getMaxX(), rect.getMaxY(), this.getURZ());
        } else {
            env = new Envelope(this);
        }
        return env;
    }

    public void extend(Envelope e) {
        if (e.isEmpty()) {
            return;
        }
        if (!this.m_spatialInfo.equals(e.getSpatialInfo())) {
            e = e.getCopy(this.m_spatialInfo);
        }
        if (e.isExtentZEmpty()) {
            this.extend(e.m_ll.getX(), e.m_ll.getY());
            this.extend(e.m_ur.getX(), e.m_ur.getY());
        } else {
            this.extend(e.m_ll.getX(), e.m_ll.getY(), e.m_ll.getZ());
            this.extend(e.m_ur.getX(), e.m_ur.getY(), e.m_ur.getZ());
        }
    }

    public void extend(DirectPosition dp) {
        this.extend(dp.getX(), dp.getY(), dp.getZ());
    }

    public void extend(double x, double y) {
        this.m_ll.setX(Math.min(x, this.m_ll.getX()));
        this.m_ll.setY(Math.min(y, this.m_ll.getY()));
        this.m_ur.setX(Math.max(x, this.m_ur.getX()));
        this.m_ur.setY(Math.max(y, this.m_ur.getY()));
    }

    @PrivateAPI
    public void extend(double x, double y, double z) {
        this.extend(x, y);
        if (!Double.isNaN(z)) {
            this.m_ll.setZ(Math.min(z, this.m_ll.getZ()));
            this.m_ur.setZ(Math.max(z, this.m_ur.getZ()));
        }
    }

    public void extend(IDirectPositionList dpl) {
        IDirectPositionIterator dpIter = dpl.getDirectPositionIterator();
        DirectPosition dp = new DirectPosition();
        while (dpIter.hasNext()) {
            this.extend(dpIter.nextDirectPosition(dp));
        }
    }

    public boolean intersects(Envelope e) {
        if (this.isEmpty() || e.isEmpty()) {
            return false;
        }
        if (!this.m_spatialInfo.equals(e.getSpatialInfo())) {
            e = e.getCopy(this.m_spatialInfo);
        }
        double tolerance = e.getSpatialInfo().getTolerance();
        boolean bRatioXUR = Math.abs(e.m_ur.getX() - this.m_ll.getX()) <= tolerance;
        boolean bRatioYUR = Math.abs(e.m_ur.getY() - this.m_ll.getY()) <= tolerance;
        boolean bRatioXLL = Math.abs(e.m_ll.getX() - this.m_ur.getX()) <= tolerance;
        boolean bRatioYLL = Math.abs(e.m_ll.getY() - this.m_ur.getY()) <= tolerance;
        boolean bOverlap = !(!(e.m_ur.getX() >= this.m_ll.getX()) && !bRatioXUR || !(e.m_ur.getY() >= this.m_ll.getY()) && !bRatioYUR || !(e.m_ll.getX() <= this.m_ur.getX()) && !bRatioXLL || !(e.m_ll.getY() <= this.m_ur.getY()) && !bRatioYLL);
        return bOverlap;
    }

    public Envelope getIntersection(Envelope e) {
        Envelope env = new Envelope(this.m_spatialInfo);
        if (this.isEmpty() || e.isEmpty()) {
            return env;
        }
        if (!this.m_spatialInfo.equals(e.getSpatialInfo())) {
            e = e.getCopy(this.m_spatialInfo);
        }
        DirectPosition ll = null;
        DirectPosition ur = null;
        if (this.isExtentZEmpty() || e.isExtentZEmpty()) {
            ll = new DirectPosition(Math.max(e.m_ll.getX(), this.m_ll.getX()), Math.max(e.m_ll.getY(), this.m_ll.getY()), Double.POSITIVE_INFINITY);
            ur = new DirectPosition(Math.min(e.m_ur.getX(), this.m_ur.getX()), Math.min(e.m_ur.getY(), this.m_ur.getY()), Double.NEGATIVE_INFINITY);
        } else {
            ll = new DirectPosition(Math.max(e.m_ll.getX(), this.m_ll.getX()), Math.max(e.m_ll.getY(), this.m_ll.getY()), Math.max(e.m_ll.getZ(), this.m_ll.getZ()));
            ur = new DirectPosition(Math.min(e.m_ur.getX(), this.m_ur.getX()), Math.min(e.m_ur.getY(), this.m_ur.getY()), Math.min(e.m_ur.getZ(), this.m_ur.getZ()));
        }
        env.m_ll = ll;
        env.m_ur = ur;
        return env;
    }

    public boolean contains(DirectPosition dp) {
        if (this.isEmpty()) {
            return false;
        }
        return dp.getX() >= this.m_ll.getX() && dp.getX() <= this.m_ur.getX() && dp.getY() >= this.m_ll.getY() && dp.getY() <= this.m_ur.getY();
    }

    public boolean contains(Envelope env) {
        if (this.isEmpty() || env.isEmpty()) {
            return false;
        }
        if (!this.m_spatialInfo.equals(env.getSpatialInfo())) {
            env = env.getCopy(this.m_spatialInfo);
        }
        return this.contains(env.m_ll) && this.contains(env.m_ur);
    }

    @PrivateAPI
    public boolean isExtentZEmpty() {
        return this.m_ur.getZ() < this.m_ll.getZ();
    }

    public DirectPosition getCenter() throws InvalidGeometryException {
        if (this.isEmpty()) {
            throw new InvalidGeometryException("Cannot get center of an empty envelope.");
        }
        DirectPosition dp = new DirectPosition((this.m_ll.getX() + this.m_ur.getX()) / 2.0, (this.m_ll.getY() + this.m_ur.getY()) / 2.0);
        return dp;
    }

    public DirectPosition getUpperRight() {
        return this.m_ur.getCopy();
    }

    public DirectPosition getLowerLeft() {
        return this.m_ll.getCopy();
    }

    public double getExtentX() throws InvalidGeometryException {
        if (this.isEmpty()) {
            throw new InvalidGeometryException("Cannot get x extent of an empty envelope.");
        }
        return this.m_ur.getX() - this.m_ll.getX();
    }

    public double getExtentY() throws InvalidGeometryException {
        if (this.isEmpty()) {
            throw new InvalidGeometryException("Cannot get y extent of an empty envelope.");
        }
        return this.m_ur.getY() - this.m_ll.getY();
    }

    @PrivateAPI
    public double getExtentZ() throws InvalidGeometryException, InvalidGeometryOperationException {
        if (this.isEmpty()) {
            throw new InvalidGeometryException("Cannot get z extent of an empty envelope.");
        }
        if (this.isExtentZEmpty()) {
            throw new InvalidGeometryOperationException("Envelope has no z extent.");
        }
        return this.m_ur.getZ() - this.m_ll.getZ();
    }

    public boolean isEmpty() {
        return this.m_ll.getX() > this.m_ur.getX() || this.m_ll.getY() > this.m_ur.getY();
    }

    public void setEmpty() {
        this.m_ll = new DirectPosition(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.m_ur = new DirectPosition(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
    }

    public void setEmpty(SpatialInfo spatialInfo) {
        this.setEmpty();
        this.m_spatialInfo = spatialInfo;
    }

    public SpatialInfo getSpatialInfo() {
        return this.m_spatialInfo;
    }

    public double getLLX() {
        return this.m_ll.getX();
    }

    public double getLLY() {
        return this.m_ll.getY();
    }

    @PrivateAPI
    public double getLLZ() {
        return this.m_ll.getZ();
    }

    public double getURX() {
        return this.m_ur.getX();
    }

    public double getURY() {
        return this.m_ur.getY();
    }

    @PrivateAPI
    public double getURZ() {
        return this.m_ur.getZ();
    }

    @PrivateAPI
    public DoubleRect asDoubleRect() {
        DoubleRect result = new DoubleRect();
        result.setMinX(this.m_ll.getX());
        result.setMinY(this.m_ll.getY());
        result.setMaxX(this.m_ur.getX());
        result.setMaxY(this.m_ur.getY());
        return result;
    }
}

