/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.factory.CoordSysFactory;
import com.mapinfo.midev.geometry.CurveBuilder;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.ILineString;
import com.mapinfo.midev.geometry.IMultiPoint;
import com.mapinfo.midev.geometry.IPoint;
import com.mapinfo.midev.geometry.IPolygon;
import com.mapinfo.midev.geometry.IPolygonBuilder;
import com.mapinfo.midev.geometry.MultiCurveBuilder;
import com.mapinfo.midev.geometry.MultiPointBuilder;
import com.mapinfo.midev.geometry.MultiPolygonBuilder;
import com.mapinfo.midev.geometry.PolygonBuilder;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.impl.LineString;
import com.mapinfo.midev.geometry.impl.MultiPoint;
import com.mapinfo.midev.geometry.impl.Point;
import com.mapinfo.midev.util.ArgumentValidator;
import com.mapinfo.midev.util.Code;
import com.mapinfo.midev.util.PublicAPI;

@PublicAPI
public final class GeometryFactory {
    private final SpatialInfo m_spatialInfo;

    public static GeometryFactory forSrsName(String srsName) {
        ArgumentValidator.assertNotNullReference((String)"srsName", (Object)srsName);
        return GeometryFactory.forCoordSys(CoordSysFactory.getDefaultCoordSysFactory().getCoordSys(srsName));
    }

    public static GeometryFactory forCoordSysCode(Code code) {
        ArgumentValidator.assertNotNullReference((String)"code", (Object)code);
        return GeometryFactory.forCoordSys(CoordSysFactory.getDefaultCoordSysFactory().getCoordSys(code));
    }

    public static GeometryFactory forCoordSys(CoordSys coordSys) {
        ArgumentValidator.assertNotNullReference((String)"coordSys", (Object)coordSys);
        return new GeometryFactory(SpatialInfo.create(coordSys));
    }

    public static GeometryFactory forSpatialInfo(SpatialInfo spatialInfo) {
        ArgumentValidator.assertNotNullReference((String)"spatialInfo", (Object)spatialInfo);
        return new GeometryFactory(spatialInfo);
    }

    private GeometryFactory(SpatialInfo spatialInfo) {
        this.m_spatialInfo = spatialInfo;
    }

    public IPoint newPoint(double x, double y) {
        return this.newPoint(GeometryFactory.pos(x, y));
    }

    public IPoint newPoint(String x, String y) {
        return this.newPoint(GeometryFactory.pos(x, y));
    }

    public IPoint newPoint(DirectPosition directPosition) {
        return new Point(this.m_spatialInfo, directPosition);
    }

    public IMultiPoint newMultiPoint(DirectPosition ... positions) {
        return new MultiPoint(this.m_spatialInfo, GeometryFactory.createDirectPositionArray(positions));
    }

    public IMultiPoint newMultiPoint(Iterable<DirectPosition> positions) {
        return new MultiPoint(this.m_spatialInfo, GeometryFactory.createDirectPositionArray(positions));
    }

    public IMultiPoint newMultiPoint(IDirectPositionList positions) {
        return new MultiPoint(this.m_spatialInfo, positions);
    }

    public MultiPointBuilder newMultiPoint() {
        return new MultiPointBuilder(this.m_spatialInfo);
    }

    public ILineString newLineString(DirectPosition ... positions) {
        return new LineString(this.m_spatialInfo, GeometryFactory.createDirectPositionArray(positions));
    }

    public ILineString newLineString(Iterable<DirectPosition> positions) {
        return new LineString(this.m_spatialInfo, GeometryFactory.createDirectPositionArray(positions));
    }

    public ILineString newLineString(IDirectPositionList positions) {
        return new LineString(this.m_spatialInfo, positions);
    }

    public CurveBuilder newCurve() {
        return new CurveBuilder(this.m_spatialInfo);
    }

    public MultiCurveBuilder newMultiCurve() {
        return new MultiCurveBuilder(this.m_spatialInfo);
    }

    public IPolygonBuilder<IPolygon> newPolygon() {
        return new PolygonBuilder(this.m_spatialInfo);
    }

    public MultiPolygonBuilder newMultiPolygon() {
        return new MultiPolygonBuilder(this.m_spatialInfo);
    }

    static IDirectPositionList createDirectPositionArray(DirectPosition ... directPositions) {
        return new DirectPositionArray(directPositions);
    }

    static IDirectPositionList createDirectPositionArray(Iterable<DirectPosition> positions) {
        DirectPositionArray posList = new DirectPositionArray();
        for (DirectPosition position : positions) {
            posList.add(position);
        }
        return posList;
    }

    public static DirectPosition pos(double x, double y) {
        return new DirectPosition(x, y);
    }

    public static DirectPosition pos(String x, String y) {
        return new DirectPosition(Double.parseDouble(x), Double.parseDouble(y));
    }

    public static IDirectPositionList posList(DirectPosition ... positions) {
        DirectPositionArray posList = new DirectPositionArray(positions.length);
        for (DirectPosition position : positions) {
            posList.add(position);
        }
        return posList;
    }
}

