/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.IMultiPolygon;
import com.mapinfo.midev.geometry.IPoint;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.Point;
import com.mapinfo.midev.geometry.operations.contains.ContainsOp;
import java.util.Iterator;
import java.util.Random;

public final class PointInPolygonFactory
implements Iterator<IPoint> {
    private final ContainsOp m_containsOp;
    private final SpatialInfo m_spatialInfo;
    private final Random m_random;
    private final double m_minLong;
    private final double m_minLat;
    private final double m_diffLong;
    private final double m_diffLat;
    static String PIPF_UNSUPPORTED_OP_MESSAGE = "PointInPolygonFactory has no underlying collection to remove from.";

    public PointInPolygonFactory(IMultiPolygon multiPolygon) {
        this.m_containsOp = new ContainsOp(multiPolygon);
        this.m_spatialInfo = multiPolygon.getSpatialInfo();
        this.m_random = new Random();
        DirectPosition lowerLeft = multiPolygon.getEnvelope().getLowerLeft();
        DirectPosition upperRight = multiPolygon.getEnvelope().getUpperRight();
        this.m_minLong = Math.min(lowerLeft.getY(), upperRight.getY());
        double maxLong = Math.max(lowerLeft.getY(), upperRight.getY());
        this.m_minLat = Math.min(lowerLeft.getX(), upperRight.getX());
        double maxLat = Math.max(lowerLeft.getX(), upperRight.getX());
        this.m_diffLong = maxLong - this.m_minLong;
        this.m_diffLat = maxLat - this.m_minLat;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public IPoint next() {
        double nextLong;
        double nextLat;
        Point point;
        boolean foundPoint;
        do {
            nextLong = this.m_minLong + this.m_diffLong * this.m_random.nextDouble();
        } while (!(foundPoint = this.m_containsOp.contains(point = new Point(this.m_spatialInfo, new DirectPosition(nextLat = this.m_minLat + this.m_diffLat * this.m_random.nextDouble(), nextLong)))));
        return point;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(PIPF_UNSUPPORTED_OP_MESSAGE);
    }
}

