/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.EngineeringCoordSys;
import com.mapinfo.midev.coordsys.GeographicCoordSys;
import com.mapinfo.midev.coordsys.factory.CoordSysFactory;
import com.mapinfo.midev.coordsys.util.CoordSysHashUtilities;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.PrecisionMode;
import com.mapinfo.midev.unit.Angle;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.ArgumentValidator;
import com.mapinfo.midev.util.PrivateAPI;
import com.mapinfo.midev.util.PublicAPI;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@PublicAPI
public final class SpatialInfo
implements Serializable {
    private transient CoordSys m_csys;
    private final LinearUnit m_zUnit;
    private final double m_tolerance;
    private final Length m_toleranceLength;
    private PrecisionMode m_precision;
    private static final int DEFAULT_CACHE_SIZE = 50;
    private static Map<CoordSys, SpatialInfo> CACHE = Collections.synchronizedMap(new LinkedHashMap<CoordSys, SpatialInfo>(51, 0.75f, true){

        @Override
        public boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 50;
        }
    });
    public static final Length DEFAULT_TOLERANCE_LENGTH = new Length(0.04, LinearUnit.METER);

    public static SpatialInfo create(CoordSys coordsys) {
        SpatialInfo spatialInfo = CACHE.get(coordsys);
        if (spatialInfo == null) {
            spatialInfo = new SpatialInfo(coordsys);
            CACHE.put(coordsys, spatialInfo);
        }
        return spatialInfo;
    }

    @PrivateAPI
    public SpatialInfo(CoordSys csys) {
        this(csys, null, DEFAULT_TOLERANCE_LENGTH);
    }

    @PrivateAPI
    public SpatialInfo(CoordSys csys, LinearUnit zUnit) {
        this(csys, zUnit, DEFAULT_TOLERANCE_LENGTH);
    }

    @PrivateAPI
    public SpatialInfo(CoordSys csys, LinearUnit zUnit, double tolerance) {
        ArgumentValidator.assertNotNullReference((String)"csys", (Object)csys);
        this.m_csys = csys;
        this.m_zUnit = zUnit;
        this.m_tolerance = tolerance;
        if (CoordSysUtilities.isLongLat((CoordSys)this.m_csys)) {
            GeographicCoordSys geographicCoordSys = (GeographicCoordSys)this.m_csys;
            Angle a = new Angle(tolerance, geographicCoordSys.getAngularUnit());
            this.m_toleranceLength = Angle.convert((Angle)a);
        } else {
            LinearUnit lu = CoordSysUtilities.isEngineering((CoordSys)this.m_csys) ? ((EngineeringCoordSys)this.m_csys).getLinearUnit() : ((GeographicCoordSys)this.m_csys).getProjection().getProjectionParams().getLinearUnit();
            this.m_toleranceLength = new Length(tolerance, lu);
        }
    }

    @PrivateAPI
    public SpatialInfo(CoordSys csys, LinearUnit zUnit, Length len) {
        ArgumentValidator.assertNotNullReference((String)"csys", (Object)csys);
        this.m_csys = csys;
        this.m_zUnit = zUnit;
        this.m_toleranceLength = len;
        if (CoordSysUtilities.isLongLat((CoordSys)this.m_csys)) {
            GeographicCoordSys geographicCoordSys = (GeographicCoordSys)this.m_csys;
            Angle a = Length.convert((Length)len);
            this.m_tolerance = a.getValue(geographicCoordSys.getAngularUnit());
        } else {
            LinearUnit lu = CoordSysUtilities.isEngineering((CoordSys)this.m_csys) ? ((EngineeringCoordSys)this.m_csys).getLinearUnit() : ((GeographicCoordSys)this.m_csys).getProjection().getProjectionParams().getLinearUnit();
            this.m_tolerance = this.m_toleranceLength.getValue(lu);
        }
    }

    @PrivateAPI
    public PrecisionMode getPrecisionMode() {
        if (this.m_precision == null) {
            this.m_precision = new PrecisionMode(this.m_tolerance);
        }
        return this.m_precision;
    }

    public CoordSys getCoordSys() {
        return this.m_csys;
    }

    public LinearUnit getZUnit() {
        return this.m_zUnit;
    }

    public double getTolerance() {
        return this.m_tolerance;
    }

    public Length getToleranceLength() {
        return this.m_toleranceLength;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpatialInfo si = (SpatialInfo)o;
        return this.m_csys.equivalent(si.getCoordSys()) && this.m_toleranceLength.equals((Object)si.getToleranceLength()) && this.m_zUnit == si.getZUnit();
    }

    public int hashCode() {
        int result = CoordSysHashUtilities.calcHash((CoordSys)this.m_csys);
        result = 29 * result + (this.m_zUnit != null ? this.m_zUnit.hashCode() : 0);
        result = 29 * result + this.m_toleranceLength.hashCode();
        return result;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(CoordSysUtilities.getSRSName((CoordSys)this.m_csys));
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.m_csys = CoordSysFactory.getDefaultCoordSysFactory().getCoordSys((String)s.readObject());
    }
}

