/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.impl;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.GeometryType;
import com.mapinfo.midev.geometry.ICurve;
import com.mapinfo.midev.geometry.ICurveSegment;
import com.mapinfo.midev.geometry.InvalidComputationTypeException;
import com.mapinfo.midev.geometry.InvalidGeometryException;
import com.mapinfo.midev.geometry.MeasurementUtilities;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.CurveSegment;
import com.mapinfo.midev.geometry.impl.CurveSegmentList;
import com.mapinfo.midev.geometry.impl.LineString;
import com.mapinfo.midev.unit.Area;
import com.mapinfo.midev.unit.AreaUnit;
import com.mapinfo.midev.unit.ComputationType;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;
import java.util.Iterator;
import java.util.List;

public class Curve
implements ICurve {
    private final SpatialInfo m_spatialInfo;
    private final CurveSegmentList m_curveSegmentList;
    private Length m_sphericalLength = null;
    private Length m_cartesianLength = null;

    public Curve(SpatialInfo si, CurveSegment curveSegment) {
        this.m_spatialInfo = si;
        this.m_curveSegmentList = new CurveSegmentList(curveSegment);
    }

    public Curve(SpatialInfo si, List<CurveSegment> curveSegments) throws InvalidGeometryException {
        this.m_spatialInfo = si;
        this.m_curveSegmentList = new CurveSegmentList(curveSegments);
    }

    private Curve(SpatialInfo si, CurveSegmentList csList) {
        this.m_spatialInfo = si;
        this.m_curveSegmentList = csList;
    }

    @Override
    public boolean isClosed() {
        return this.m_curveSegmentList.isClosed();
    }

    @Override
    public boolean isEmpty() {
        return this.m_curveSegmentList.size() == 0;
    }

    @Override
    public Length getLength(ComputationType ct) {
        Length len;
        switch (ct) {
            case SPHERICAL: {
                len = this.m_sphericalLength == null ? (this.m_sphericalLength = MeasurementUtilities.length(this, ct)) : this.m_sphericalLength;
                break;
            }
            case CARTESIAN: {
                len = this.m_cartesianLength == null ? (this.m_cartesianLength = MeasurementUtilities.length(this, ct)) : this.m_cartesianLength;
                break;
            }
            default: {
                throw new InvalidComputationTypeException(ct);
            }
        }
        return len;
    }

    @Override
    public int getCurveSegmentCount() {
        return this.m_curveSegmentList.size();
    }

    @Override
    public CurveSegment getCurveSegment(int i) {
        return this.m_curveSegmentList.getCurveSegment(i);
    }

    @Override
    public DirectPosition getEndPosition() {
        return this.m_curveSegmentList.getEndPosition();
    }

    @Override
    public boolean isLinear() {
        return this.m_curveSegmentList.isLinear();
    }

    @Override
    public Length getStartDistance(ComputationType ct) {
        LinearUnit lu = CoordSysUtilities.getLinearUnit((CoordSys)this.getCoordSys());
        if (lu == null) {
            lu = LinearUnit.METER;
        }
        return new Length(0.0, lu, ct);
    }

    @Override
    public Length getEndDistance(ComputationType ct) {
        return this.getLength(ct);
    }

    @Override
    public DirectPosition getPointForDistance(Length len) {
        return MeasurementUtilities.getPointAtDistance(this, len);
    }

    @Override
    public DirectPosition getStartPosition() {
        return this.m_curveSegmentList.getStartPosition();
    }

    @Override
    public boolean zSet() {
        return this.m_curveSegmentList.zSet();
    }

    @Override
    public boolean zAllSet() {
        return this.m_curveSegmentList.zAllSet();
    }

    @Override
    public boolean mSet() {
        return this.m_curveSegmentList.mSet();
    }

    @Override
    public boolean mAllSet() {
        return this.m_curveSegmentList.mAllSet();
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public Envelope getEnvelope() {
        return this.m_curveSegmentList.getEnvelope();
    }

    @Override
    public LineString asLineString() {
        return this.m_curveSegmentList.asLineString();
    }

    @Override
    public LineString asLineString(Length maxSpacing, Length maxOffset) {
        return this.m_curveSegmentList.asLineString(maxSpacing, maxOffset);
    }

    @Override
    public GeometryType getType() {
        return GeometryType.CURVE;
    }

    @Override
    public boolean contains(DirectPosition dp) {
        return this.m_curveSegmentList.contains(dp);
    }

    @Override
    public Iterator<ICurveSegment> iterator() {
        return new _CurveSegmentIterator(this.m_curveSegmentList.iterator());
    }

    @Override
    public Curve getCopy() {
        return new Curve(this.getSpatialInfo(), this.m_curveSegmentList.getCopy());
    }

    @Override
    public Curve getCopy(CoordSys csys) {
        SpatialInfo si = new SpatialInfo(csys, this.getSpatialInfo().getZUnit(), this.getSpatialInfo().getToleranceLength());
        return new Curve(si, this.m_curveSegmentList.getCopy(csys));
    }

    @Override
    public Area getArea(ComputationType ct) {
        return new Area(0.0, AreaUnit.SQUARE_METER, ct);
    }

    @Override
    public Length getPerimeter(ComputationType ct) {
        return new Length(0.0, LinearUnit.METER, ct);
    }

    @Override
    public Curve reverse() {
        return new Curve(this.getSpatialInfo(), this.m_curveSegmentList.reverse());
    }

    @Override
    public SpatialInfo getSpatialInfo() {
        return this.m_spatialInfo;
    }

    @Override
    public CoordSys getCoordSys() {
        return this.m_spatialInfo.getCoordSys();
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    private static class _CurveSegmentIterator
    implements Iterator<ICurveSegment> {
        private final Iterator<CurveSegment> m_iter;

        private _CurveSegmentIterator(Iterator<CurveSegment> iter) {
            this.m_iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.m_iter.hasNext();
        }

        @Override
        public ICurveSegment next() {
            return this.m_iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

