/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.impl;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.InvalidGeometryException;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.UnsupportedGeometryOperationException;
import com.mapinfo.midev.geometry.impl.CurveSegment;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.impl.LineString;
import com.mapinfo.midev.unit.Length;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class CurveSegmentList
implements Serializable {
    private final List<CurveSegment> m_segments;
    private Envelope m_envelope = null;

    CurveSegmentList(CurveSegment cs) {
        this.m_segments = new ArrayList<CurveSegment>(1);
        this.m_segments.add(cs);
        this.setSiblingReferences();
        this.m_envelope = cs.getEnvelope();
    }

    CurveSegmentList(List<CurveSegment> curveSegments) throws InvalidGeometryException {
        if (curveSegments.isEmpty()) {
            throw new InvalidGeometryException("List must contain at least one curve segment.");
        }
        this.m_segments = new ArrayList<CurveSegment>(curveSegments.size());
        for (CurveSegment cs : curveSegments) {
            this.appendCurveSegment(cs);
        }
    }

    protected CurveSegmentList(int size) {
        this.m_segments = new ArrayList<CurveSegment>(size);
    }

    protected void addCurveSegment(CurveSegment cs) {
        this.m_segments.add(cs);
        this.setSiblingReferences();
    }

    private void appendCurveSegment(CurveSegment cs) throws InvalidGeometryException {
        if (!this.m_segments.isEmpty() && !this.getCurveSegment(this.size() - 1).isContiguousTo(cs)) {
            throw new InvalidGeometryException("Appending Curve segment is not contiguous to the last segment in this list.");
        }
        this.m_segments.add(cs);
        this.setSiblingReferences();
    }

    protected void setSiblingReferences() {
        if (this.m_segments.isEmpty()) {
            return;
        }
        Iterator<CurveSegment> iter = this.m_segments.iterator();
        CurveSegment left = iter.next();
        left.setLeftSibling(null);
        left.setRightSibling(null);
        while (iter.hasNext()) {
            CurveSegment right = iter.next();
            left.setRightSibling(right);
            right.setLeftSibling(left);
            right.setRightSibling(null);
            left = right;
        }
    }

    CurveSegment getStartCurveSegment() {
        return this.getCurveSegment(0);
    }

    CurveSegment getEndCurveSegment() {
        return this.getCurveSegment(this.size() - 1);
    }

    CurveSegment getCurveSegment(int index) {
        return this.m_segments.get(index);
    }

    DirectPosition getStartPosition() {
        return this.getCurveSegment(0).getStartPosition();
    }

    DirectPosition getEndPosition() {
        return this.getCurveSegment(this.size() - 1).getEndPosition();
    }

    public boolean isLinear() {
        CurveSegment segment;
        boolean bLinear = false;
        Iterator<CurveSegment> i$ = this.m_segments.iterator();
        while (i$.hasNext() && (bLinear = (segment = i$.next()).isLinear())) {
        }
        return bLinear;
    }

    public boolean isClosed() {
        boolean ret;
        switch (this.size()) {
            case 0: {
                ret = false;
                break;
            }
            case 1: {
                CurveSegment cs = this.getStartCurveSegment();
                ret = cs.isContiguousTo(cs);
                break;
            }
            default: {
                CurveSegment end = this.getEndCurveSegment();
                ret = end.isContiguousTo(this.getStartCurveSegment());
            }
        }
        return ret;
    }

    public boolean zSet() {
        boolean bSet = false;
        Iterator<CurveSegment> iter = this.m_segments.iterator();
        while (iter.hasNext() && !bSet) {
            bSet = iter.next().zSet();
        }
        return bSet;
    }

    public boolean zAllSet() {
        boolean bAllSet = this.size() > 0;
        Iterator<CurveSegment> iter = this.m_segments.iterator();
        while (iter.hasNext() && bAllSet) {
            bAllSet = iter.next().zAllSet();
        }
        return bAllSet;
    }

    public boolean mSet() {
        boolean bSet = false;
        Iterator<CurveSegment> iter = this.m_segments.iterator();
        while (iter.hasNext() && !bSet) {
            bSet = iter.next().mSet();
        }
        return bSet;
    }

    public boolean mAllSet() {
        boolean bAllSet = this.size() > 0;
        Iterator<CurveSegment> iter = this.m_segments.iterator();
        while (iter.hasNext() && bAllSet) {
            bAllSet = iter.next().mAllSet();
        }
        return bAllSet;
    }

    public Envelope getEnvelope() {
        if (this.m_envelope == null) {
            Iterator<CurveSegment> iter = this.m_segments.iterator();
            this.m_envelope = new Envelope(iter.next().getEnvelope());
            while (iter.hasNext()) {
                this.m_envelope.extend(iter.next().getEnvelope());
            }
        }
        return this.m_envelope.getCopy();
    }

    Iterator<CurveSegment> iterator() {
        return Collections.unmodifiableCollection(this.m_segments).iterator();
    }

    public boolean contains(DirectPosition dp) {
        boolean bContains = false;
        Iterator<CurveSegment> iter = this.m_segments.iterator();
        while (iter.hasNext() && !bContains) {
            bContains = iter.next().contains(dp);
        }
        return bContains;
    }

    public int size() {
        return this.m_segments.size();
    }

    public CurveSegmentList reverse() {
        CurveSegmentList csl = new CurveSegmentList(this.size());
        for (int k = this.size() - 1; k >= 0; --k) {
            CurveSegment cs = this.getCurveSegment(k).reverse();
            csl.addCurveSegment(cs);
        }
        return csl;
    }

    public CurveSegmentList getCopy() {
        CurveSegmentList csl = new CurveSegmentList(this.size());
        for (CurveSegment segment : this.m_segments) {
            CurveSegment cs = segment.getCopy();
            csl.addCurveSegment(cs);
        }
        return csl;
    }

    public CurveSegmentList getCopy(CoordSys csys) {
        CurveSegmentList csl = new CurveSegmentList(this.size());
        for (CurveSegment segment : this.m_segments) {
            CurveSegment cs = segment.getCopy(csys);
            csl.addCurveSegment(cs);
        }
        return csl;
    }

    public LineString asLineString() {
        IDirectPositionList dpArray;
        if (this.size() == 1) {
            CurveSegment cs = this.getCurveSegment(0);
            dpArray = cs.isLinear() ? cs.getControlPoints() : cs.asLineString().getControlPoints();
        } else {
            dpArray = new DirectPositionArray();
            for (int k = 0; k < this.size(); ++k) {
                CurveSegment cs;
                if (!dpArray.isEmpty()) {
                    dpArray.remove(dpArray.size() - 1);
                }
                if ((cs = this.getCurveSegment(k)).isLinear()) {
                    dpArray.addAll(cs.getControlPoints());
                    continue;
                }
                dpArray.addAll(cs.asLineString().getControlPoints());
            }
        }
        SpatialInfo si = this.getStartCurveSegment().getSpatialInfo();
        return new LineString(si, dpArray);
    }

    public LineString asLineString(Length maxSpacing, Length maxOffset) {
        throw new UnsupportedGeometryOperationException("");
    }
}

