/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.impl;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.GeometryType;
import com.mapinfo.midev.geometry.GeometryUtilities;
import com.mapinfo.midev.geometry.ILegacyEllipse;
import com.mapinfo.midev.geometry.IRectangle;
import com.mapinfo.midev.geometry.InvalidGeometryException;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.impl.FeatureGeometry;
import com.mapinfo.midev.geometry.impl.LineString;
import com.mapinfo.midev.geometry.impl.MultiPolygon;
import com.mapinfo.midev.geometry.impl.Ring;
import com.mapinfo.midev.unit.Area;
import com.mapinfo.midev.unit.ComputationType;
import com.mapinfo.midev.unit.Length;

public class LegacyEllipse
extends FeatureGeometry
implements ILegacyEllipse {
    private final IRectangle m_rect;

    public LegacyEllipse(IRectangle rect) {
        super(rect.getSpatialInfo());
        this.m_rect = rect;
    }

    @Override
    public boolean zSet() {
        return this.m_rect.zSet();
    }

    @Override
    public boolean zAllSet() {
        return this.m_rect.zAllSet();
    }

    @Override
    public boolean mSet() {
        return this.m_rect.mSet();
    }

    @Override
    public boolean mAllSet() {
        return this.m_rect.mAllSet();
    }

    @Override
    public int getDimension() {
        return this.m_rect.getDimension();
    }

    @Override
    public Envelope getEnvelope() {
        return this.m_rect.getEnvelope();
    }

    @Override
    public boolean isEmpty() {
        return this.m_rect.isEmpty();
    }

    @Override
    public GeometryType getType() {
        return GeometryType.ELLIPSE;
    }

    @Override
    public boolean contains(DirectPosition dp) {
        return this.asMultiPolygon().contains(dp);
    }

    @Override
    public DirectPosition getRepresentativePoint() throws InvalidGeometryException {
        return this.m_rect.getRepresentativePoint();
    }

    @Override
    public void setRepresentativePoint(DirectPosition dp) {
        this.m_rect.setRepresentativePoint(dp);
    }

    @Override
    public void initializeRepresentativePoint() throws InvalidGeometryException {
        this.m_rect.initializeRepresentativePoint();
    }

    @Override
    public DirectPosition getCenter() {
        return this.m_rect.getEnvelope().getCenter();
    }

    @Override
    public DirectPosition getLowerLeft() {
        return this.m_rect.getLowerLeft();
    }

    @Override
    public DirectPosition getUpperRight() {
        return this.m_rect.getUpperRight();
    }

    @Override
    public Length getXRadius() {
        ComputationType ct = GeometryUtilities.getDefaultComputationType(this.getCoordSys());
        Length width = this.m_rect.getWidth(ct);
        return new Length(width.getValue() / 2.0, width.getUnit(), ct);
    }

    @Override
    public Length getYRadius() {
        ComputationType ct = GeometryUtilities.getDefaultComputationType(this.getCoordSys());
        Length height = this.m_rect.getHeight(ct);
        return new Length(height.getValue() / 2.0, height.getUnit(), ct);
    }

    @Override
    public Area getArea(ComputationType ct) {
        return this.asMultiPolygon().getArea(ct);
    }

    @Override
    public Length getPerimeter(ComputationType ct) {
        return this.asMultiPolygon().getPerimeter(ct);
    }

    @Override
    public LineString asLineString() {
        return this.asLineString(100);
    }

    @Override
    public LineString asLineString(int resolution) {
        resolution = Math.max(4, resolution);
        resolution = Math.min(1048568, resolution);
        DirectPosition c = this.m_rect.getEnvelope().getCenter();
        DirectPosition ll = this.m_rect.getLowerLeft();
        DirectPosition ur = this.m_rect.getUpperRight();
        double a = (ur.getX() - ll.getX()) / 2.0;
        double b = (ur.getY() - ll.getY()) / 2.0;
        double t = Math.PI * 2 / (double)resolution;
        DirectPositionArray dpa = new DirectPositionArray(resolution + 1);
        for (int k = 0; k < resolution; ++k) {
            dpa.add(a * Math.cos((double)k * t) + c.getX(), b * Math.sin((double)k * t) + c.getY());
        }
        dpa.add(dpa.getDirectPosition(0, new DirectPosition()));
        return new LineString(this.getSpatialInfo(), dpa);
    }

    @Override
    public MultiPolygon asMultiPolygon() {
        return this.asMultiPolygon(100);
    }

    @Override
    public MultiPolygon asMultiPolygon(int resolution) {
        LineString ls = this.asLineString(resolution);
        Ring ring = new Ring(this.getSpatialInfo(), ls);
        return new MultiPolygon(this.getSpatialInfo(), ring);
    }

    @Override
    public LegacyEllipse getCopy() {
        return new LegacyEllipse(this.m_rect.getCopy());
    }

    @Override
    public LegacyEllipse getCopy(CoordSys csys) {
        return new LegacyEllipse(this.m_rect.getCopy(csys));
    }
}

