/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.impl;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.GeometryType;
import com.mapinfo.midev.geometry.ILegacyRoundedRectangle;
import com.mapinfo.midev.geometry.InvalidGeometryException;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.impl.FeatureGeometry;
import com.mapinfo.midev.geometry.impl.LineString;
import com.mapinfo.midev.geometry.impl.MultiPolygon;
import com.mapinfo.midev.geometry.impl.Rectangle;
import com.mapinfo.midev.unit.Area;
import com.mapinfo.midev.unit.ComputationType;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.PaperLength;
import com.mapinfo.midev.unit.PaperUnit;
import com.mapinfo.midev.util.ArgumentValidator;

public class LegacyRoundedRectangle
extends FeatureGeometry
implements ILegacyRoundedRectangle {
    private final PaperLength m_cornerRadiusX;
    private final PaperLength m_cornerRadiusY;
    private final Rectangle m_rect;
    public static final int TOTAL_POINTS = 40;
    private static final int NUM_OVAL_POINTS = 10;

    public LegacyRoundedRectangle(SpatialInfo si, DirectPosition ll, DirectPosition ur, PaperLength cornerRadiusX, PaperLength cornerRadiusY) {
        super(si);
        ArgumentValidator.assertNotNullReference((String)"ll", (Object)ll);
        ArgumentValidator.assertNotNullReference((String)"ur", (Object)ur);
        this.m_rect = new Rectangle(si, ll, ur);
        ArgumentValidator.assertNotNullReference((String)"cornerRadiusX", (Object)cornerRadiusX);
        ArgumentValidator.assertNotNullReference((String)"cornerRadiusY", (Object)cornerRadiusY);
        ArgumentValidator.assertNotOutOfRangeMinimum((String)"cornerRadiusX", (double)cornerRadiusX.getValue(), (double)0.0);
        ArgumentValidator.assertNotOutOfRangeMinimum((String)"cornerRadiusY", (double)cornerRadiusY.getValue(), (double)0.0);
        this.m_cornerRadiusX = cornerRadiusX;
        this.m_cornerRadiusY = cornerRadiusY;
    }

    LegacyRoundedRectangle(Rectangle rect, PaperLength cornerRadiusX, PaperLength cornerRadiusY) {
        super(rect.getSpatialInfo());
        ArgumentValidator.assertNotNullReference((String)"rect", (Object)rect);
        this.m_rect = rect;
        ArgumentValidator.assertNotNullReference((String)"cornerRadiusX", (Object)cornerRadiusX);
        ArgumentValidator.assertNotNullReference((String)"cornerRadiusY", (Object)cornerRadiusY);
        ArgumentValidator.assertNotOutOfRangeMinimum((String)"cornerRadiusX", (double)cornerRadiusX.getValue(), (double)0.0);
        ArgumentValidator.assertNotOutOfRangeMinimum((String)"cornerRadiusY", (double)cornerRadiusY.getValue(), (double)0.0);
        this.m_cornerRadiusX = cornerRadiusX;
        this.m_cornerRadiusY = cornerRadiusY;
    }

    LegacyRoundedRectangle(LegacyRoundedRectangle rrect) {
        this(rrect.m_rect.getCopy(), rrect.m_cornerRadiusX, rrect.m_cornerRadiusY);
    }

    @Override
    public boolean zSet() {
        return this.m_rect.zSet();
    }

    @Override
    public boolean zAllSet() {
        return this.m_rect.zAllSet();
    }

    @Override
    public boolean mSet() {
        return this.m_rect.mSet();
    }

    @Override
    public boolean mAllSet() {
        return this.m_rect.mAllSet();
    }

    @Override
    public int getDimension() {
        return this.m_rect.getDimension();
    }

    @Override
    public Envelope getEnvelope() {
        return this.m_rect.getEnvelope();
    }

    @Override
    public boolean isEmpty() {
        return this.m_rect.isEmpty();
    }

    @Override
    public GeometryType getType() {
        return GeometryType.ROUNDED_RECTANGLE;
    }

    @Override
    public boolean contains(DirectPosition dp) {
        ArgumentValidator.assertNotNullReference((String)"dp", (Object)dp);
        return this.m_rect.contains(dp);
    }

    @Override
    public DirectPosition getRepresentativePoint() throws InvalidGeometryException {
        return this.m_rect.getRepresentativePoint();
    }

    @Override
    public void setRepresentativePoint(DirectPosition dp) {
        ArgumentValidator.assertNotNullReference((String)"dp", (Object)dp);
        this.m_rect.setRepresentativePoint(dp);
    }

    @Override
    public void initializeRepresentativePoint() throws InvalidGeometryException {
        this.m_rect.initializeRepresentativePoint();
    }

    @Override
    public DirectPosition getLowerLeft() {
        return this.m_rect.getLowerLeft();
    }

    @Override
    public DirectPosition getUpperRight() {
        return this.m_rect.getUpperRight();
    }

    @Override
    public Length getWidth(ComputationType ct) {
        ArgumentValidator.assertNotNullReference((String)"ct", (Object)ct);
        return this.m_rect.getWidth(ct);
    }

    @Override
    public Length getHeight(ComputationType ct) {
        ArgumentValidator.assertNotNullReference((String)"ct", (Object)ct);
        return this.m_rect.getHeight(ct);
    }

    @Override
    public Area getArea(ComputationType ct) {
        ArgumentValidator.assertNotNullReference((String)"ct", (Object)ct);
        return this.m_rect.getArea(ct);
    }

    @Override
    public Length getPerimeter(ComputationType ct) {
        ArgumentValidator.assertNotNullReference((String)"ct", (Object)ct);
        return this.m_rect.getPerimeter(ct);
    }

    @Override
    public MultiPolygon asMultiPolygon() {
        if (this.m_cornerRadiusX.getValue() == 0.0 || this.m_cornerRadiusY.getValue() == 0.0) {
            return this.m_rect.asMultiPolygon();
        }
        DirectPositionArray dpa = new DirectPositionArray();
        double radX = Math.abs(this.m_cornerRadiusX.getValue(PaperUnit.PIXEL, Integer.valueOf(96)));
        double radY = Math.abs(this.m_cornerRadiusY.getValue(PaperUnit.PIXEL, Integer.valueOf(96)));
        for (int i = 0; i <= 40; ++i) {
            int corner = i * 4 / 40 % 4;
            double ovalCenterX = corner == 0 || corner == 3 ? this.m_rect.getUpperRight().getX() - radX : this.m_rect.getLowerLeft().getX() + radX;
            double ovalCenterY = corner == 0 || corner == 1 ? this.m_rect.getUpperRight().getY() - radY : this.m_rect.getLowerLeft().getY() + radY;
            int ovalPoint = i % 10;
            double angle = Math.toRadians((double)corner * 90.0 + (double)ovalPoint * 90.0 / 9.0);
            dpa.add(ovalCenterX + radX * Math.cos(angle), ovalCenterY + radY * Math.sin(angle));
        }
        return new MultiPolygon(this.getSpatialInfo(), new LineString(this.getSpatialInfo(), dpa));
    }

    @Override
    public Rectangle asRectangle() {
        return this.m_rect;
    }

    @Override
    public PaperLength getCornerRadiusX() {
        return this.m_cornerRadiusX;
    }

    @Override
    public PaperLength getCornerRadiusY() {
        return this.m_cornerRadiusY;
    }

    @Override
    public LegacyRoundedRectangle getCopy() {
        return new LegacyRoundedRectangle(this);
    }

    @Override
    public LegacyRoundedRectangle getCopy(CoordSys csys) {
        ArgumentValidator.assertNotNullReference((String)"csys", (Object)csys);
        Rectangle rect = this.m_rect.getCopy(csys);
        return new LegacyRoundedRectangle(rect, this.m_cornerRadiusX, this.m_cornerRadiusY);
    }
}

