/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.impl;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.transform.CoordTransform;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.GeometryType;
import com.mapinfo.midev.geometry.ILegacyText;
import com.mapinfo.midev.geometry.IRectangle;
import com.mapinfo.midev.geometry.impl.FeatureGeometry;
import com.mapinfo.midev.unit.Angle;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.Area;
import com.mapinfo.midev.unit.AreaUnit;
import com.mapinfo.midev.unit.ComputationType;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;

public class LegacyText
extends FeatureGeometry
implements ILegacyText {
    private static final Angle ANGLE_ZERO = new Angle(0.0, AngularUnit.DEGREE);
    private final IRectangle m_rect;
    private final String m_text;
    private final Angle m_textAngle;
    private final ILegacyText.TextCalloutType m_type;
    private final DirectPosition m_target;
    private double m_height;
    private double m_lineSpacing;
    private ILegacyText.Justification m_justification;
    private ILegacyText.VerticalAlignment m_verticalAlignment;

    public LegacyText(IRectangle rect, String text) {
        this(rect, text, ANGLE_ZERO, ILegacyText.TextCalloutType.NONE, null);
    }

    public LegacyText(IRectangle rect, String text, Angle angle) {
        this(rect, text, angle, ILegacyText.TextCalloutType.NONE, null);
    }

    public LegacyText(IRectangle rect, String text, Angle angle, ILegacyText.TextCalloutType type, DirectPosition target) {
        super(rect.getSpatialInfo());
        this.m_rect = rect;
        this.m_text = text;
        this.m_textAngle = angle;
        this.m_type = type;
        this.m_target = target;
    }

    private LegacyText(IRectangle rect, String text, Angle angle, ILegacyText.TextCalloutType type, DirectPosition target, double height, double lineSpacing, ILegacyText.Justification justification, ILegacyText.VerticalAlignment verticalAlignment) {
        this(rect, text, angle, type, target);
        this.m_height = height;
        this.m_lineSpacing = lineSpacing;
        this.m_justification = justification;
        this.m_verticalAlignment = verticalAlignment;
    }

    @Override
    public IRectangle getRectangle() {
        return this.m_rect.getCopy();
    }

    @Override
    public String getText() {
        return this.m_text;
    }

    @Override
    public Angle getAngle() {
        return this.m_textAngle;
    }

    @Override
    public ILegacyText.TextCalloutType getTextCalloutType() {
        return this.m_type;
    }

    @Override
    public boolean hasCalloutTarget() {
        return this.m_target != null;
    }

    @Override
    public DirectPosition getCalloutTarget() {
        return this.m_target;
    }

    @Override
    public boolean zSet() {
        return this.m_rect.zSet();
    }

    @Override
    public boolean zAllSet() {
        return this.m_rect.zAllSet();
    }

    @Override
    public boolean mSet() {
        return this.m_rect.mSet();
    }

    @Override
    public boolean mAllSet() {
        return this.m_rect.mAllSet();
    }

    @Override
    public int getDimension() {
        return 0;
    }

    @Override
    public Envelope getEnvelope() {
        Envelope env = this.m_rect.getEnvelope();
        if (this.m_target != null) {
            env.extend(this.m_target);
        }
        return env;
    }

    @Override
    public boolean isEmpty() {
        return this.m_rect.isEmpty();
    }

    @Override
    public GeometryType getType() {
        return GeometryType.LEGACY_TEXT;
    }

    @Override
    public boolean contains(DirectPosition dp) {
        return this.getEnvelope().contains(dp);
    }

    @Override
    public LegacyText getCopy() {
        DirectPosition newTarget = this.m_target == null ? null : this.m_target.getCopy();
        return new LegacyText(this.m_rect.getCopy(), this.m_text, this.m_textAngle, this.m_type, newTarget, this.m_height, this.m_lineSpacing, this.m_justification, this.m_verticalAlignment);
    }

    @Override
    public LegacyText getCopy(CoordSys csys) {
        DirectPosition newTarget = null;
        if (this.m_target != null) {
            CoordTransform dpXform = this.getCoordSys().createCoordTransform(csys);
            newTarget = dpXform.transform(this.m_target, new DirectPosition());
        }
        return new LegacyText(this.m_rect.getCopy(csys), this.m_text, this.m_textAngle, this.m_type, newTarget, this.m_height, this.m_lineSpacing, this.m_justification, this.m_verticalAlignment);
    }

    @Override
    public DirectPosition getRepresentativePoint() {
        return this.m_rect.getRepresentativePoint();
    }

    @Override
    public void setRepresentativePoint(DirectPosition dp) {
        this.m_rect.setRepresentativePoint(dp);
    }

    @Override
    public void initializeRepresentativePoint() {
        this.m_rect.initializeRepresentativePoint();
    }

    @Override
    public Area getArea(ComputationType ct) {
        return new Area(0.0, AreaUnit.SQUARE_METER, ct);
    }

    @Override
    public Length getPerimeter(ComputationType ct) {
        return new Length(0.0, LinearUnit.METER);
    }

    @Override
    public Double getHeight() {
        return this.m_height;
    }

    public void setHeight(Double height) {
        this.m_height = height;
    }

    @Override
    public double getLineSpacing() {
        return this.m_lineSpacing;
    }

    public void setLineSpacing(double lineSpacing) {
        this.m_lineSpacing = lineSpacing;
    }

    @Override
    public ILegacyText.Justification getJustification() {
        return this.m_justification;
    }

    public void setJustification(ILegacyText.Justification justification) {
        this.m_justification = justification;
    }

    @Override
    public ILegacyText.VerticalAlignment getVerticalAlignment() {
        return this.m_verticalAlignment;
    }

    public void setVerticalAlignment(ILegacyText.VerticalAlignment verticalAlignment) {
        this.m_verticalAlignment = verticalAlignment;
    }
}

