/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.impl;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.CurveInterpolationType;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.GeometryType;
import com.mapinfo.midev.geometry.ICurveSegment;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.IDirectPositionMutator;
import com.mapinfo.midev.geometry.ILineString;
import com.mapinfo.midev.geometry.InvalidComputationTypeException;
import com.mapinfo.midev.geometry.MeasurementUtilities;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.CurveSegment;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.operations.cartesian.intersects.LineIntersectsPoint;
import com.mapinfo.midev.unit.Area;
import com.mapinfo.midev.unit.AreaUnit;
import com.mapinfo.midev.unit.ComputationType;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;

public class LineString
extends CurveSegment
implements ILineString {
    private Length m_sphericalLength = null;
    private Length m_cartesianLength = null;

    public LineString(SpatialInfo si, IDirectPositionList dpa) {
        super(si, dpa);
    }

    public LineString(SpatialInfo spatialInfo, IDirectPositionList ptList, Envelope bounds) {
        super(spatialInfo, ptList, bounds);
    }

    @Override
    public Length getLength(ComputationType ct) {
        Length len;
        switch (ct) {
            case SPHERICAL: {
                len = this.m_sphericalLength == null ? (this.m_sphericalLength = MeasurementUtilities.length((ICurveSegment)this, ct)) : this.m_sphericalLength;
                break;
            }
            case CARTESIAN: {
                len = this.m_cartesianLength == null ? (this.m_cartesianLength = MeasurementUtilities.length((ICurveSegment)this, ct)) : this.m_cartesianLength;
                break;
            }
            default: {
                throw new InvalidComputationTypeException(ct);
            }
        }
        return len;
    }

    @Override
    public LineString getCopy() {
        return this.getCopy(this.getCoordSys());
    }

    @Override
    public LineString getCopy(CoordSys csys) {
        Envelope bounds;
        SpatialInfo si = this.getSpatialInfo();
        DirectPositionArray dpa = new DirectPositionArray(this.getControlPoints());
        if (!csys.equivalent(this.getCoordSys())) {
            dpa.change((IDirectPositionMutator)this.getCoordSys().createCoordTransform(csys));
            si = new SpatialInfo(csys, this.getSpatialInfo().getZUnit(), this.getSpatialInfo().getToleranceLength());
            bounds = null;
        } else {
            bounds = this.getEnvelope();
        }
        return new LineString(si, dpa, bounds);
    }

    @Override
    public Length getStartDistance(ComputationType ct) {
        Length len;
        ICurveSegment cs = this.getLeftSibling();
        if (cs != null) {
            len = cs.getEndDistance(ct);
        } else {
            LinearUnit lu = CoordSysUtilities.getLinearUnit((CoordSys)this.getCoordSys());
            if (lu == null) {
                lu = LinearUnit.METER;
            }
            len = new Length(0.0, lu, ct);
        }
        return len;
    }

    @Override
    public Length getEndDistance(ComputationType ct) {
        LinearUnit lu = CoordSysUtilities.getLinearUnit((CoordSys)this.getCoordSys());
        if (lu == null) {
            lu = LinearUnit.METER;
        }
        double distance = this.getStartDistance(ct).getValue(lu);
        return new Length(distance += this.getLength(ct).getValue(lu), lu, ct);
    }

    @Override
    public DirectPosition getPointForDistance(Length len) {
        return MeasurementUtilities.getPointAtDistance((ICurveSegment)this, len);
    }

    @Override
    public LineString asLineString() {
        return new LineString(this.getSpatialInfo(), new DirectPositionArray(this.getControlPoints()));
    }

    @Override
    public LineString asLineString(Length maxSpacing, Length maxOffset) {
        return this.asLineString();
    }

    @Override
    public LineString reverse() {
        return new LineString(this.getSpatialInfo(), this.getControlPoints().reverse());
    }

    @Override
    public CurveInterpolationType getInterpolationType() {
        return CurveInterpolationType.LINEAR;
    }

    @Override
    public GeometryType getType() {
        return GeometryType.LINE_STRING;
    }

    @Override
    public boolean isLinear() {
        return true;
    }

    @Override
    public boolean contains(DirectPosition dp) {
        return LineIntersectsPoint.intersects(this, dp);
    }

    @Override
    public Area getArea(ComputationType ct) {
        return new Area(0.0, AreaUnit.SQUARE_METER, ct);
    }

    @Override
    public Length getPerimeter(ComputationType ct) {
        return new Length(0.0, LinearUnit.METER, ct);
    }

    @Override
    public boolean isTransient() {
        return false;
    }
}

