/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.impl;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.transform.CoordTransform;
import com.mapinfo.midev.geometry.CentroidUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.GeometryType;
import com.mapinfo.midev.geometry.ICurve;
import com.mapinfo.midev.geometry.IMultiCurve;
import com.mapinfo.midev.geometry.InvalidComputationTypeException;
import com.mapinfo.midev.geometry.InvalidGeometryException;
import com.mapinfo.midev.geometry.InvalidGeometryOperationException;
import com.mapinfo.midev.geometry.MeasurementUtilities;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.Curve;
import com.mapinfo.midev.geometry.impl.CurveSegment;
import com.mapinfo.midev.geometry.impl.FeatureGeometry;
import com.mapinfo.midev.unit.Area;
import com.mapinfo.midev.unit.AreaUnit;
import com.mapinfo.midev.unit.ComputationType;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class MultiCurve
extends FeatureGeometry
implements IMultiCurve {
    private final List<Curve> m_curveList;
    private DirectPosition m_representativePoint = null;
    private Length m_sphericalLength = null;
    private Length m_cartesianLength = null;
    private Envelope m_envelope = null;

    public MultiCurve(SpatialInfo si) {
        super(si);
        this.m_curveList = Collections.emptyList();
    }

    public MultiCurve(SpatialInfo si, CurveSegment seg) {
        this(si, new Curve(si, seg));
    }

    public MultiCurve(SpatialInfo si, Curve curve) {
        super(si);
        this.m_curveList = Collections.singletonList(curve);
    }

    public MultiCurve(SpatialInfo si, List<Curve> curveList) {
        super(si);
        this.m_curveList = curveList;
    }

    public MultiCurve(SpatialInfo si, List<Curve> curveList, DirectPosition rp) {
        this(si, curveList);
        if (!this.isEmpty()) {
            this.m_representativePoint = rp;
        }
    }

    @Override
    public Length getLength(ComputationType ct) {
        Length len;
        switch (ct) {
            case SPHERICAL: {
                len = this.m_sphericalLength == null ? (this.m_sphericalLength = MeasurementUtilities.length(this, ct)) : this.m_sphericalLength;
                break;
            }
            case CARTESIAN: {
                len = this.m_cartesianLength == null ? (this.m_cartesianLength = MeasurementUtilities.length(this, ct)) : this.m_cartesianLength;
                break;
            }
            default: {
                throw new InvalidComputationTypeException(ct);
            }
        }
        return len;
    }

    @Override
    public Iterator<ICurve> iterator() {
        return new _CurveIterator(this.m_curveList.iterator());
    }

    @Override
    public int getCurveCount() {
        return this.m_curveList.size();
    }

    @Override
    public MultiCurve getCopy() {
        ArrayList<Curve> newCurveList = new ArrayList<Curve>(this.getCurveCount());
        for (Curve c : this.m_curveList) {
            newCurveList.add(c.getCopy());
        }
        MultiCurve mc = this.m_representativePoint == null ? new MultiCurve(this.getSpatialInfo(), newCurveList) : new MultiCurve(this.getSpatialInfo(), newCurveList, this.m_representativePoint);
        return mc;
    }

    @Override
    public MultiCurve getCopy(CoordSys csys) {
        ArrayList<Curve> newCurveList = new ArrayList<Curve>(this.getCurveCount());
        for (Curve c : this.m_curveList) {
            newCurveList.add(c.getCopy(csys));
        }
        SpatialInfo si = new SpatialInfo(csys, this.getSpatialInfo().getZUnit(), this.getSpatialInfo().getToleranceLength());
        MultiCurve mc = new MultiCurve(si, newCurveList);
        if (this.m_representativePoint != null) {
            CoordTransform dpXform = this.getCoordSys().createCoordTransform(csys);
            mc.m_representativePoint = dpXform.transform(this.m_representativePoint, new DirectPosition());
        }
        return mc;
    }

    @Override
    public DirectPosition getRepresentativePoint() throws InvalidGeometryException {
        if (this.isEmpty()) {
            throw new InvalidGeometryException("Cannot get representative point of an empty geometry.");
        }
        if (this.m_representativePoint == null) {
            this.initializeRepresentativePoint();
        }
        return this.m_representativePoint.getCopy();
    }

    @Override
    public void setRepresentativePoint(DirectPosition dp) throws InvalidGeometryException, InvalidGeometryOperationException {
        if (this.isEmpty()) {
            throw new InvalidGeometryException("Cannot set representative point of an empty geometry.");
        }
        if (!this.contains(dp)) {
            throw new InvalidGeometryOperationException("The direct position (" + dp + ") is not contained by this geometry");
        }
        if (this.m_representativePoint == null) {
            this.m_representativePoint = dp.getCopy();
        } else {
            this.m_representativePoint.set(dp);
        }
    }

    @Override
    public void initializeRepresentativePoint() throws InvalidGeometryException {
        if (this.isEmpty()) {
            throw new InvalidGeometryException("Cannot initialize representative point of an empty geometry.");
        }
        if (this.m_representativePoint == null) {
            this.m_representativePoint = CentroidUtilities.calculateCentroid(this);
        } else {
            this.m_representativePoint.set(CentroidUtilities.calculateCentroid(this));
        }
    }

    @Override
    public boolean zSet() {
        if (this.isEmpty()) {
            return false;
        }
        boolean bZSet = false;
        Iterator<ICurve> iter = this.iterator();
        while (iter.hasNext() && !bZSet) {
            bZSet = iter.next().zSet();
        }
        return bZSet;
    }

    @Override
    public boolean zAllSet() {
        if (this.isEmpty()) {
            return false;
        }
        boolean bZAllSet = true;
        Iterator<ICurve> iter = this.iterator();
        while (iter.hasNext() && bZAllSet) {
            bZAllSet = iter.next().zAllSet();
        }
        return bZAllSet;
    }

    @Override
    public boolean mSet() {
        if (this.isEmpty()) {
            return false;
        }
        boolean bMSet = false;
        Iterator<ICurve> iter = this.iterator();
        while (iter.hasNext() && !bMSet) {
            bMSet = iter.next().mSet();
        }
        return bMSet;
    }

    @Override
    public boolean mAllSet() {
        if (this.isEmpty()) {
            return false;
        }
        boolean bMAllSet = true;
        Iterator<ICurve> iter = this.iterator();
        while (iter.hasNext() && bMAllSet) {
            bMAllSet = iter.next().mAllSet();
        }
        return bMAllSet;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public Envelope getEnvelope() {
        if (this.m_envelope == null) {
            this.m_envelope = new Envelope(this.getSpatialInfo());
            for (ICurve c : this) {
                this.m_envelope.extend(c.getEnvelope());
            }
        }
        return this.m_envelope.getCopy();
    }

    @Override
    public boolean isEmpty() {
        return this.m_curveList.isEmpty();
    }

    @Override
    public GeometryType getType() {
        return GeometryType.MULTI_CURVE;
    }

    @Override
    public boolean contains(DirectPosition dp) {
        if (this.isEmpty()) {
            return false;
        }
        boolean bContains = false;
        Iterator<ICurve> iter = this.iterator();
        while (iter.hasNext() && !bContains) {
            bContains = iter.next().contains(dp);
        }
        return bContains;
    }

    @Override
    public Area getArea(ComputationType ct) {
        return new Area(0.0, AreaUnit.SQUARE_METER, ct);
    }

    @Override
    public Length getPerimeter(ComputationType ct) {
        return new Length(0.0, LinearUnit.METER, ct);
    }

    private static class _CurveIterator
    implements Iterator<ICurve> {
        private final Iterator<Curve> m_iter;

        private _CurveIterator(Iterator<Curve> iter) {
            this.m_iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.m_iter.hasNext();
        }

        @Override
        public ICurve next() {
            return this.m_iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

