/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.impl;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.transform.CoordTransform;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.GeometryType;
import com.mapinfo.midev.geometry.ICurve;
import com.mapinfo.midev.geometry.IFeatureGeometry;
import com.mapinfo.midev.geometry.IMultiCurve;
import com.mapinfo.midev.geometry.IMultiFeatureGeometry;
import com.mapinfo.midev.geometry.IMultiPoint;
import com.mapinfo.midev.geometry.IMultiPolygon;
import com.mapinfo.midev.geometry.IPoint;
import com.mapinfo.midev.geometry.IPolygon;
import com.mapinfo.midev.geometry.InvalidGeometryException;
import com.mapinfo.midev.geometry.InvalidGeometryOperationException;
import com.mapinfo.midev.geometry.InvalidGeometryTypeException;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.Curve;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.impl.FeatureGeometry;
import com.mapinfo.midev.geometry.impl.MultiCurve;
import com.mapinfo.midev.geometry.impl.MultiPoint;
import com.mapinfo.midev.geometry.impl.MultiPolygon;
import com.mapinfo.midev.geometry.impl.Point;
import com.mapinfo.midev.geometry.impl.Polygon;
import com.mapinfo.midev.unit.Area;
import com.mapinfo.midev.unit.ComputationType;
import com.mapinfo.midev.unit.Length;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;

public class MultiFeatureGeometry
extends FeatureGeometry
implements IMultiFeatureGeometry {
    private final List<Point> m_pointList;
    private final List<MultiPoint> m_multiPointList;
    private final List<MultiCurve> m_multiCurveList;
    private final List<MultiPolygon> m_multiPolygonList;
    private DirectPosition m_representativePoint = null;
    private Envelope m_envelope = null;

    public MultiFeatureGeometry(SpatialInfo si) {
        this(si, new ArrayList<Point>(), new ArrayList<MultiPoint>(), new ArrayList<MultiCurve>(), new ArrayList<MultiPolygon>());
    }

    public MultiFeatureGeometry(SpatialInfo si, FeatureGeometry fg) {
        this(si);
        this.add(fg);
    }

    public MultiFeatureGeometry(SpatialInfo si, List<FeatureGeometry> fgList) {
        this(si);
        for (FeatureGeometry fg : fgList) {
            this.add(fg);
        }
    }

    public MultiFeatureGeometry(SpatialInfo si, List<Point> points, List<MultiPoint> multiPoints, List<MultiCurve> multiCurves, List<MultiPolygon> multiPolygons) {
        super(si);
        this.m_pointList = points;
        this.m_multiPointList = multiPoints;
        this.m_multiCurveList = multiCurves;
        this.m_multiPolygonList = multiPolygons;
    }

    private void add(FeatureGeometry fg) {
        if (fg.isEmpty()) {
            return;
        }
        switch (fg.getType()) {
            case POINT: {
                this.m_pointList.add((Point)fg);
                break;
            }
            case MULTI_POINT: {
                this.m_multiPointList.add((MultiPoint)fg);
                break;
            }
            case MULTI_CURVE: {
                this.m_multiCurveList.add((MultiCurve)fg);
                break;
            }
            case MULTI_POLYGON: {
                this.m_multiPolygonList.add((MultiPolygon)fg);
                break;
            }
            default: {
                throw new InvalidGeometryTypeException(fg.getType());
            }
        }
    }

    @Override
    public Iterator<IFeatureGeometry> iterator() {
        return new _FeatureGeometryIterator(this.getPointIterator(), this.getMultiPointIterator(), this.getMultiCurveIterator(), this.getMultiPolygonIterator());
    }

    @Override
    public int getFeatureGeometryCount() {
        return this.m_pointList.size() + this.m_multiPointList.size() + this.m_multiCurveList.size() + this.m_multiPolygonList.size();
    }

    @Override
    public MultiPoint getAllPoints() {
        DirectPositionArray dpa = new DirectPositionArray();
        for (Point p : this.m_pointList) {
            dpa.add(p.getDirectPosition());
        }
        for (MultiPoint mp : this.m_multiPointList) {
            dpa.addAll(mp.getPositions());
        }
        return new MultiPoint(this.getSpatialInfo(), dpa);
    }

    @Override
    public MultiCurve getAllCurves() {
        ArrayList<Curve> curveList = new ArrayList<Curve>(this.m_multiCurveList.size());
        for (MultiCurve mc : this.m_multiCurveList) {
            for (ICurve c : mc) {
                curveList.add((Curve)c.getCopy());
            }
        }
        return new MultiCurve(this.getSpatialInfo(), curveList);
    }

    @Override
    public MultiPolygon getAllPolygons() {
        ArrayList<Polygon> polygonList = new ArrayList<Polygon>(this.m_multiPolygonList.size());
        for (MultiPolygon mp : this.m_multiPolygonList) {
            for (IPolygon p : mp) {
                polygonList.add((Polygon)p.getCopy());
            }
        }
        return new MultiPolygon(this.getSpatialInfo(), polygonList);
    }

    @Override
    public int getCount(GeometryType gtype) {
        int count;
        switch (gtype) {
            case POINT: {
                count = this.m_pointList.size();
                break;
            }
            case MULTI_POINT: {
                count = this.m_multiPointList.size();
                break;
            }
            case MULTI_CURVE: {
                count = this.m_multiCurveList.size();
                break;
            }
            case MULTI_POLYGON: {
                count = this.m_multiPolygonList.size();
                break;
            }
            default: {
                throw new InvalidGeometryTypeException(gtype);
            }
        }
        return count;
    }

    @Override
    public Iterator<IPoint> getPointIterator() {
        return new _PointIterator(this.m_pointList.iterator());
    }

    @Override
    public Iterator<IMultiPoint> getMultiPointIterator() {
        return new _MultiPointIterator(this.m_multiPointList.iterator());
    }

    @Override
    public Iterator<IMultiCurve> getMultiCurveIterator() {
        return new _MultiCurveIterator(this.m_multiCurveList.iterator());
    }

    @Override
    public Iterator<IMultiPolygon> getMultiPolygonIterator() {
        return new _MultiPolygonIterator(this.m_multiPolygonList.iterator());
    }

    @Override
    public MultiFeatureGeometry getCopy() {
        ArrayList<Point> pointCopyList = new ArrayList<Point>(this.m_pointList.size());
        ArrayList<MultiPoint> multiPointCopyList = new ArrayList<MultiPoint>(this.m_multiPointList.size());
        ArrayList<MultiCurve> multiCurveCopyList = new ArrayList<MultiCurve>(this.m_multiCurveList.size());
        ArrayList<MultiPolygon> multiPolygonCopyList = new ArrayList<MultiPolygon>(this.m_multiPolygonList.size());
        for (Point p : this.m_pointList) {
            pointCopyList.add(p.getCopy());
        }
        for (MultiPoint mp : this.m_multiPointList) {
            multiPointCopyList.add(mp.getCopy());
        }
        for (MultiCurve mc : this.m_multiCurveList) {
            multiCurveCopyList.add(mc.getCopy());
        }
        for (MultiPolygon mpg : this.m_multiPolygonList) {
            multiPolygonCopyList.add(mpg.getCopy());
        }
        MultiFeatureGeometry mfg = new MultiFeatureGeometry(this.getSpatialInfo(), pointCopyList, multiPointCopyList, multiCurveCopyList, multiPolygonCopyList);
        if (this.m_representativePoint != null) {
            mfg.m_representativePoint = new DirectPosition(this.m_representativePoint);
        }
        return mfg;
    }

    @Override
    public MultiFeatureGeometry getCopy(CoordSys csys) {
        ArrayList<Point> pointCopyList = new ArrayList<Point>(this.m_pointList.size());
        ArrayList<MultiPoint> multiPointCopyList = new ArrayList<MultiPoint>(this.m_multiPointList.size());
        ArrayList<MultiCurve> multiCurveCopyList = new ArrayList<MultiCurve>(this.m_multiCurveList.size());
        ArrayList<MultiPolygon> multiPolygonCopyList = new ArrayList<MultiPolygon>(this.m_multiPolygonList.size());
        for (Point p : this.m_pointList) {
            pointCopyList.add(p.getCopy(csys));
        }
        for (MultiPoint mp : this.m_multiPointList) {
            multiPointCopyList.add(mp.getCopy(csys));
        }
        for (MultiCurve mc : this.m_multiCurveList) {
            multiCurveCopyList.add(mc.getCopy(csys));
        }
        for (MultiPolygon mpg : this.m_multiPolygonList) {
            multiPolygonCopyList.add(mpg.getCopy(csys));
        }
        SpatialInfo si = new SpatialInfo(csys, this.getSpatialInfo().getZUnit(), this.getSpatialInfo().getToleranceLength());
        MultiFeatureGeometry mfg = new MultiFeatureGeometry(si, pointCopyList, multiPointCopyList, multiCurveCopyList, multiPolygonCopyList);
        if (this.m_representativePoint != null) {
            CoordTransform dpXform = this.getCoordSys().createCoordTransform(csys);
            mfg.m_representativePoint = dpXform.transform(this.m_representativePoint, new DirectPosition());
        }
        return mfg;
    }

    @Override
    public DirectPosition getRepresentativePoint() throws InvalidGeometryException {
        if (this.isEmpty()) {
            throw new InvalidGeometryException("Cannot get representative point of an empty geometry.");
        }
        if (this.m_representativePoint == null) {
            this.initializeRepresentativePoint();
        }
        return this.m_representativePoint.getCopy();
    }

    @Override
    public void setRepresentativePoint(DirectPosition dp) throws InvalidGeometryException, InvalidGeometryOperationException {
        if (this.isEmpty()) {
            throw new InvalidGeometryException("Cannot set representative point of an empty geometry.");
        }
        if (!this.contains(dp)) {
            throw new InvalidGeometryOperationException("The direct position (" + dp + ") is not contained by this geometry.");
        }
        if (this.m_representativePoint == null) {
            this.m_representativePoint = new DirectPosition(dp);
        } else {
            this.m_representativePoint.set(dp);
        }
    }

    @Override
    public void initializeRepresentativePoint() throws InvalidGeometryException {
        if (this.isEmpty()) {
            throw new InvalidGeometryException("Cannot initialize representative point of an empty geometry.");
        }
        DirectPosition dp = null;
        Iterator<IMultiPolygon> mpolyIter = this.getMultiPolygonIterator();
        while (mpolyIter.hasNext() && dp == null) {
            IMultiPolygon mpoly = mpolyIter.next();
            if (mpoly.isEmpty()) continue;
            dp = mpoly.getRepresentativePoint();
        }
        Iterator<IMultiCurve> mcIter = this.getMultiCurveIterator();
        while (mcIter.hasNext() && dp == null) {
            IMultiCurve mc = mcIter.next();
            if (mc.isEmpty()) continue;
            dp = mc.getRepresentativePoint();
        }
        Iterator<IMultiPoint> mpIter = this.getMultiPointIterator();
        while (mpIter.hasNext() && dp == null) {
            IMultiPoint mp = mpIter.next();
            if (mp.isEmpty()) continue;
            dp = mp.getRepresentativePoint();
        }
        Iterator<IPoint> pIter = this.getPointIterator();
        while (pIter.hasNext() && dp == null) {
            dp = pIter.next().getDirectPosition();
        }
        if (dp == null) {
            throw new InvalidGeometryException("Cannot initialize representative point, geometry contains no direct positions.");
        }
        this.m_representativePoint = dp;
    }

    @Override
    public boolean zSet() {
        if (this.isEmpty()) {
            return false;
        }
        boolean bZSet = false;
        Iterator<IFeatureGeometry> fgIter = this.iterator();
        while (fgIter.hasNext() && !bZSet) {
            bZSet = fgIter.next().zSet();
        }
        return bZSet;
    }

    @Override
    public boolean zAllSet() {
        if (this.isEmpty()) {
            return false;
        }
        boolean bZAllSet = true;
        Iterator<IFeatureGeometry> fgIter = this.iterator();
        while (fgIter.hasNext() && bZAllSet) {
            bZAllSet = fgIter.next().zAllSet();
        }
        return bZAllSet;
    }

    @Override
    public boolean mSet() {
        if (this.isEmpty()) {
            return false;
        }
        boolean bMSet = false;
        Iterator<IFeatureGeometry> fgIter = this.iterator();
        while (fgIter.hasNext() && !bMSet) {
            bMSet = fgIter.next().mSet();
        }
        return bMSet;
    }

    @Override
    public boolean mAllSet() {
        if (this.isEmpty()) {
            return false;
        }
        boolean bMAllSet = true;
        Iterator<IFeatureGeometry> fgIter = this.iterator();
        while (fgIter.hasNext() && bMAllSet) {
            bMAllSet = fgIter.next().mAllSet();
        }
        return bMAllSet;
    }

    @Override
    public int getDimension() {
        int dim = 0;
        if (this.getCount(GeometryType.MULTI_POLYGON) != 0) {
            dim = 2;
        } else if (this.getCount(GeometryType.MULTI_CURVE) != 0) {
            dim = 1;
        }
        return dim;
    }

    @Override
    public Envelope getEnvelope() {
        if (this.m_envelope == null) {
            this.m_envelope = new Envelope(this.getSpatialInfo());
            for (IFeatureGeometry fg : this) {
                this.m_envelope.extend(fg.getEnvelope());
            }
        }
        return this.m_envelope.getCopy();
    }

    @Override
    public boolean isEmpty() {
        boolean bEmpty = true;
        Iterator<IFeatureGeometry> fgIter = this.iterator();
        while (fgIter.hasNext() && bEmpty) {
            bEmpty = fgIter.next().isEmpty();
        }
        return bEmpty;
    }

    @Override
    public GeometryType getType() {
        return GeometryType.MULTI_FEATURE_GEOMETRY;
    }

    @Override
    public boolean contains(DirectPosition dp) {
        boolean bContains = false;
        Iterator<IFeatureGeometry> fgIter = this.iterator();
        while (fgIter.hasNext() && !bContains) {
            bContains = fgIter.next().contains(dp);
        }
        return bContains;
    }

    @Override
    public Area getArea(ComputationType ct) {
        return this.getAllPolygons().getArea(ct);
    }

    @Override
    public Length getPerimeter(ComputationType ct) {
        return this.getAllPolygons().getPerimeter(ct);
    }

    private static class _MultiPolygonIterator
    implements Iterator<IMultiPolygon> {
        private final Iterator<MultiPolygon> m_iter;

        private _MultiPolygonIterator(Iterator<MultiPolygon> iter) {
            this.m_iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.m_iter.hasNext();
        }

        @Override
        public IMultiPolygon next() {
            return this.m_iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class _MultiCurveIterator
    implements Iterator<IMultiCurve> {
        private final Iterator<MultiCurve> m_iter;

        private _MultiCurveIterator(Iterator<MultiCurve> iter) {
            this.m_iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.m_iter.hasNext();
        }

        @Override
        public IMultiCurve next() {
            return this.m_iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class _MultiPointIterator
    implements Iterator<IMultiPoint> {
        private final Iterator<MultiPoint> m_iter;

        private _MultiPointIterator(Iterator<MultiPoint> iter) {
            this.m_iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.m_iter.hasNext();
        }

        @Override
        public IMultiPoint next() {
            return this.m_iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class _PointIterator
    implements Iterator<IPoint> {
        private final Iterator<Point> m_iter;

        private _PointIterator(Iterator<Point> iter) {
            this.m_iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.m_iter.hasNext();
        }

        @Override
        public IPoint next() {
            return this.m_iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class _FeatureGeometryIterator
    implements Iterator<IFeatureGeometry> {
        private final Iterator<IPoint> m_pointIter;
        private final Iterator<IMultiPoint> m_multiPointIter;
        private final Iterator<IMultiCurve> m_multiCurveIter;
        private final Iterator<IMultiPolygon> m_multiPolygonIter;

        public _FeatureGeometryIterator(Iterator<IPoint> pointIter, Iterator<IMultiPoint> multiPointIter, Iterator<IMultiCurve> multiCurveIter, Iterator<IMultiPolygon> multiPolygonIter) {
            this.m_pointIter = pointIter;
            this.m_multiPointIter = multiPointIter;
            this.m_multiCurveIter = multiCurveIter;
            this.m_multiPolygonIter = multiPolygonIter;
        }

        @Override
        public boolean hasNext() {
            return this.m_pointIter.hasNext() || this.m_multiPointIter.hasNext() || this.m_multiCurveIter.hasNext() || this.m_multiPolygonIter.hasNext();
        }

        @Override
        public IFeatureGeometry next() throws ConcurrentModificationException {
            IFeatureGeometry fg = this.m_pointIter.hasNext() ? (IFeatureGeometry)this.m_pointIter.next() : (this.m_multiPointIter.hasNext() ? (IFeatureGeometry)this.m_multiPointIter.next() : (this.m_multiCurveIter.hasNext() ? (IFeatureGeometry)this.m_multiCurveIter.next() : (IFeatureGeometry)this.m_multiPolygonIter.next()));
            return fg;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

