/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.impl;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.GeometryType;
import com.mapinfo.midev.geometry.IPolygon;
import com.mapinfo.midev.geometry.IRing;
import com.mapinfo.midev.geometry.InvalidComputationTypeException;
import com.mapinfo.midev.geometry.MeasurementUtilities;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.Ring;
import com.mapinfo.midev.geometry.operations.cartesian.contains.CartesianContains;
import com.mapinfo.midev.unit.Area;
import com.mapinfo.midev.unit.ComputationType;
import com.mapinfo.midev.unit.Length;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Polygon
implements IPolygon {
    private final Ring m_outerRing;
    private final List<Ring> m_innerRings;
    private final SpatialInfo m_spatialInfo;
    private Length m_sphericalPerimeter = null;
    private Length m_cartesianPerimeter = null;
    private Area m_sphericalArea = null;
    private Area m_cartesianArea = null;

    public Polygon(SpatialInfo si, Ring outerRing) {
        this(si, outerRing, Collections.emptyList());
    }

    public Polygon(SpatialInfo si, Ring outerRing, List<Ring> innerRings) {
        this.m_spatialInfo = si;
        this.m_outerRing = outerRing;
        this.m_innerRings = innerRings;
    }

    @Override
    public Polygon getCopy() {
        return this.getCopy(this.getSpatialInfo().getCoordSys());
    }

    @Override
    public Polygon getCopy(CoordSys csys) {
        ArrayList<Ring> newInnerRings = new ArrayList<Ring>(this.getInteriorRingCount());
        for (Ring r : this.m_innerRings) {
            newInnerRings.add(r.getCopy(csys));
        }
        SpatialInfo si = this.getSpatialInfo();
        if (!csys.equivalent(si.getCoordSys())) {
            si = new SpatialInfo(csys, this.getSpatialInfo().getZUnit(), this.getSpatialInfo().getToleranceLength());
        }
        return new Polygon(si, this.m_outerRing.getCopy(csys), newInnerRings);
    }

    @Override
    public boolean contains(DirectPosition dp) {
        return CartesianContains.contains(this, dp);
    }

    @Override
    public Area getArea(ComputationType ct) {
        Area area;
        switch (ct) {
            case SPHERICAL: {
                area = this.m_sphericalArea == null ? (this.m_sphericalArea = MeasurementUtilities.area(this, ct)) : this.m_sphericalArea;
                break;
            }
            case CARTESIAN: {
                area = this.m_cartesianArea == null ? (this.m_cartesianArea = MeasurementUtilities.area(this, ct)) : this.m_cartesianArea;
                break;
            }
            default: {
                throw new InvalidComputationTypeException(ct);
            }
        }
        return area;
    }

    @Override
    public Ring getExteriorRing() {
        return this.m_outerRing;
    }

    @Override
    public Iterator<IRing> getInteriorRingIterator() {
        return new _RingIterator(this.m_innerRings.iterator());
    }

    @Override
    public int getInteriorRingCount() {
        return this.m_innerRings.size();
    }

    @Override
    public Length getPerimeter(ComputationType ct) {
        Length len;
        switch (ct) {
            case SPHERICAL: {
                len = this.m_sphericalPerimeter == null ? (this.m_sphericalPerimeter = MeasurementUtilities.perimeter(this, ct)) : this.m_sphericalPerimeter;
                break;
            }
            case CARTESIAN: {
                len = this.m_cartesianPerimeter == null ? (this.m_cartesianPerimeter = MeasurementUtilities.perimeter(this, ct)) : this.m_cartesianPerimeter;
                break;
            }
            default: {
                throw new InvalidComputationTypeException(ct);
            }
        }
        return len;
    }

    @Override
    public boolean zSet() {
        boolean bZSet = this.m_outerRing.zSet();
        Iterator<IRing> iter = this.getInteriorRingIterator();
        while (iter.hasNext() && !bZSet) {
            bZSet = iter.next().zSet();
        }
        return bZSet;
    }

    @Override
    public boolean zAllSet() {
        boolean bZAllSet = this.m_outerRing.zAllSet();
        Iterator<IRing> iter = this.getInteriorRingIterator();
        while (iter.hasNext() && bZAllSet) {
            bZAllSet = iter.next().zAllSet();
        }
        return bZAllSet;
    }

    @Override
    public boolean mSet() {
        boolean bMSet = this.m_outerRing.mSet();
        Iterator<IRing> iter = this.getInteriorRingIterator();
        while (iter.hasNext() && !bMSet) {
            bMSet = iter.next().mSet();
        }
        return bMSet;
    }

    @Override
    public boolean mAllSet() {
        boolean bMAllSet = this.m_outerRing.mAllSet();
        Iterator<IRing> iter = this.getInteriorRingIterator();
        while (iter.hasNext() && bMAllSet) {
            bMAllSet = iter.next().mAllSet();
        }
        return bMAllSet;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public Envelope getEnvelope() {
        return this.m_outerRing.getEnvelope();
    }

    @Override
    public boolean isEmpty() {
        return this.m_outerRing.isEmpty();
    }

    @Override
    public GeometryType getType() {
        return GeometryType.POLYGON;
    }

    @Override
    public SpatialInfo getSpatialInfo() {
        return this.m_spatialInfo;
    }

    @Override
    public CoordSys getCoordSys() {
        return this.m_spatialInfo.getCoordSys();
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    private static class _RingIterator
    implements Iterator<IRing> {
        private final Iterator<Ring> m_iter;

        private _RingIterator(Iterator<Ring> iter) {
            this.m_iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.m_iter.hasNext();
        }

        @Override
        public IRing next() {
            return this.m_iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

