/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.impl;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.GeometryType;
import com.mapinfo.midev.geometry.ICurveSegment;
import com.mapinfo.midev.geometry.IRing;
import com.mapinfo.midev.geometry.InvalidComputationTypeException;
import com.mapinfo.midev.geometry.InvalidGeometryException;
import com.mapinfo.midev.geometry.MeasurementUtilities;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.ClosedCurveSegmentList;
import com.mapinfo.midev.geometry.impl.CurveSegment;
import com.mapinfo.midev.geometry.impl.LineString;
import com.mapinfo.midev.geometry.operations.cartesian.contains.RingContainsPoint;
import com.mapinfo.midev.unit.Area;
import com.mapinfo.midev.unit.ComputationType;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;
import java.util.Iterator;
import java.util.List;

public class Ring
implements IRing {
    private final ClosedCurveSegmentList m_closedCurveSegmentList;
    private final SpatialInfo m_spatialInfo;
    private Length m_sphericalPerimeter = null;
    private Length m_cartesianPerimeter = null;
    private Area m_sphericalArea = null;
    private Area m_cartesianArea = null;

    public Ring(SpatialInfo si, CurveSegment cs) throws InvalidGeometryException {
        this.m_spatialInfo = si;
        this.m_closedCurveSegmentList = new ClosedCurveSegmentList(cs);
    }

    public Ring(SpatialInfo si, List<CurveSegment> curveSegments) throws InvalidGeometryException {
        this.m_spatialInfo = si;
        this.m_closedCurveSegmentList = new ClosedCurveSegmentList(curveSegments);
    }

    private Ring(SpatialInfo si, ClosedCurveSegmentList ccsl) {
        this.m_spatialInfo = si;
        this.m_closedCurveSegmentList = ccsl;
    }

    @Override
    public Area getArea(ComputationType ct) {
        Area area;
        switch (ct) {
            case SPHERICAL: {
                area = this.m_sphericalArea == null ? (this.m_sphericalArea = MeasurementUtilities.area(this, ct)) : this.m_sphericalArea;
                break;
            }
            case CARTESIAN: {
                area = this.m_cartesianArea == null ? (this.m_cartesianArea = MeasurementUtilities.area(this, ct)) : this.m_cartesianArea;
                break;
            }
            default: {
                throw new InvalidComputationTypeException(ct);
            }
        }
        return area;
    }

    @Override
    public Length getPerimeter(ComputationType ct) {
        Length len;
        switch (ct) {
            case SPHERICAL: {
                len = this.m_sphericalPerimeter == null ? (this.m_sphericalPerimeter = MeasurementUtilities.perimeter(this, ct)) : this.m_sphericalPerimeter;
                break;
            }
            case CARTESIAN: {
                len = this.m_cartesianPerimeter == null ? (this.m_cartesianPerimeter = MeasurementUtilities.perimeter(this, ct)) : this.m_cartesianPerimeter;
                break;
            }
            default: {
                throw new InvalidComputationTypeException(ct);
            }
        }
        return len;
    }

    @Override
    public int getCurveSegmentCount() {
        return this.m_closedCurveSegmentList.size();
    }

    @Override
    public ICurveSegment getCurveSegment(int i) {
        return this.m_closedCurveSegmentList.getCurveSegment(i);
    }

    @Override
    public Iterator<ICurveSegment> iterator() {
        return new _CurveSegmentIterator(this.m_closedCurveSegmentList.iterator());
    }

    @Override
    public Ring getCopy() {
        return this.getCopy(this.getSpatialInfo().getCoordSys());
    }

    @Override
    public Ring getCopy(CoordSys csys) {
        SpatialInfo si = this.getSpatialInfo();
        if (!csys.equivalent(si.getCoordSys())) {
            si = new SpatialInfo(csys, this.getSpatialInfo().getZUnit(), this.getSpatialInfo().getToleranceLength());
        }
        return new Ring(si, this.m_closedCurveSegmentList.getCopy(csys));
    }

    @Override
    public Ring reverse() {
        return new Ring(this.getSpatialInfo(), this.m_closedCurveSegmentList.reverse());
    }

    @Override
    public boolean zSet() {
        return this.m_closedCurveSegmentList.zSet();
    }

    @Override
    public boolean zAllSet() {
        return this.m_closedCurveSegmentList.zAllSet();
    }

    @Override
    public boolean mSet() {
        return this.m_closedCurveSegmentList.mSet();
    }

    @Override
    public boolean mAllSet() {
        return this.m_closedCurveSegmentList.mAllSet();
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public Envelope getEnvelope() {
        return this.m_closedCurveSegmentList.getEnvelope();
    }

    @Override
    public boolean isEmpty() {
        return this.m_closedCurveSegmentList.size() == 0;
    }

    @Override
    public GeometryType getType() {
        return GeometryType.RING;
    }

    @Override
    public boolean contains(DirectPosition dp) {
        return RingContainsPoint.containsWithBoundary(this, dp);
    }

    @Override
    public LineString asLineString() {
        return this.m_closedCurveSegmentList.asLineString();
    }

    @Override
    public LineString asLineString(Length maxSpacing, Length maxOffset) {
        return this.m_closedCurveSegmentList.asLineString(maxSpacing, maxOffset);
    }

    @Override
    public DirectPosition getStartPosition() {
        return this.m_closedCurveSegmentList.getStartPosition();
    }

    @Override
    public DirectPosition getEndPosition() {
        return this.m_closedCurveSegmentList.getEndPosition();
    }

    @Override
    public boolean isLinear() {
        return this.m_closedCurveSegmentList.isLinear();
    }

    @Override
    public Length getStartDistance(ComputationType ct) {
        LinearUnit lu = CoordSysUtilities.getLinearUnit((CoordSys)this.getCoordSys());
        if (lu == null) {
            lu = LinearUnit.METER;
        }
        return new Length(0.0, lu, ct);
    }

    @Override
    public Length getEndDistance(ComputationType ct) {
        return this.getPerimeter(ct);
    }

    @Override
    public DirectPosition getPointForDistance(Length len) {
        return MeasurementUtilities.getPointAtDistance(this, len);
    }

    @Override
    public SpatialInfo getSpatialInfo() {
        return this.m_spatialInfo;
    }

    @Override
    public CoordSys getCoordSys() {
        return this.m_spatialInfo.getCoordSys();
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    private static class _CurveSegmentIterator
    implements Iterator<ICurveSegment> {
        private final Iterator<CurveSegment> m_iter;

        private _CurveSegmentIterator(Iterator<CurveSegment> iter) {
            this.m_iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.m_iter.hasNext();
        }

        @Override
        public ICurveSegment next() {
            return this.m_iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

